/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;

public class ExceptionTableConverter {
    private MethodConverter method_converter;

    public ExceptionTableConverter(MethodConverter methodConverter) {
        this.method_converter = methodConverter;
    }

    public JcException[] convert() {
        JMethod jMethod = this.method_converter.getJavaMethod();
        JCodeAttr jCodeAttr = jMethod.getCodeAttr();
        if (jCodeAttr == null) {
            return new JcException[0];
        }
        if (jMethod.getCode() == null) {
            return new JcException[0];
        }
        JExceptionRecord[] jExceptionRecordArray = jCodeAttr.getExceptions();
        JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
        JcException[] jcExceptionArray = new JcException[jExceptionRecordArray.length];
        int n = 0;
        while (n < jcExceptionArray.length) {
            int n2 = jExceptionRecordArray[n].getStartPc();
            int n3 = this.getLabel(n2);
            int n4 = jExceptionRecordArray[n].getEndPc();
            int n5 = this.getLabel(n4);
            int n6 = jExceptionRecordArray[n].getHandlerPc();
            int n7 = this.getLabel(n6);
            String string = jExceptionRecordArray[n].getCatchTypeClass();
            JcConstantClassRef jcConstantClassRef = jcConstantPool.addConstantClassRef(string);
            jcExceptionArray[n] = new JcException(n3, n5, n7, jcConstantClassRef);
            ++n;
        }
        return jcExceptionArray;
    }

    private int getLabel(int n) {
        InstrContainer instrContainer = this.method_converter.getInstrContainers();
        while (instrContainer != null) {
            if (instrContainer.getJInstr().getPC() == n) {
                int n2 = instrContainer.getLabel();
                if (n2 == -1) {
                    throw new ConverterInternalError();
                }
                return n2;
            }
            instrContainer = instrContainer.getNextInstrContainer();
        }
        throw new ConverterInternalError();
    }
}

