/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import java.lang.reflect.Modifier;
import java.util.Vector;

abstract class BaseClassInterfaceConverter {
    JClassFile java_class;
    JcClass jc_class;
    PackageConverter p_converter;

    BaseClassInterfaceConverter(JClassFile jClassFile, PackageConverter packageConverter) {
        this.java_class = jClassFile;
        this.p_converter = packageConverter;
        this.jc_class = new JcClass(jClassFile);
    }

    public JcClass getJcClass() {
        return this.jc_class;
    }

    public JClassFile getJavaClass() {
        return this.java_class;
    }

    String[] determinePublicSuperInterfaces() {
        Object object;
        String[] stringArray = this.jc_class.getSuperInterfaces();
        Vector<Object[]> vector = new Vector<Object[]>(15);
        String string = Names.getPackageName(this.java_class.getClassName());
        int n = 0;
        while (n < stringArray.length) {
            ClassDefinition classDefinition;
            object = stringArray[n];
            if (Names.getPackageName((String)object).equals(string)) {
                classDefinition = this.p_converter.getJcClass((String)object);
                if (classDefinition == null) {
                    throw new ConversionException();
                }
                int n2 = classDefinition.getAccessFlags();
                if (Modifier.isPublic(n2)) {
                    vector.addElement((Object[])object);
                }
            } else {
                classDefinition = this.getExportClass((String)object);
                if (classDefinition == null) {
                    throw new ConversionException();
                }
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    boolean determineShareableType() {
        String[] stringArray = this.jc_class.getPublicSuperInterfaces();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("javacard/framework/Shareable")) {
                return true;
            }
            ++n;
        }
        return this.java_class.getClassName().equals("javacard/framework/Shareable");
    }

    void addInterfaces(Vector vector, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addInterface(vector, stringArray[n]);
            ++n;
        }
    }

    void addInterface(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string2.equals(string)) {
                return;
            }
            ++n;
        }
        vector.addElement(string);
    }

    void intTypeCheck() {
        Object object;
        JField[] jFieldArray = this.java_class.getFields();
        int n = 0;
        while (n < jFieldArray.length) {
            object = jFieldArray[n].getFieldDescriptor();
            if (((String)object).equals("I") || ((String)object).equals("[I")) {
                Object[] objectArray;
                if (this.p_converter.isIntSupported()) {
                    objectArray = new Object[]{this.java_class.getClassName().replace('/', '.'), jFieldArray[n].getFieldName()};
                    Notifier.warning("warning.1", objectArray);
                    this.p_converter.setIntFlag(true);
                } else {
                    objectArray = new Object[]{this.java_class.getClassName().replace('/', '.'), jFieldArray[n].getFieldName()};
                    Notifier.error("int.1", objectArray);
                    throw new ConversionException();
                }
            }
            ++n;
        }
        object = this.java_class.getMethods();
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            Object[] objectArray;
            Object object2 = object[n2];
            String string = ((MethodDefinition)object2).getMethodDescriptor();
            String[] stringArray = MethodDescriptor.getParamDescriptors(string);
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals("I") || stringArray[n3].equals("[I")) {
                    if (this.p_converter.isIntSupported()) {
                        objectArray = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object2).getMethodName()};
                        Notifier.warning("warning.2", objectArray);
                        this.p_converter.setIntFlag(true);
                    } else {
                        objectArray = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object2).getMethodName()};
                        Notifier.error("int.2", objectArray);
                        throw new ConversionException();
                    }
                }
                ++n3;
            }
            objectArray = MethodDescriptor.getReturnDescriptor(string);
            if (objectArray.equals("I") || objectArray.equals("[I")) {
                Object[] objectArray2;
                if (this.p_converter.isIntSupported()) {
                    objectArray2 = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object2).getMethodName()};
                    Notifier.warning("warning.3", objectArray2);
                    this.p_converter.setIntFlag(true);
                } else {
                    objectArray2 = new Object[]{this.java_class.getClassName().replace('/', '.'), ((MethodDefinition)object2).getMethodName()};
                    Notifier.error("int.3", objectArray2);
                    throw new ConversionException();
                }
            }
            ++n2;
        }
    }

    protected EfClass getExportClass(String string) {
        ExportFileManager exportFileManager = this.p_converter.getExportFileManager();
        EfClass efClass = exportFileManager.getClass(string);
        return efClass;
    }
}

