/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.checkers;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.classfile.instructions.JavaByteCode;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.checkers.BCCheckingTable;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;

public class SubsetChecker {
    ConversionProfile conversion_profile;

    public SubsetChecker(ConversionProfile conversionProfile) {
        this.conversion_profile = conversionProfile;
    }

    public void check(JPackage jPackage) {
        JClassFile[] jClassFileArray = jPackage.getClasses();
        int n = 0;
        while (n < jClassFileArray.length) {
            this.checkClass(jClassFileArray[n]);
            ++n;
        }
    }

    private void checkClass(JClassFile jClassFile) {
        JField[] jFieldArray = jClassFile.getFields();
        int n = 0;
        while (n < jFieldArray.length) {
            this.checkField(jFieldArray[n], jClassFile.getClassName());
            ++n;
        }
        JMethod[] jMethodArray = jClassFile.getMethods();
        int n2 = 0;
        while (n2 < jMethodArray.length) {
            this.checkMethod(jMethodArray[n2], jClassFile.getClassName());
            ++n2;
        }
    }

    private void checkField(JField jField, String string) {
        Object[] objectArray;
        int n;
        String string2 = jField.getFieldDescriptor();
        String string3 = jField.getFieldName();
        String string4 = this.checkType(string2);
        if (string4 != null) {
            Object[] objectArray2 = new Object[]{string.replace('/', '.'), string4, string3};
            Notifier.error("subset.1", objectArray2);
        }
        if (Modifier.isVolatile(n = jField.getAccessFlags())) {
            objectArray = new Object[]{string.replace('/', '.'), "volatile", string3};
            Notifier.error("subset.2", objectArray);
        }
        if (Modifier.isTransient(n)) {
            objectArray = new Object[]{string.replace('/', '.'), "transient", string3};
            Notifier.error("subset.2", objectArray);
        }
    }

    private void checkMethod(JMethod jMethod, String string) {
        Object[] objectArray;
        String string2;
        Object[] objectArray2;
        int n = jMethod.getAccessFlags();
        String string3 = jMethod.getMethodName();
        String string4 = jMethod.getMethodDescriptor();
        if (Modifier.isSynchronized(n)) {
            objectArray2 = new Object[]{string.replace('/', '.'), "synchronized", string3};
            Notifier.error("subset.4", objectArray2);
        }
        if (Modifier.isNative(n) && !this.conversion_profile.mask) {
            objectArray2 = new Object[]{string.replace('/', '.'), "native", string3};
            Notifier.error("subset.4", objectArray2);
        }
        objectArray2 = MethodDescriptor.getParamDescriptors(string4);
        int n2 = 0;
        while (n2 < objectArray2.length) {
            string2 = this.checkType(objectArray2[n2]);
            if (string2 != null) {
                objectArray = new Object[]{string.replace('/', '.'), string2, string3};
                Notifier.error("subset.5", objectArray);
            }
            ++n2;
        }
        string2 = MethodDescriptor.getReturnDescriptor(string4);
        objectArray = this.checkType(string2);
        if (objectArray != null && objectArray != null) {
            Object[] objectArray3 = new Object[]{string.replace('/', '.'), objectArray, string3};
            Notifier.error("subset.6", objectArray3);
        }
        this.checkLocalVariables(jMethod, string);
        this.checkByteCodes(jMethod, string);
    }

    private void checkLocalVariables(JMethod jMethod, String string) {
        JCodeAttr jCodeAttr = jMethod.getCodeAttr();
        if (jCodeAttr == null) {
            return;
        }
        JLocalVarTableAttr jLocalVarTableAttr = jCodeAttr.getLocalVarTableAttr();
        if (jLocalVarTableAttr == null) {
            return;
        }
        JLocalVariable[] jLocalVariableArray = jLocalVarTableAttr.getLocalVars();
        int n = 0;
        while (n < jLocalVariableArray.length) {
            JLocalVariable jLocalVariable = jLocalVariableArray[n];
            if (DataType.getType(jLocalVariable.getDescriptor()) == 8) {
                Object[] objectArray = new String[]{string.replace('/', '.'), "char"};
                Notifier.error("subset.40", objectArray);
            }
            ++n;
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    private void checkByteCodes(JMethod jMethod, String string) {
        String string2 = jMethod.getMethodName();
        JInstruction jInstruction = jMethod.getCode();
        while (jInstruction != null) {
            block26: {
                Object[] objectArray;
                int n;
                block28: {
                    block27: {
                        n = jInstruction.getOpcode();
                        if (!string2.equals("<clinit>")) break block27;
                        if (BCCheckingTable.bc_details[n].getClinitSupport() == 2) {
                            objectArray = new Object[]{string.replace('/', '.'), JavaByteCode.getMnemonic(n)};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.20", objectArray);
                            break block28;
                        } else if (BCCheckingTable.bc_details[n].getClinitSupport() == 1) {
                            Object[] objectArray2 = new Object[]{string.replace('/', '.'), JavaByteCode.getMnemonic(n)};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.21", objectArray2);
                        }
                        break block28;
                    }
                    if (!BCCheckingTable.bc_details[n].isJCSupported()) {
                        this.reportErrforUnsupportedByteCode(string, string2, jMethod.getMethodDescriptor(), jInstruction);
                    }
                }
                block0 : switch (n) {
                    case 193: {
                        Object[] objectArray3;
                        objectArray = ((JInstrClassRef)jInstruction).getClassName();
                        Object[] objectArray4 = this.checkType((String)objectArray);
                        if (objectArray4 != null) {
                            objectArray3 = new Object[]{string.replace('/', '.'), objectArray4};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.31", objectArray3);
                        }
                        break;
                    }
                    case 192: {
                        Object[] objectArray3;
                        objectArray = ((JInstrClassRef)jInstruction).getClassName();
                        Object[] objectArray4 = this.checkType((String)objectArray);
                        if (objectArray4 != null) {
                            objectArray3 = new Object[]{string.replace('/', '.'), objectArray4};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.32", objectArray3);
                        }
                        break;
                    }
                    case 188: {
                        Object[] objectArray4;
                        int n2 = ((JInstrByteIndex)jInstruction).getIndex();
                        switch (n2) {
                            case 5: {
                                objectArray4 = new Object[]{string.replace('/', '.'), "char[]"};
                                Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray4);
                                break block0;
                            }
                            case 6: {
                                objectArray4 = new Object[]{string.replace('/', '.'), "float[]"};
                                Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray4);
                                break block0;
                            }
                            case 7: {
                                objectArray4 = new Object[]{string.replace('/', '.'), "double[]"};
                                Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray4);
                                break block0;
                            }
                            case 11: {
                                objectArray4 = new Object[]{string.replace('/', '.'), "long[]"};
                                Notifier.error(jInstruction.getSourceLineNumber(), "subset.33", objectArray4);
                                break block0;
                            }
                            default: {
                                break block26;
                            }
                        }
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        objectArray = (JInstrMethodRef)jInstruction;
                        Object[] objectArray4 = objectArray.getDescriptor();
                        Object[] objectArray3 = objectArray.getClassName();
                        String string3 = objectArray.getMethodName();
                        Object object = MethodDescriptor.getParamDescriptors((String)objectArray4);
                        int n3 = 0;
                        while (true) {
                            Object[] objectArray5;
                            String string4;
                            if (n3 >= ((String[])object).length) {
                                string4 = MethodDescriptor.getReturnDescriptor((String)objectArray4);
                                objectArray5 = this.checkType(string4);
                                if (objectArray5 != null) {
                                    Object[] objectArray6 = new Object[]{string.replace('/', '.'), objectArray5, Names.getMethodNameInJavaStyle(string3, (String)objectArray4), objectArray3.replace('/', '.')};
                                    Notifier.error(jInstruction.getSourceLineNumber(), "subset.35", objectArray6);
                                }
                                break block26;
                            }
                            string4 = this.checkType(object[n3]);
                            if (string4 != null) {
                                objectArray5 = new Object[]{string.replace('/', '.'), string4, Names.getMethodNameInJavaStyle(string3, (String)objectArray4), objectArray3.replace('/', '.')};
                                Notifier.error(jInstruction.getSourceLineNumber(), "subset.34", objectArray5);
                            }
                            ++n3;
                        }
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: {
                        objectArray = (JInstrFieldRef)jInstruction;
                        Object[] objectArray4 = objectArray.getClassName();
                        Object[] objectArray3 = objectArray.getFieldName();
                        String string3 = objectArray.getDescriptor();
                        Object object = this.checkType(string3);
                        if (object != null) {
                            Object[] objectArray7 = new Object[]{string.replace('/', '.'), object, objectArray3, objectArray4.replace('/', '.')};
                            Notifier.error(jInstruction.getSourceLineNumber(), "subset.36", objectArray7);
                        } else {
                            break;
                        }
                    }
                }
            }
            jInstruction = jInstruction.getNextInstr();
        }
    }

    private String checkType(String string) {
        int n = DataType.getType(string);
        switch (n) {
            case 8: {
                return "char";
            }
            case 6: {
                return "double";
            }
            case 5: {
                return "float";
            }
            case 4: {
                return "long";
            }
            case 10: {
                if (DataType.isMultiDimensionArray(string)) {
                    return "multidimension array";
                }
                if (string.equals("Ljava/lang/String;")) {
                    return "String";
                }
                if (string.equals("[Ljava/lang/String;")) {
                    return "String";
                }
                if (string.equals("[C")) {
                    return "char[]";
                }
                if (string.equals("[D")) {
                    return "double[]";
                }
                if (string.equals("[F")) {
                    return "float[]";
                }
                if (!string.equals("[J")) break;
                return "long[]";
            }
        }
        return null;
    }

    private void reportErrforUnsupportedByteCode(String string, String string2, String string3, JInstruction jInstruction) {
        int n = jInstruction.getOpcode();
        int n2 = jInstruction.getSourceLineNumber();
        switch (n) {
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.40", objectArray);
                return;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "float"};
                Notifier.error(n2, "subset.40", objectArray);
                return;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "long"};
                Notifier.error(n2, "subset.40", objectArray);
                return;
            }
            case 14: 
            case 15: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.41", objectArray);
                return;
            }
            case 11: 
            case 12: 
            case 13: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "float"};
                Notifier.error(n2, "subset.41", objectArray);
                return;
            }
            case 9: 
            case 10: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "long"};
                Notifier.error(n2, "subset.41", objectArray);
                return;
            }
            case 18: 
            case 19: 
            case 20: {
                Object[] objectArray;
                int n3 = n == 18 ? ((JInstrCpByteRef)jInstruction).getValueType() : ((JInstrCpShortRef)jInstruction).getValueType();
                if (n3 == 5) {
                    objectArray = new String[]{string.replace('/', '.'), "float"};
                    Notifier.error(n2, "subset.41", objectArray);
                }
                if (n3 == 20) {
                    objectArray = new String[]{string.replace('/', '.'), "String"};
                    Notifier.error(n2, "subset.41", objectArray);
                }
                if (n3 == 4) {
                    objectArray = new String[]{string.replace('/', '.'), "long"};
                    Notifier.error(n2, "subset.41", objectArray);
                }
                if (n3 != 6) break;
                objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.41", objectArray);
                return;
            }
            case 146: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "char"};
                Notifier.error(n2, "subset.42", objectArray);
                return;
            }
            case 135: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "double"};
                Notifier.error(n2, "subset.43", objectArray);
                return;
            }
            case 134: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "float"};
                Notifier.error(n2, "subset.43", objectArray);
                return;
            }
            case 133: {
                Object[] objectArray = new String[]{string.replace('/', '.'), "long"};
                Notifier.error(n2, "subset.43", objectArray);
                return;
            }
            case 194: 
            case 195: {
                Notifier.error(n2, "subset.44", string.replace('/', '.'));
                return;
            }
            case 197: {
                Notifier.error(n2, "subset.45", string.replace('/', '.'));
                return;
            }
            case 200: 
            case 201: {
                Object[] objectArray = new String[]{string.replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3)};
                Notifier.error("subset.46", objectArray);
                return;
            }
        }
    }

    public void check(JcPackage jcPackage) {
        JcClass[] jcClassArray = jcPackage.getClasses();
        if (jcClassArray.length > 255) {
            Notifier.error("subset.10", jcPackage.getPackageName());
        }
        int n = 0;
        while (n < jcClassArray.length) {
            this.checkClass(jcClassArray[n]);
            ++n;
        }
        this.checkAccessControl(jcPackage);
    }

    private void checkClass(JcClass jcClass) {
        int n;
        String string = jcClass.getClassName();
        if (jcClass.getSuperInterfaces().length > 15) {
            if (jcClass.isInterfaceType()) {
                Notifier.error("subset.9", string.replace('/', '.'));
            } else {
                Notifier.error("subset.8", string.replace('/', '.'));
            }
        }
        int n2 = 0;
        int n3 = 0;
        JcField[] jcFieldArray = jcClass.getFields();
        int n4 = 0;
        while (n4 < jcFieldArray.length) {
            int n5 = jcFieldArray[n4].getAccessFlags();
            if (Modifier.isStatic(n5)) {
                if (Modifier.isPublic(n5) || Modifier.isProtected(n5)) {
                    ++n2;
                }
            } else {
                String string2 = jcFieldArray[n4].getFieldDescriptor();
                n3 = DataType.getType(string2) == 3 ? (n3 += 2) : ++n3;
            }
            ++n4;
        }
        if (n2 > 256) {
            Notifier.error("subset.11", string.replace('/', '.'));
        }
        if (n3 > 255) {
            Notifier.error("subset.12", string.replace('/', '.'));
        }
        JcMethod[] jcMethodArray = jcClass.getMethods();
        int n6 = 0;
        int n7 = 0;
        while (n7 < jcMethodArray.length) {
            n = jcMethodArray[n7].getAccessFlags();
            if (Modifier.isStatic(n)) {
                if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
                    ++n6;
                }
            } else if (jcMethodArray[n7].getMethodName().equals("<init>") && (Modifier.isPublic(n) || Modifier.isProtected(n))) {
                ++n6;
            }
            ++n7;
        }
        if (n6 > 256) {
            Notifier.error("subset.13", string.replace('/', '.'));
        }
        if (jcClass.getPublicMethodTable().getMethods().length > 128) {
            Notifier.error("subset.14", string.replace('/', '.'));
        }
        if (jcClass.getPackageMethodTable().getMethods().length > 128) {
            Notifier.error("subset.15", string.replace('/', '.'));
        }
        n = 0;
        while (n < jcMethodArray.length) {
            this.checkMethod(jcMethodArray[n], string);
            ++n;
        }
    }

    private void checkAccessControl(JcPackage jcPackage) {
        JcClass[] jcClassArray = jcPackage.getClasses();
        int n = 0;
        while (n < jcClassArray.length) {
            Object object;
            String[] stringArray;
            JcClass jcClass = jcClassArray[n];
            if (jcClass.isInterfaceType()) {
                if (Modifier.isPublic(jcClass.getAccessFlags())) {
                    stringArray = jcClass.getSuperInterfaces();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        int n3;
                        object = jcPackage.getClass(stringArray[n2]);
                        if (object != null && !Modifier.isPublic(n3 = ((ClassDefinition)object).getAccessFlags())) {
                            Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), ((ClassDefinition)object).getClassName().replace('/', '.')};
                            Notifier.error("subset.50", objectArray);
                        }
                        ++n2;
                    }
                }
            } else {
                JcClass jcClass2;
                stringArray = jcClass.getSuperClassName();
                if (stringArray != null && (jcClass2 = jcPackage.getClass((String)stringArray)) != null) {
                    object = jcClass.getMethods();
                    MethodDefinition[] methodDefinitionArray = jcClass2.getPackageMethodTable().getMethods();
                    int n4 = 0;
                    while (n4 < ((Object)object).length) {
                        Object object2 = object[n4];
                        int n5 = ((MethodDefinition)object2).getAccessFlags();
                        if (Modifier.isPublic(n5) || Modifier.isProtected(n5)) {
                            int n6 = 0;
                            while (n6 < methodDefinitionArray.length) {
                                MethodDefinition methodDefinition = methodDefinitionArray[n6];
                                if (((MethodDefinition)object2).getMethodSignature().equals(methodDefinition.getMethodSignature())) {
                                    Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(((MethodDefinition)object2).getMethodName(), ((MethodDefinition)object2).getMethodDescriptor())};
                                    Notifier.error("subset.51", objectArray);
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n;
        }
    }

    private void checkMethod(JcMethod jcMethod, String string) {
        String string2 = jcMethod.getMethodName();
        if (jcMethod.getMaxLocals() + jcMethod.getNargs() > 255) {
            Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
            Notifier.error("subset.16", objectArray);
        }
        this.checkByteCode(jcMethod, string);
    }

    private void checkByteCode(JcMethod jcMethod, String string) {
        JcInstruction jcInstruction = jcMethod.getCode();
        String string2 = jcMethod.getMethodName();
        int n = 0;
        while (jcInstruction != null) {
            n += jcInstruction.getSizeInBytes();
            int n2 = jcInstruction.getOpcode();
            switch (n2) {
                case 117: 
                case 118: {
                    int n3 = ((JcInstrLookupSwitch)jcInstruction).getNumMatchPairs();
                    if (n3 <= 65536) break;
                    Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
                    Notifier.error("subset.18", objectArray);
                    break;
                }
                case 115: 
                case 116: {
                    JcInstrTableSwitch jcInstrTableSwitch = (JcInstrTableSwitch)jcInstruction;
                    int n4 = jcInstrTableSwitch.getHighValue() - jcInstrTableSwitch.getLowValue() + 1;
                    if (n4 <= 65536) break;
                    Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
                    Notifier.error("subset.18", objectArray);
                }
            }
            jcInstruction = jcInstruction.getNextInstr();
        }
        if (n > Short.MAX_VALUE) {
            Object[] objectArray = new Object[]{string.replace('/', '.'), string2};
            Notifier.error("subset.17", objectArray);
        }
    }
}

