/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.checkers;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.basicstructure.FieldDefinition;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImportTokenTable;
import com.sun.javacard.jcfile.JcImportTokenTableEntry;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstant;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class ReferenceChecker {
    private static final int NO_LINE_NUMBER = -1;
    private JcPackage jc_package;
    private JcImportTokenTable token_table;
    private String this_package_name;
    private ExportFileManager ex_manager;
    private boolean check_export_only;

    public ReferenceChecker(JcPackage jcPackage, ExportFileManager exportFileManager, boolean bl) {
        this.jc_package = jcPackage;
        this.this_package_name = jcPackage.getPackageName();
        this.token_table = new JcImportTokenTable();
        this.ex_manager = exportFileManager;
        this.check_export_only = bl;
    }

    public void check() {
        PackageDefinition[] packageDefinitionArray;
        JcClass[] jcClassArray = this.jc_package.getClasses();
        int n = 0;
        while (n < jcClassArray.length) {
            packageDefinitionArray = jcClassArray[n];
            this.checkClass((JcClass)packageDefinitionArray);
            ++n;
        }
        packageDefinitionArray = this.constructImportPackageInfos();
        this.token_table.setImportPackageInfos(packageDefinitionArray);
        this.jc_package.setImportTokenTable(this.token_table);
    }

    private void checkClass(JcClass jcClass) {
        int n = jcClass.getAccessFlags();
        if (!this.check_export_only || Modifier.isPublic(n)) {
            int n2;
            Object object;
            Object object2;
            String string = jcClass.getSuperClassName();
            if (string != null) {
                if (Names.getPackageName(string).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(string) == null) {
                        object2 = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                        Notifier.error("linking.3", (Object[])object2);
                    }
                } else {
                    object2 = this.ex_manager.getClass(string);
                    if (object2 == null) {
                        Object[] objectArray = new String[3];
                        objectArray[0] = jcClass.getClassName().replace('/', '.');
                        objectArray[1] = string.replace('/', '.');
                        Object[] objectArray2 = Names.getPackageName(string);
                        objectArray[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray2)) + ".exp");
                        objectArray2 = objectArray;
                        Notifier.error("linking.2", objectArray2);
                    } else {
                        this.token_table.addClassEntry(string, ((ClassDefinition)object2).getClassToken());
                    }
                }
            }
            this.checkSuperInterfaces(jcClass);
            object2 = jcClass.getFields();
            int n3 = 0;
            while (n3 < ((JcField[])object2).length) {
                object = object2[n3];
                n2 = ((FieldDefinition)object).getAccessFlags();
                if (!this.check_export_only || Modifier.isPublic(n2) || Modifier.isProtected(n2)) {
                    this.checkFieldDescriptor(jcClass, jcClass.getClassName(), ((FieldDefinition)object).getFieldName(), ((FieldDefinition)object).getFieldDescriptor(), -1);
                }
                ++n3;
            }
            object = jcClass.getMethods();
            n2 = 0;
            while (n2 < ((Object)object).length) {
                Object object3 = object[n2];
                int n4 = ((MethodDefinition)object3).getAccessFlags();
                if (!this.check_export_only || Modifier.isPublic(n4) || Modifier.isProtected(n4)) {
                    this.checkMethodDescriptor(jcClass, jcClass.getClassName(), ((MethodDefinition)object3).getMethodName(), ((MethodDefinition)object3).getMethodDescriptor(), -1);
                }
                if (!this.check_export_only) {
                    this.checkBytecode(jcClass, (JcMethod)object3);
                    this.checkExceptionTable(jcClass, (JcMethod)object3);
                }
                ++n2;
            }
        }
    }

    private void checkSuperInterfaces(JcClass jcClass) {
        String[] stringArray = this.check_export_only ? jcClass.getPublicSuperInterfaces() : jcClass.getSuperInterfaces();
        int n = 0;
        while (n < stringArray.length) {
            Object[] objectArray;
            String string = stringArray[n];
            if (Names.getPackageName(string).equals(this.this_package_name)) {
                if (this.jc_package.getClass(string) == null) {
                    objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                    Notifier.error("linking.5", objectArray);
                }
            } else {
                objectArray = this.ex_manager.getClass(string);
                if (objectArray == null) {
                    Object[] objectArray2 = new String[3];
                    objectArray2[0] = jcClass.getClassName().replace('/', '.');
                    objectArray2[1] = string.replace('/', '.');
                    Object[] objectArray3 = Names.getPackageName(string);
                    objectArray2[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray3)) + ".exp");
                    objectArray3 = objectArray2;
                    Notifier.error("linking.4", objectArray3);
                } else {
                    this.token_table.addClassEntry(string, objectArray.getClassToken());
                }
            }
            ++n;
        }
    }

    private void checkField(JcClass jcClass, String string, String string2, String string3, int n) {
        if (Names.getPackageName(string).equals(this.this_package_name)) {
            JcClass jcClass2 = this.jc_package.getClass(string);
            if (jcClass2 == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                Notifier.error(n, "linking.7", objectArray);
                Object[] objectArray2 = new String[]{jcClass.getClassName().replace('/', '.'), string2, string.replace('/', '.')};
                Notifier.error(n, "linking.13", objectArray2);
                return;
            }
            if (this.jc_package.getField(string, string2, string3) == null) {
                int n2 = jcClass2.getAccessFlags();
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string2, string.replace('/', '.')};
                if (Modifier.isInterface(n2)) {
                    Notifier.error(n, "linking.19", objectArray);
                    return;
                }
                Notifier.error(n, "linking.13", objectArray);
                return;
            }
        } else {
            EfClass efClass = this.ex_manager.getClass(string);
            if (efClass == null) {
                Object[] objectArray = new String[3];
                objectArray[0] = jcClass.getClassName().replace('/', '.');
                objectArray[1] = string.replace('/', '.');
                Object[] objectArray3 = Names.getPackageName(string);
                objectArray[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray3)) + ".exp");
                objectArray3 = objectArray;
                Notifier.error(n, "linking.6", objectArray3);
                jcClass.getClassName().replace('/', '.');
                string.replace('/', '.');
                String string4 = Names.getPackageName(string);
                new String(String.valueOf(Names.getPartialPackageName(string4)) + ".exp");
                Notifier.error(n, "linking.12", objectArray3);
                return;
            }
            EfField efField = this.ex_manager.getField(string, string2, string3);
            if (efField == null) {
                Object[] objectArray = new Object[4];
                objectArray[0] = jcClass.getClassName().replace('/', '.');
                objectArray[1] = string2;
                objectArray[2] = string.replace('/', '.');
                Object[] objectArray4 = Names.getPackageName(string);
                objectArray[3] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray4)) + ".exp");
                objectArray4 = objectArray;
                int n3 = efClass.getAccessFlags();
                if (Modifier.isInterface(n3)) {
                    Notifier.error(n, "linking.18", objectArray4);
                    return;
                }
                Notifier.error(n, "linking.12", objectArray4);
                return;
            }
            this.token_table.addFieldEntry(string, efClass.getClassToken(), string2, efField.getFieldToken());
        }
    }

    private void checkFieldDescriptor(JcClass jcClass, String string, String string2, String string3, int n) {
        String string4 = Names.getClassNameFromDescriptor(string3);
        if (string4 == null) {
            return;
        }
        if (Names.getPackageName(string4).equals(this.this_package_name)) {
            if (this.jc_package.getClass(string4) == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string4.replace('/', '.'), String.valueOf(string.replace('/', '.')) + "." + string2};
                Notifier.error(n, "linking.14", objectArray);
                return;
            }
        } else {
            EfClass efClass = this.ex_manager.getClass(string4);
            if (efClass == null) {
                Object[] objectArray = new String[3];
                objectArray[0] = jcClass.getClassName().replace('/', '.');
                objectArray[1] = string4.replace('/', '.');
                Object[] objectArray2 = Names.getPackageName(string4);
                objectArray[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray2)) + ".exp");
                objectArray2 = objectArray;
                Notifier.error(n, "linking.6", objectArray2);
                Object[] objectArray3 = new String[]{jcClass.getClassName().replace('/', '.'), string4.replace('/', '.'), String.valueOf(string.replace('/', '.')) + "." + string2};
                Notifier.error(n, "linking.14", objectArray3);
                return;
            }
            this.token_table.addClassEntry(string4, efClass.getClassToken());
        }
    }

    private void checkMethod(JcClass jcClass, String string, String string2, String string3, int n) {
        if (Names.getPackageName(string).equals(this.this_package_name)) {
            JcClass jcClass2 = this.jc_package.getClass(string);
            if (jcClass2 == null) {
                Object[] objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                Notifier.error(n, "linking.7", objectArray);
                Object[] objectArray2 = new Object[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.')};
                Notifier.error(n, "linking.9", objectArray2);
                return;
            }
            if (this.jc_package.getMethod(string, string2, string3) == null && !this.checkMethodTable(jcClass2, string2, string3)) {
                Object[] objectArray = new Object[]{jcClass.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(string2, string3), string.replace('/', '.')};
                int n2 = jcClass2.getAccessFlags();
                if (Modifier.isInterface(n2)) {
                    Notifier.error(n, "linking.17", objectArray);
                    return;
                }
                Notifier.error(n, "linking.9", objectArray);
                return;
            }
        } else {
            EfClass efClass = this.ex_manager.getClass(string);
            if (efClass == null) {
                Object[] objectArray = new String[3];
                objectArray[0] = jcClass.getClassName().replace('/', '.');
                objectArray[1] = string.replace('/', '.');
                Object[] objectArray3 = Names.getPackageName(string);
                objectArray[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray3)) + ".exp");
                objectArray3 = objectArray;
                Notifier.error(n, "linking.6", objectArray3);
                Object[] objectArray4 = new String[4];
                objectArray4[0] = jcClass.getClassName().replace('/', '.');
                objectArray4[1] = Names.getMethodNameInJavaStyle(string2, string3);
                objectArray4[2] = string.replace('/', '.');
                Object[] objectArray5 = Names.getPackageName(string);
                objectArray4[3] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray5)) + ".exp");
                objectArray5 = objectArray4;
                Notifier.error(n, "linking.8", objectArray5);
                return;
            }
            EfMethod efMethod = this.ex_manager.getMethod(string, string2, string3);
            if (efMethod == null) {
                Object[] objectArray = new String[4];
                objectArray[0] = jcClass.getClassName().replace('/', '.');
                objectArray[1] = Names.getMethodNameInJavaStyle(string2, string3);
                objectArray[2] = string.replace('/', '.');
                Object[] objectArray6 = Names.getPackageName(string);
                objectArray[3] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray6)) + ".exp");
                objectArray6 = objectArray;
                int n3 = efClass.getAccessFlags();
                if (Modifier.isInterface(n3)) {
                    Notifier.error(n, "linking.18", objectArray6);
                    return;
                }
                Notifier.error(n, "linking.8", objectArray6);
                return;
            }
            this.token_table.addMethodEntry(string, efClass.getClassToken(), string2, string3, efMethod.getMethodToken());
        }
    }

    private boolean checkMethodTable(JcClass jcClass, String string, String string2) {
        MethodDefinition[] methodDefinitionArray = jcClass.getPublicMethodTable().getMethods();
        int n = 0;
        while (n < methodDefinitionArray.length) {
            if (methodDefinitionArray[n].getMethodName().equals(string) && methodDefinitionArray[n].getMethodDescriptor().equals(string2)) {
                return true;
            }
            ++n;
        }
        MethodDefinition[] methodDefinitionArray2 = jcClass.getPackageMethodTable().getMethods();
        int n2 = 0;
        while (n2 < methodDefinitionArray2.length) {
            if (methodDefinitionArray2[n2].getMethodName().equals(string) && methodDefinitionArray2[n2].getMethodDescriptor().equals(string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void checkMethodDescriptor(JcClass jcClass, String string, String string2, String string3, int n) {
        Object[] objectArray;
        Object object;
        Object object2;
        String string4;
        String[] stringArray = MethodDescriptor.getParamDescriptors(string3);
        int n2 = 0;
        while (n2 < stringArray.length) {
            string4 = Names.getClassNameFromDescriptor(stringArray[n2]);
            if (string4 != null) {
                if (Names.getPackageName(string4).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(string4) == null) {
                        object2 = new String[]{jcClass.getClassName().replace('/', '.'), string4.replace('/', '.'), String.valueOf(string.replace('/', '.')) + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                        Notifier.error(n, "linking.10", object2);
                    }
                } else {
                    object2 = this.ex_manager.getClass(string4);
                    if (object2 == null) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = jcClass.getClassName().replace('/', '.');
                        stringArray2[1] = string4.replace('/', '.');
                        object = Names.getPackageName(string4);
                        stringArray2[2] = new String(String.valueOf(Names.getPartialPackageName((String)object)) + ".exp");
                        object = stringArray2;
                        Notifier.error(n, "linking.6", object);
                        objectArray = new String[]{jcClass.getClassName().replace('/', '.'), string4.replace('/', '.'), String.valueOf(string.replace('/', '.')) + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                        Notifier.error(n, "linking.10", objectArray);
                    } else {
                        this.token_table.addClassEntry(string4, object2.getClassToken());
                    }
                }
            }
            ++n2;
        }
        string4 = MethodDescriptor.getReturnDescriptor(string3);
        object2 = Names.getClassNameFromDescriptor(string4);
        if (object2 != null) {
            if (Names.getPackageName((String)object2).equals(this.this_package_name)) {
                if (this.jc_package.getClass((String)object2) == null) {
                    object = new Object[]{jcClass.getClassName().replace('/', '.'), object2.replace('/', '.'), String.valueOf(string.replace('/', '.')) + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                    Notifier.error(n, "linking.11", object);
                    return;
                }
            } else {
                object = this.ex_manager.getClass((String)object2);
                if (object == null) {
                    Object[] objectArray2 = new String[3];
                    objectArray2[0] = jcClass.getClassName().replace('/', '.');
                    objectArray2[1] = object2.replace('/', '.');
                    objectArray = Names.getPackageName((String)object2);
                    objectArray2[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray)) + ".exp");
                    objectArray = objectArray2;
                    Notifier.error(n, "linking.6", objectArray);
                    Object[] objectArray3 = new Object[]{jcClass.getClassName().replace('/', '.'), object2.replace('/', '.'), String.valueOf(string.replace('/', '.')) + "." + Names.getMethodNameInJavaStyle(string2, string3)};
                    Notifier.error(n, "linking.11", objectArray3);
                    return;
                }
                this.token_table.addClassEntry((String)object2, object.getClassToken());
            }
        }
    }

    private void checkBytecode(JcClass jcClass, JcMethod jcMethod) {
        JcInstruction jcInstruction = jcMethod.getCode();
        while (jcInstruction != null) {
            Object[] objectArray;
            Object object;
            String string;
            JcConstant jcConstant;
            int n = jcInstruction.getSourceLineNumber();
            if (jcInstruction instanceof JcInstrClassRef && (jcConstant = ((JcInstrClassRef)jcInstruction).getClassRef()) != null) {
                string = ((JcConstantClassRef)jcConstant).getClassName();
                if (Names.getPackageName(string).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(string) == null) {
                        object = new String[]{jcClass.getClassName().replace('/', '.'), string.replace('/', '.')};
                        if (jcInstruction instanceof JcInstrInterfaceRef) {
                            Notifier.error(n, "linking.21", object);
                        } else {
                            Notifier.error(n, "linking.7", object);
                        }
                    }
                } else {
                    object = this.ex_manager.getClass(string);
                    if (object == null) {
                        Object[] objectArray2 = new String[3];
                        objectArray2[0] = jcClass.getClassName().replace('/', '.');
                        objectArray2[1] = string.replace('/', '.');
                        objectArray = Names.getPackageName(string);
                        objectArray2[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray)) + ".exp");
                        objectArray = objectArray2;
                        if (jcInstruction instanceof JcInstrInterfaceRef) {
                            Notifier.error(n, "linking.20", objectArray);
                        } else {
                            Notifier.error(n, "linking.6", objectArray);
                        }
                    } else {
                        this.token_table.addClassEntry(string, object.getClassToken());
                    }
                }
            }
            if (jcInstruction instanceof JcInstrFieldRef) {
                jcConstant = ((JcInstrFieldRef)jcInstruction).getFieldRef();
                string = ((JcConstantFieldRef)jcConstant).getClassName();
                object = ((JcConstantFieldRef)jcConstant).getFieldName();
                objectArray = ((JcConstantFieldRef)jcConstant).getDescriptor();
                this.checkField(jcClass, string, (String)object, (String)objectArray, n);
                this.checkFieldDescriptor(jcClass, string, (String)object, (String)objectArray, n);
            }
            if (jcInstruction instanceof JcInstrMethodRef) {
                jcConstant = ((JcInstrMethodRef)jcInstruction).getMethodRef();
                string = ((JcConstantMethodRef)jcConstant).getClassName();
                object = ((JcConstantMethodRef)jcConstant).getMethodName();
                objectArray = ((JcConstantMethodRef)jcConstant).getDescriptor();
                this.checkMethod(jcClass, string, (String)object, (String)objectArray, n);
                this.checkMethodDescriptor(jcClass, string, (String)object, (String)objectArray, n);
            }
            jcInstruction = jcInstruction.getNextInstr();
        }
    }

    private void checkExceptionTable(JcClass jcClass, JcMethod jcMethod) {
        JcException[] jcExceptionArray = jcMethod.getExceptions();
        int n = 0;
        while (n < jcExceptionArray.length) {
            String string = jcExceptionArray[n].getCatchTypeClassRef().getClassName();
            if (!string.equals("finally")) {
                Object[] objectArray;
                if (Names.getPackageName(string).equals(this.this_package_name)) {
                    if (this.jc_package.getClass(string) == null) {
                        objectArray = new Object[]{jcClass.getClassName().replace('/', '.'), string.replace('/', ',')};
                        Notifier.error(-1, "linking.15", objectArray);
                    }
                } else {
                    objectArray = this.ex_manager.getClass(string);
                    if (objectArray == null) {
                        Object[] objectArray2 = new String[3];
                        objectArray2[0] = jcClass.getClassName().replace('/', '.');
                        objectArray2[1] = string.replace('/', ',');
                        Object[] objectArray3 = Names.getPackageName(string);
                        objectArray2[2] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray3)) + ".exp");
                        objectArray3 = objectArray2;
                        Notifier.error("linking.6", objectArray3);
                        Object[] objectArray4 = new Object[]{jcClass.getClassName().replace('/', '.'), string.replace('/', ',')};
                        Notifier.error(-1, "linking.15", objectArray4);
                    } else {
                        this.token_table.addClassEntry(string, objectArray.getClassToken());
                    }
                }
            }
            ++n;
        }
    }

    private PackageDefinition[] constructImportPackageInfos() {
        Object object;
        JcImportTokenTableEntry[] jcImportTokenTableEntryArray = this.token_table.getEntries();
        Vector<Object[]> vector = new Vector<Object[]>(20);
        int n = 0;
        while (n < jcImportTokenTableEntryArray.length) {
            if (jcImportTokenTableEntryArray[n].getType() == 0) {
                object = this.ex_manager.getExportFile(jcImportTokenTableEntryArray[n].getName());
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = new PackageDefinition[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }
}

