/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.checkers.ReferenceChecker;
import com.sun.javacard.converter.checkers.SubsetChecker;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.efbuilder.ExportFileBuilder;
import com.sun.javacard.converter.jcawriter.JcaWriter;
import com.sun.javacard.converter.optimizers.Optimizer;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcPackage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Converter {
    public static final byte CONVERTER_MAJOR_VERSION = 1;
    public static final byte CONVERTER_MINOR_VERSION = 0;
    public static final byte CAP_MAJOR_VERSION = 2;
    public static final byte CAP_MINOR_VERSION = 1;
    public static final byte EXP_MAJOR_VERSION = 2;
    public static final byte EXP_MINOR_VERSION = 1;
    public static final byte JCA_MAJOR_VERSION = 2;
    public static final byte JCA_MINOR_VERSION = 1;
    public static final int SUPPORTED_CLASSFILE_MAJOR_VERSION = 45;
    public static final int MIN_SUPPORTED_CLASSFILE_MINOR_VERSION = 0;
    public static final int MAX_SUPPORTED_CLASSFILE_MINOR_VERSION = 65535;
    private ConversionProfile conversion_profile;
    private JPackage java_package;
    private JcPackage jc_package;
    private ExportFileManager export_file_manager;

    public static void main(String[] stringArray) {
        try {
            ConversionProfile conversionProfile = new ConversionProfile();
            conversionProfile.parse(stringArray);
            Notifier.newLine();
            Notifier.out("converter.version", String.valueOf(1) + "." + 0);
            Notifier.out("converter.copyright");
            Notifier.newLine();
            Converter converter = new Converter(conversionProfile);
            converter.convert();
            Notifier.newLine();
            Object[] objectArray = new Object[]{String.valueOf(Notifier.getErrorCount()), String.valueOf(Notifier.getWarningCount())};
            Notifier.out("out.1", objectArray);
        }
        catch (ConverterInternalError converterInternalError) {
            Notifier.error("error.1");
            converterInternalError.printStackTrace();
            System.exit(1);
        }
        catch (ConverterException converterException) {
            Notifier.newLine();
            Object[] objectArray = new Object[]{String.valueOf(Notifier.getErrorCount()), String.valueOf(Notifier.getWarningCount())};
            Notifier.out("out.1", objectArray);
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public Converter(ConversionProfile conversionProfile) {
        this.conversion_profile = conversionProfile;
        this.export_file_manager = new ExportFileManager(conversionProfile.export_path);
    }

    public void convert() {
        Object object;
        if (this.conversion_profile.this_exp_provided) {
            object = this.export_file_manager.load(this.conversion_profile.package_profile.package_name);
            this.checkBinaryCompatibility((EfExportFile)object);
        }
        this.java_package = new JPackage(this.conversion_profile.package_profile.package_name);
        this.java_package.parse(this.conversion_profile.classes);
        this.java_package.resolve();
        if (this.java_package.getClasses().length == 0) {
            Notifier.error("conversion.0", this.java_package.getPackageName().replace('/', '.'));
        }
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        this.checkClassFileVersion();
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        object = new SubsetChecker(this.conversion_profile);
        ((SubsetChecker)object).check(this.java_package);
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        PackageConverter packageConverter = new PackageConverter(this.java_package, this.conversion_profile, this.export_file_manager);
        this.jc_package = packageConverter.convert();
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        boolean bl = false;
        if (this.conversion_profile.output == 2) {
            bl = true;
        }
        ReferenceChecker referenceChecker = new ReferenceChecker(this.jc_package, this.export_file_manager, bl);
        referenceChecker.check();
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        ((SubsetChecker)object).check(this.jc_package);
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        Optimizer optimizer = new Optimizer(this.jc_package);
        this.jc_package = optimizer.optimize();
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        File file = this.determineOutputPath();
        if ((this.conversion_profile.output & 2) != 0) {
            ExportFileBuilder exportFileBuilder = new ExportFileBuilder(this.jc_package, this.conversion_profile);
            EfExportFile efExportFile = exportFileBuilder.build();
            this.outputExportFile(efExportFile, file);
        }
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
        if ((this.conversion_profile.output & 4) != 0) {
            this.outputJCAFile(file);
        }
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
    }

    private void checkBinaryCompatibility(EfExportFile efExportFile) {
        if (efExportFile.getPackageMajorVersion() != this.conversion_profile.package_profile.major_version) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = efExportFile.getPackageName();
            objectArray[0] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray2)) + ".exp");
            objectArray[1] = "major";
            objectArray[2] = "major";
            objectArray2 = objectArray;
            Notifier.error("binary.2", objectArray2);
            throw new ConverterException();
        }
        if (efExportFile.getPackageMinorVersion() != this.conversion_profile.package_profile.minor_version) {
            Object[] objectArray = new Object[3];
            Object[] objectArray3 = efExportFile.getPackageName();
            objectArray[0] = new String(String.valueOf(Names.getPartialPackageName((String)objectArray3)) + ".exp");
            objectArray[1] = "minor";
            objectArray[2] = "minor";
            objectArray3 = objectArray;
            Notifier.error("binary.2", objectArray3);
            throw new ConverterException();
        }
    }

    private void checkClassFileVersion() {
        JClassFile[] jClassFileArray = this.java_package.getClasses();
        int n = 0;
        while (n < jClassFileArray.length) {
            Object[] objectArray;
            int n2 = jClassFileArray[n].getMajorVersion();
            int n3 = jClassFileArray[n].getMinorVersion();
            String string = String.valueOf(String.valueOf(n2)) + "." + String.valueOf(n3);
            if (n2 != 45) {
                objectArray = new String[]{jClassFileArray[n].getClassName().replace('/', '.'), string};
                Notifier.error("conversion.3", objectArray);
            }
            if (n3 < 0 || n3 > 65535) {
                objectArray = new String[]{jClassFileArray[n].getClassName().replace('/', '.'), string};
                Notifier.error("conversion.3", objectArray);
            }
            ++n;
        }
    }

    private File determineOutputPath() {
        String string = this.conversion_profile.output_dir;
        String string2 = this.conversion_profile.package_profile.package_name;
        char c = File.separatorChar;
        String string3 = String.valueOf(string2.replace('/', c)) + c + "javacard";
        File file = new File(string, string3);
        if (file.isFile()) {
            Notifier.error("converter.2");
            throw new ConverterException();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private void outputExportFile(EfExportFile efExportFile, File file) {
        String string = efExportFile.getPackageName();
        File file2 = new File(file, string = new String(String.valueOf(Names.getPartialPackageName(string)) + ".exp"));
        if (file2.isFile() && !file2.canWrite()) {
            Notifier.error("converter.3", string);
            throw new ConverterException();
        }
        try {
            Notifier.progress("progress.3", file2.getCanonicalPath());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            efExportFile.toBinary(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", string);
            throw new ConverterException();
        }
    }

    private void outputJCAFile(File file) {
        JcaWriter jcaWriter = new JcaWriter(this.jc_package, this.conversion_profile, this.export_file_manager);
        String string = this.jc_package.getPackageName();
        File file2 = new File(file, string = new String(String.valueOf(Names.getPartialPackageName(string)) + ".jca"));
        if (file2.isFile() && !file2.canWrite()) {
            Notifier.error("converter.3", string);
            throw new ConverterException();
        }
        try {
            Notifier.progress("progress.3", file2.getCanonicalPath());
            PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file2)));
            jcaWriter.write(printWriter);
            return;
        }
        catch (IOException iOException) {
            Notifier.error("converter.4", string);
            throw new ConverterException();
        }
    }

    private void checkError() {
        if (Notifier.getErrorCount() != 0) {
            throw new ConverterException();
        }
    }
}

