/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter;

import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.util.ClassFileNameFilter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConversionProfile {
    public static final byte OUTPUT_CAP_FILE = 1;
    public static final byte OUTPUT_EXP_FILE = 2;
    public static final byte OUTPUT_JCA_FILE = 4;
    public boolean int_supported = false;
    public boolean this_exp_provided = false;
    public boolean debug = false;
    public boolean profile = false;
    public boolean verify = false;
    public boolean mask = false;
    public int output;
    public String[] export_path;
    public String class_root;
    public File[] classes;
    public String output_dir;
    public PackageProfile package_profile;
    public AppletProfile[] applets_profile;

    public void parse(String[] stringArray) {
        try {
            if (stringArray == null || stringArray.length == 0) {
                ConversionProfile.usage();
                System.exit(1);
            }
            if (stringArray[0].equals("-config")) {
                this.parseOptionsFromFile(stringArray);
            } else {
                this.parseOptionsFromCommandLine(stringArray);
            }
            if (this.package_profile == null) {
                ConversionProfile.usage();
                System.exit(1);
            }
            if (this.class_root == null) {
                this.class_root = new String(System.getProperty("user.dir"));
            }
            this.enumerateClasses();
            if (this.output == 0) {
                this.output |= 4;
                this.output |= 2;
            }
            if (this.output_dir == null) {
                this.output_dir = this.class_root;
            }
            if (this.export_path == null) {
                String string = System.getProperty("java.class.path");
                this.export_path = Strings.toStrings(string, File.pathSeparator);
            }
            if (this.applets_profile == null) {
                this.applets_profile = new AppletProfile[0];
                return;
            }
        }
        catch (Exception exception) {
            ConversionProfile.usage();
            System.exit(1);
        }
    }

    private void parseOptionsFromFile(String[] stringArray) {
        Object[] objectArray;
        String string = stringArray[1];
        Vector<String> vector = new Vector<String>(20);
        try {
            String string2;
            objectArray = new LineNumberReader(new InputStreamReader(new FileInputStream(string)));
            while ((string2 = objectArray.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Notifier.error("converter.0", string);
            ConversionProfile.usage();
            System.exit(1);
        }
        catch (IOException iOException) {
            Notifier.error("converter.1", string);
            ConversionProfile.usage();
            System.exit(1);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.parseOptionsFromCommandLine((String[])objectArray);
    }

    private void parseOptionsFromCommandLine(String[] stringArray) {
        Vector<AppletProfile> vector = new Vector<AppletProfile>();
        int n = 0;
        while (n < stringArray.length) {
            block43: {
                byte[] byArray;
                Object object;
                if (stringArray[n].equals("-i")) {
                    this.int_supported = true;
                } else if (stringArray[n].equals("-classdir")) {
                    this.class_root = stringArray[++n];
                } else if (stringArray[n].equals("-exportpath")) {
                    this.export_path = Strings.toStrings(stringArray[++n], File.pathSeparator);
                } else if (stringArray[n].equals("-exportmap")) {
                    this.this_exp_provided = true;
                } else if (stringArray[n].equals("-applet")) {
                    object = new AppletProfile();
                    byArray = null;
                    try {
                        byArray = Strings.toByteArray(stringArray[++n], ":");
                    }
                    catch (Exception exception) {
                        Notifier.error("profile.4", stringArray[n]);
                        ConversionProfile.usage();
                        System.exit(1);
                    }
                    if (byArray.length > 16 || byArray.length < 5) {
                        Notifier.error("profile.1", stringArray[n]);
                        ConversionProfile.usage();
                        System.exit(1);
                    }
                    ((AppletProfile)object).aid = byArray;
                    ((AppletProfile)object).install_class = stringArray[++n].replace('.', '/');
                    vector.addElement((AppletProfile)object);
                } else {
                    if (stringArray[n].equals("-out")) {
                        while (true) {
                            if (stringArray[n + 1].equals("JCA")) {
                                this.output |= 4;
                                ++n;
                                continue;
                            }
                            if (stringArray[n + 1].equals("EXP")) {
                                this.output |= 2;
                                ++n;
                                continue;
                            }
                            break block43;
                            break;
                        }
                    }
                    if (stringArray[n].equals("-d")) {
                        this.output_dir = stringArray[++n];
                    } else if (stringArray[n].equals("-verbose")) {
                        Notifier.setVerboseFlag(true);
                    } else if (stringArray[n].equals("-v")) {
                        Notifier.setVerboseFlag(true);
                    } else if (stringArray[n].equals("-version")) {
                        object = new String(String.valueOf(String.valueOf(1)) + "." + String.valueOf(0));
                        Notifier.out("converter.version", (String)object);
                        System.exit(0);
                    } else if (stringArray[n].equals("-V")) {
                        object = new String(String.valueOf(String.valueOf(1)) + "." + String.valueOf(0));
                        Notifier.out("converter.version", (String)object);
                        System.exit(0);
                    } else if (stringArray[n].equals("-help")) {
                        ConversionProfile.usage();
                        System.exit(0);
                    } else if (stringArray[n].equals("-mask")) {
                        this.mask = true;
                    } else if (stringArray[n].equals("-nowarn")) {
                        Notifier.setNoWarningFlag(true);
                    } else if (stringArray[n].equals("-nobanner")) {
                        Notifier.setNoBannerFlag(true);
                    } else {
                        if (stringArray[n].startsWith("-")) {
                            Notifier.error("profile.0", stringArray[n]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        this.package_profile = new PackageProfile();
                        this.package_profile.package_name = stringArray[n].replace('.', '/');
                        object = null;
                        try {
                            object = Strings.toByteArray(stringArray[++n], ":");
                        }
                        catch (Exception exception) {
                            Notifier.error("profile.4", stringArray[n]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        if (((Object)object).length < 5 || ((Object)object).length > 16) {
                            Notifier.error("profile.1", stringArray[n]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        this.package_profile.aid = (byte[])object;
                        byArray = null;
                        try {
                            byArray = Strings.toByteArray(stringArray[++n], ".");
                        }
                        catch (Exception exception) {
                            Notifier.error("profile.2", stringArray[n]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        if (byArray.length != 2) {
                            Notifier.error("profile.2", stringArray[n]);
                            ConversionProfile.usage();
                            System.exit(1);
                        }
                        this.package_profile.major_version = byArray[0];
                        this.package_profile.minor_version = byArray[1];
                    }
                }
            }
            ++n;
        }
        this.applets_profile = new AppletProfile[vector.size()];
        vector.copyInto(this.applets_profile);
    }

    public static void usage() {
        int n = 0;
        while (n < 27) {
            Notifier.out("usage." + n);
            ++n;
        }
    }

    private void enumerateClasses() {
        String[] stringArray;
        File file;
        String string = this.package_profile.package_name.replace('/', File.separatorChar);
        File file2 = new File(this.class_root);
        if (!file2.exists()) {
            Notifier.error("profile.3", this.class_root);
            ConversionProfile.usage();
            System.exit(1);
        }
        if (!(file = new File(file2, string)).exists()) {
            Notifier.error("profile.5", String.valueOf(this.class_root) + File.separatorChar + string);
            ConversionProfile.usage();
            System.exit(1);
        }
        if ((stringArray = file.list(new ClassFileNameFilter())) == null) {
            Notifier.error("profile.6");
            ConversionProfile.usage();
            System.exit(1);
        }
        this.classes = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.classes[n] = new File(file, stringArray[n]);
            ++n;
        }
    }
}

