/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.instructions;

import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrByteValue;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.classfile.instructions.JInstrIinc;
import com.sun.javacard.classfile.instructions.JInstrIntBranch;
import com.sun.javacard.classfile.instructions.JInstrInterfaceRef;
import com.sun.javacard.classfile.instructions.JInstrLookupSwitch;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.classfile.instructions.JInstrMultiArray;
import com.sun.javacard.classfile.instructions.JInstrNoOperands;
import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.classfile.instructions.JInstrShortValue;
import com.sun.javacard.classfile.instructions.JInstrTableSwitch;
import com.sun.javacard.classfile.instructions.JInstrWide;
import com.sun.javacard.classfile.instructions.JavaByteCode;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class JInstruction {
    protected JConstantPool cp;
    protected int pc;
    protected int opcode;
    protected boolean basic_block_leader;
    protected boolean catch_finally_block_leader;
    protected JInstruction next_instr;
    protected JInstruction prev_instr;
    protected int source_line_number = -1;
    protected int java_pc;
    protected boolean label_mark;
    protected int label;

    public int getOpcode() {
        return this.opcode;
    }

    public int getPC() {
        return this.pc;
    }

    public String getMnemonic() {
        int n = this.opcode;
        return JavaByteCode.bc_details[n].getMnemonic();
    }

    public void setBasicBlockLeader(boolean bl) {
        this.basic_block_leader = bl;
    }

    public boolean isBasicBlockLeader() {
        return this.basic_block_leader;
    }

    public boolean isCatchFinallyBlockLeader() {
        return this.catch_finally_block_leader;
    }

    public void setCatchFinallyBlockLeader(boolean bl) {
        this.catch_finally_block_leader = bl;
    }

    public JInstruction getNextInstr() {
        return this.next_instr;
    }

    public void setNextInstr(JInstruction jInstruction) {
        this.next_instr = jInstruction;
    }

    public JInstruction getPrevInstr() {
        return this.prev_instr;
    }

    public void setPrevInstr(JInstruction jInstruction) {
        this.prev_instr = jInstruction;
    }

    public abstract int getSizeInBytes();

    public int getSourceLineNumber() {
        return this.source_line_number;
    }

    public void setSournceLineNumber(int n) {
        this.source_line_number = n;
    }

    public int getJavaPC() {
        return this.java_pc;
    }

    public void setJavaPC(int n) {
        this.java_pc = n;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int n) {
        this.label = n;
    }

    public JInstruction(JConstantPool jConstantPool, int n, int n2) {
        this.cp = jConstantPool;
        this.pc = n;
        this.opcode = n2;
    }

    public void resolve() {
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
    }

    public static final JInstruction create(JConstantPool jConstantPool, int n, int n2) {
        switch (JavaByteCode.bc_details[n2].getLoadCategory()) {
            case 1: {
                return new JInstrNoOperands(jConstantPool, n, n2);
            }
            case 16: {
                return new JInstrByteIndex(jConstantPool, n, n2);
            }
            case 32: {
                return new JInstrByteValue(jConstantPool, n, n2);
            }
            case 48: {
                return new JInstrIinc(jConstantPool, n, n2);
            }
            case 64: {
                return new JInstrCpByteRef(jConstantPool, n, n2);
            }
            case 256: {
                return new JInstrShortValue(jConstantPool, n, n2);
            }
            case 512: {
                return new JInstrShortBranch(jConstantPool, n, n2);
            }
            case 768: {
                return new JInstrCpShortRef(jConstantPool, n, n2);
            }
            case 1024: {
                return new JInstrFieldRef(jConstantPool, n, n2);
            }
            case 1280: {
                return new JInstrMethodRef(jConstantPool, n, n2);
            }
            case 1536: {
                return new JInstrClassRef(jConstantPool, n, n2);
            }
            case 1792: {
                return new JInstrInterfaceRef(jConstantPool, n, n2);
            }
            case 4096: {
                return new JInstrTableSwitch(jConstantPool, n, n2);
            }
            case 8192: {
                return new JInstrLookupSwitch(jConstantPool, n, n2);
            }
            case 12288: {
                return new JInstrIntBranch(jConstantPool, n, n2);
            }
            case 16384: {
                return new JInstrWide(jConstantPool, n, n2);
            }
            case 20480: {
                return new JInstrMultiArray(jConstantPool, n, n2);
            }
        }
        return null;
    }
}

