/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.instructions;

import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstrSwitch;
import java.io.DataInputStream;
import java.io.IOException;

public class JInstrTableSwitch
extends JInstrSwitch {
    private int low_value;
    private int high_value;
    private int[] branch_offsets;

    public JInstrTableSwitch(JConstantPool jConstantPool, int n, int n2) {
        super(jConstantPool, n, n2);
    }

    public int getLowValue() {
        return this.low_value;
    }

    public int getHighValue() {
        return this.high_value;
    }

    public int[] getBranchOffsets() {
        return this.branch_offsets;
    }

    public int getSizeInBytes() {
        return this.size_in_bytes;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        super.parse(dataInputStream);
        this.low_value = dataInputStream.readInt();
        this.high_value = dataInputStream.readInt();
        int n = this.high_value - this.low_value + 1;
        this.branch_offsets = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.branch_offsets[n2] = dataInputStream.readInt();
            ++n2;
        }
        this.size_in_bytes = 1 + this.num_padding + (3 + n) * 4;
    }
}

