/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.instructions;

import com.sun.javacard.classfile.constants.JConstant;
import com.sun.javacard.classfile.constants.JConstantDouble;
import com.sun.javacard.classfile.constants.JConstantFloat;
import com.sun.javacard.classfile.constants.JConstantInteger;
import com.sun.javacard.classfile.constants.JConstantLong;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.constants.JConstantString;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;

public class JInstrCpShortRef
extends JInstruction {
    protected int cp_index;
    protected JConstant constant_ref;
    private int value_type = 0;
    private float float_value;
    private int int_value;
    private String string_value;
    private long long_value;
    private double double_value;

    public JInstrCpShortRef(JConstantPool jConstantPool, int n, int n2) {
        super(jConstantPool, n, n2);
    }

    public int getValueType() {
        return this.value_type;
    }

    public int getIntValue() {
        return this.int_value;
    }

    public long getLongValue() {
        return this.long_value;
    }

    public float getFloatValue() {
        return this.float_value;
    }

    public double getDoubleValue() {
        return this.double_value;
    }

    public String getStringValue() {
        return this.string_value;
    }

    public int getCpIndex() {
        return this.cp_index;
    }

    public JConstant getConstantRef() {
        return this.constant_ref;
    }

    public void resolve() {
        this.constant_ref = this.cp.getAt(this.cp_index);
        if (this.opcode == 19) {
            if (this.constant_ref instanceof JConstantFloat) {
                this.value_type = 5;
                this.float_value = ((JConstantFloat)this.constant_ref).getFloat();
                return;
            }
            if (this.constant_ref instanceof JConstantInteger) {
                this.value_type = 3;
                this.int_value = ((JConstantInteger)this.constant_ref).getInt();
                return;
            }
            if (this.constant_ref instanceof JConstantString) {
                this.value_type = 20;
                this.string_value = ((JConstantString)this.constant_ref).getString();
                return;
            }
            throw new ClassFormatError();
        }
        if (this.opcode == 20) {
            if (this.constant_ref instanceof JConstantDouble) {
                this.value_type = 6;
                this.double_value = ((JConstantDouble)this.constant_ref).getDouble();
                return;
            }
            if (this.constant_ref instanceof JConstantLong) {
                this.value_type = 4;
                this.long_value = ((JConstantLong)this.constant_ref).getLong();
                return;
            }
            throw new ClassFormatError();
        }
        throw new ClassFormatError();
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.cp_index = dataInputStream.readUnsignedShort();
    }

    public int getSizeInBytes() {
        return 3;
    }
}

