/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JLineNumberRecord;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class JLineNumberTableAttr
extends JAttribute {
    private JLineNumberRecord[] records;

    JLineNumberRecord[] getJLineNumberRecords() {
        return this.records;
    }

    JLineNumberTableAttr(JConstantPool jConstantPool) {
        super(jConstantPool);
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        dataInputStream.readInt();
        int n = dataInputStream.readUnsignedShort();
        this.records = new JLineNumberRecord[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readUnsignedShort();
            int n4 = dataInputStream.readUnsignedShort();
            this.records[n2] = new JLineNumberRecord(n3, n4);
            ++n2;
        }
    }

    public int getLineNumber(int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.records.length) {
            JLineNumberRecord jLineNumberRecord = this.records[n4];
            if (jLineNumberRecord.getStartPc() <= n) {
                if (n3 == -1) {
                    n3 = n - jLineNumberRecord.getStartPc();
                    n2 = jLineNumberRecord.getSourceLineNumber();
                } else if (n - jLineNumberRecord.getStartPc() < n3) {
                    n3 = n - jLineNumberRecord.getStartPc();
                    n2 = jLineNumberRecord.getSourceLineNumber();
                }
            }
            ++n4;
        }
        return n2;
    }
}

