/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.classfile.attributes.JLineNumberTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;

public class JCodeAttr
extends JAttribute {
    private int max_stack;
    private int max_locals;
    private JInstruction code;
    private JExceptionRecord[] exceptions;
    private JLineNumberTableAttr linenumber_table_att;
    private JLocalVarTableAttr local_vars_table_att;
    private JAttribute[] attributes;

    JCodeAttr(JConstantPool jConstantPool) {
        super(jConstantPool);
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public JInstruction getCode() {
        return this.code;
    }

    public JExceptionRecord[] getExceptions() {
        return this.exceptions;
    }

    public JLineNumberTableAttr getLineNumberTableAttr() {
        return this.linenumber_table_att;
    }

    public JLocalVarTableAttr getLocalVarTableAttr() {
        return this.local_vars_table_att;
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public void resolve() {
        JInstruction jInstruction = this.code;
        while (jInstruction != null) {
            jInstruction.resolve();
            jInstruction = jInstruction.getNextInstr();
        }
        int n = 0;
        while (n < this.exceptions.length) {
            this.exceptions[n].resolve();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.attributes.length) {
            if (this.attributes[n2] instanceof JLineNumberTableAttr) {
                if (this.linenumber_table_att != null) {
                    throw new ClassFormatError("more than one line number table attribute in class file");
                }
                this.linenumber_table_att = (JLineNumberTableAttr)this.attributes[n2];
            }
            if (this.attributes[n2] instanceof JLocalVarTableAttr) {
                if (this.local_vars_table_att != null) {
                    throw new ClassFormatError("more than one local variable table attribute in class file");
                }
                this.local_vars_table_att = (JLocalVarTableAttr)this.attributes[n2];
            }
            this.attributes[n2].resolve();
            ++n2;
        }
        if (this.linenumber_table_att != null) {
            jInstruction = this.code;
            while (jInstruction != null) {
                int n3 = this.linenumber_table_att.getLineNumber(jInstruction.getPC());
                jInstruction.setSournceLineNumber(n3);
                jInstruction = jInstruction.getNextInstr();
            }
        }
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        dataInputStream.readInt();
        this.max_stack = dataInputStream.readUnsignedShort();
        this.max_locals = dataInputStream.readUnsignedShort();
        int n5 = dataInputStream.readInt();
        JInstruction jInstruction = this.code;
        int n6 = 0;
        while (n6 < n5) {
            n4 = dataInputStream.readUnsignedByte();
            JInstruction jInstruction2 = JInstruction.create(this.cp, n6, n4);
            jInstruction2.parse(dataInputStream);
            if (this.code == null) {
                this.code = jInstruction2;
                jInstruction = jInstruction2;
            } else {
                jInstruction.setNextInstr(jInstruction2);
                jInstruction2.setPrevInstr(jInstruction);
                jInstruction = jInstruction2;
            }
            n6 += jInstruction2.getSizeInBytes();
        }
        n4 = dataInputStream.readUnsignedShort();
        this.exceptions = new JExceptionRecord[n4];
        int n7 = 0;
        while (n7 < n4) {
            n3 = dataInputStream.readUnsignedShort();
            n2 = dataInputStream.readUnsignedShort();
            n = dataInputStream.readUnsignedShort();
            int n8 = dataInputStream.readUnsignedShort();
            this.exceptions[n7] = new JExceptionRecord(n3, n2, n, n8, this.cp);
            ++n7;
        }
        n3 = dataInputStream.readUnsignedShort();
        this.attributes = new JAttribute[n3];
        n2 = 0;
        while (n2 < n3) {
            n = dataInputStream.readUnsignedShort();
            this.attributes[n2] = JAttribute.create(this.cp, n);
            this.attributes[n2].parse(dataInputStream);
            ++n2;
        }
    }
}

