/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.attributes;

import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JConstantValueAttr;
import com.sun.javacard.classfile.attributes.JExceptionsAttr;
import com.sun.javacard.classfile.attributes.JLineNumberTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JSourceFileAttr;
import com.sun.javacard.classfile.attributes.JUnknownAttribute;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class JAttribute {
    protected JConstantPool cp;

    JAttribute(JConstantPool jConstantPool) {
        this.cp = jConstantPool;
    }

    public static final JAttribute create(JConstantPool jConstantPool, int n) {
        String string = jConstantPool.getConstantUtf8(n).getString();
        if (string.equals("ConstantValue")) {
            return new JConstantValueAttr(jConstantPool);
        }
        if (string.equals("SourceFile")) {
            return new JSourceFileAttr(jConstantPool);
        }
        if (string.equals("Code")) {
            return new JCodeAttr(jConstantPool);
        }
        if (string.equals("LineNumberTable")) {
            return new JLineNumberTableAttr(jConstantPool);
        }
        if (string.equals("LocalVariableTable")) {
            return new JLocalVarTableAttr(jConstantPool);
        }
        if (string.equals("Exceptions")) {
            return new JExceptionsAttr(jConstantPool);
        }
        return new JUnknownAttribute(jConstantPool, n);
    }

    public void resolve() {
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
    }
}

