/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;

public class JMethod
extends MethodDefinition {
    private JConstantPool constant_pool;
    private int name_index;
    private int descriptor_index;
    private JAttribute[] attributes;
    private JCodeAttr code_attr;
    private String[] exceptionsThrown;

    public String[] getExceptionsThrown() {
        return this.exceptionsThrown;
    }

    public JCodeAttr getCodeAttr() {
        return this.code_attr;
    }

    public JInstruction getCode() {
        if (this.code_attr == null) {
            return null;
        }
        return this.code_attr.getCode();
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public JMethod(JConstantPool jConstantPool) {
        this.constant_pool = jConstantPool;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.access_flags = dataInputStream.readUnsignedShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        this.attributes = new JAttribute[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readUnsignedShort();
            this.attributes[n2] = JAttribute.create(this.constant_pool, n3);
            this.attributes[n2].parse(dataInputStream);
            ++n2;
        }
    }

    public void resolve() {
        this.method_name = this.constant_pool.getConstantUtf8(this.name_index).getString();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getString();
        int n = 0;
        while (n < this.attributes.length) {
            if (this.attributes[n] instanceof JCodeAttr) {
                this.code_attr = (JCodeAttr)this.attributes[n];
                this.code_attr.resolve();
            }
            ++n;
        }
    }
}

