/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.constants.JConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class JClassFile
extends ClassDefinition {
    private int magic;
    private int major_version;
    private int minor_version;
    private int this_class_index;
    private int super_class_index;
    private JConstantPool constant_pool;
    private int[] interface_indexes;
    private JField[] fields;
    private JMethod[] methods;
    private JAttribute[] attributes;
    private String[] interface_names;
    private String source_file_name;

    public int getMagic() {
        return this.magic;
    }

    public int getMajorVersion() {
        return this.major_version;
    }

    public int getMinorVersion() {
        return this.minor_version;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public JField[] getFields() {
        return this.fields;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }

    public JConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public String getSourceFileName() {
        return this.source_file_name;
    }

    public void resolve() {
        this.constant_pool.resolve();
        this.class_name = this.constant_pool.getConstantClass(this.this_class_index).getClassName();
        this.super_class_name = this.super_class_index != 0 ? this.constant_pool.getConstantClass(this.super_class_index).getClassName() : null;
        this.interface_names = new String[this.interface_indexes.length];
        int n = 0;
        while (n < this.interface_names.length) {
            this.interface_names[n] = this.constant_pool.getConstantClass(this.interface_indexes[n]).getClassName();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.attributes.length) {
            this.attributes[n2].resolve();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.fields.length) {
            this.fields[n3].resolve();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.methods.length) {
            this.methods[n4].resolve();
            ++n4;
        }
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.magic = dataInputStream.readInt();
        this.minor_version = dataInputStream.readUnsignedShort();
        this.major_version = dataInputStream.readUnsignedShort();
        this.constant_pool = new JConstantPool(dataInputStream.readUnsignedShort());
        this.constant_pool.parse(dataInputStream);
        this.access_flags = dataInputStream.readUnsignedShort();
        this.this_class_index = dataInputStream.readUnsignedShort();
        this.super_class_index = dataInputStream.readUnsignedShort();
        this.interface_indexes = new int[dataInputStream.readUnsignedShort()];
        int n = 0;
        while (n < this.interface_indexes.length) {
            this.interface_indexes[n] = dataInputStream.readUnsignedShort();
            ++n;
        }
        this.fields = new JField[dataInputStream.readUnsignedShort()];
        int n2 = 0;
        while (n2 < this.fields.length) {
            this.fields[n2] = new JField(this.constant_pool);
            this.fields[n2].parse(dataInputStream);
            ++n2;
        }
        this.methods = new JMethod[dataInputStream.readUnsignedShort()];
        int n3 = 0;
        while (n3 < this.methods.length) {
            this.methods[n3] = new JMethod(this.constant_pool);
            this.methods[n3].parse(dataInputStream);
            ++n3;
        }
        this.attributes = new JAttribute[dataInputStream.readUnsignedShort()];
        int n4 = 0;
        while (n4 < this.attributes.length) {
            int n5 = dataInputStream.readUnsignedShort();
            this.attributes[n4] = JAttribute.create(this.constant_pool, n5);
            this.attributes[n4].parse(dataInputStream);
            ++n4;
        }
    }
}

