/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.samples.JavaPurse;

import com.sun.javacard.samples.JavaPurse.CyclicFile;
import com.sun.javacard.samples.JavaPurse.ParametersFile;
import com.sun.javacard.samples.SampleLibrary.JavaLoyaltyInterface;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.OwnerPIN;
import javacard.framework.Util;

public class JavaPurse
extends Applet {
    static final byte PURSE_CLA = -128;
    static final byte VERIFY = 32;
    static final byte READ = -78;
    static final byte INITIALIZE_TRANSACTION = 32;
    static final byte COMPLETE_TRANSACTION = 34;
    static final byte INITIALIZE_UPDATE = 36;
    static final byte COMPLETE_UPDATE = 38;
    static final byte CREDIT = 1;
    static final byte DEBIT = 2;
    static final byte MASTER_PIN = -127;
    static final byte USER_PIN = -126;
    static final short SW_CREDIT_TOO_HIGH = -28415;
    static final short SW_NOT_ENOUGH_FUNDS = -28414;
    static final short SW_AMOUNT_TOO_HIGH = -28413;
    static final short SW_COMMAND_OUT_OF_SEQUENCE = -28412;
    static final short SW_WRONG_SIGNATURE = -28411;
    static final short SW_PIN_FAILED = 27072;
    static final byte LC_IT = 10;
    static final byte LC_CT = 13;
    static final byte LC_CU_MIN = 18;
    static final byte CAD_ID_OFFSET = 7;
    static final short DATE_LENGTH = 3;
    static final short DATETIME_LENGTH = 5;
    static final short ID_LENGTH = 4;
    static final short SHORT_LENGTH = 2;
    static final short START = 0;
    static final short SIGNATURE_LENGTH = 8;
    static final short MAX_LOYALTY = 4;
    static final byte TN_IX = 0;
    static final byte NEW_BALANCE_IX = 1;
    static final byte CURRENT_BALANCE_IX = 2;
    static final byte AMOUNT_IX = 3;
    static final byte TRANSACTION_TYPE_IX = 4;
    static final byte SELECTED_FILE_IX = 5;
    static final byte NUM_TRANSIENT_SHORTS = 6;
    static final byte TRANSACTION_INITIALIZED = 0;
    static final byte UPDATE_INITIALIZED = 1;
    static final byte NUM_TRANSIENT_BOOLS = 2;
    private static final byte FCI_TEMPLATE_TAG = 111;
    private static final byte FCI_AID_TAG = -124;
    private static final byte[] FCI_PROPERIETARY = new byte[]{-91, 1, 66};
    private ParametersFile parametersFile;
    private CyclicFile transactionLogFile;
    private short TN;
    private short PUN;
    private boolean isPersonalized;
    static final short PARAMETERS_FID = -28414;
    static final short TRANSACTION_LOG_FID = -28413;
    static final short BALANCES_FID = -28412;
    static final byte FID_BYTE = -111;
    static final byte TRANSACTION_RECORD_LENGTH = 18;
    static final byte TRANSACTION_RECORD_NUMBER = 10;
    static final byte BALANCES_RECORD_LENGTH = 6;
    static final byte BALANCES_RECORD_NUMBER = 1;
    static final byte PARAMETERS_RECORD_NUMBER = 11;
    static final byte OFFSET_BAL_CURRENT = 0;
    static final byte OFFSET_BAL_MAX = 2;
    static final byte OFFSET_AMOUNT_MAX = 4;
    static final byte NUMBER_OF_FILES = 3;
    private OwnerPIN masterPIN;
    private OwnerPIN userPIN;
    static final byte MASTER_PIN_UPDATE = -63;
    static final byte USER_PIN_UPDATE = -62;
    static final byte EXP_DATE_UPDATE = -59;
    static final byte PURSE_ID_UPDATE = -58;
    static final byte MAX_BAL_UPDATE = -57;
    static final byte MAX_M_UPDATE = -56;
    static final byte VERSION_UPDATE = -55;
    static final byte LOYALTY1_UPDATE = -54;
    static final byte LOYALTY2_UPDATE = -53;
    static final byte LOYALTY3_UPDATE = -52;
    static final byte LOYALTY4_UPDATE = -51;
    static final short TLV_OFFSET = 13;
    private byte[] CAD_ID_array;
    private byte[] byteArray8;
    private short[] transientShorts;
    private boolean[] transientBools;
    private byte[] ID_Purse = new byte[4];
    private byte[] ExpDate = new byte[3];
    private byte[] balancesRecord;
    private short[] loyaltyCAD;
    private JavaLoyaltyInterface[] loyaltySIO;

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new JavaPurse(bArray, bOffset, bLength);
    }

    protected JavaPurse(byte[] bArray, short bOffset, byte bLength) {
        this.ExpDate[0] = 12;
        this.ExpDate[1] = 31;
        this.ExpDate[2] = 99;
        this.balancesRecord = new byte[6];
        this.loyaltyCAD = new short[4];
        this.loyaltySIO = new JavaLoyaltyInterface[4];
        this.TN = 0;
        this.PUN = 0;
        this.isPersonalized = false;
        this.transientShorts = JCSystem.makeTransientShortArray((short)6, (byte)2);
        this.transientBools = JCSystem.makeTransientBooleanArray((short)2, (byte)2);
        this.CAD_ID_array = JCSystem.makeTransientByteArray((short)4, (byte)2);
        this.byteArray8 = JCSystem.makeTransientByteArray((short)8, (byte)2);
        this.masterPIN = new OwnerPIN(1, 8);
        this.userPIN = new OwnerPIN(5, 8);
        this.parametersFile = new ParametersFile(11);
        this.transactionLogFile = new CyclicFile(10, 18);
        Util.setShort((byte[])this.balancesRecord, (short)0, (short)0);
        if (bArray == null || bLength <= 0) {
            this.register();
        } else {
            this.register(bArray, bOffset, bLength);
        }
    }

    public void deselect() {
        this.userPIN.reset();
        this.masterPIN.reset();
    }

    public void process(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        if (buffer[0] == -128) {
            switch (buffer[1]) {
                case 32: {
                    this.processInitializeTransaction(apdu);
                    break;
                }
                case 34: {
                    this.processCompleteTransaction(apdu);
                    break;
                }
                case 36: {
                    this.processInitializeUpdate(apdu);
                    break;
                }
                case 38: {
                    this.processCompleteUpdate(apdu);
                    break;
                }
                default: {
                    ISOException.throwIt((short)27904);
                    break;
                }
            }
        } else if (buffer[0] == 0) {
            if (buffer[1] == 32) {
                this.processVerifyPIN(apdu);
            } else if (buffer[1] == -92) {
                if (this.selectingApplet()) {
                    this.processSelectPurse(apdu);
                } else {
                    this.processSelectFile(apdu);
                }
            } else if (buffer[1] == -78) {
                this.processReadRecord(apdu);
            } else {
                ISOException.throwIt((short)27904);
            }
        } else {
            ISOException.throwIt((short)28160);
        }
    }

    private void processSelectPurse(APDU apdu) {
        short offset;
        byte[] buffer = apdu.getBuffer();
        buffer[0] = 111;
        buffer[2] = -124;
        buffer[3] = JCSystem.getAID().getBytes(buffer, (short)4);
        short s = offset = (short)(3 + buffer[3]);
        offset = (short)(s + 1);
        buffer[s] = (byte)FCI_PROPERIETARY.length;
        offset = Util.arrayCopyNonAtomic((byte[])FCI_PROPERIETARY, (short)0, (byte[])buffer, (short)offset, (short)((short)FCI_PROPERIETARY.length));
        buffer[1] = (byte)(offset - 2);
        apdu.setOutgoingAndSend((short)0, offset);
    }

    private void processInitializeTransaction(APDU apdu) {
        short newTN;
        short amount;
        byte[] buffer;
        if (this.transientBools[0]) {
            ISOException.throwIt((short)-28412);
        }
        if (!this.userPIN.isValidated()) {
            ISOException.throwIt((short)27010);
        }
        if ((buffer = apdu.getBuffer())[4] != 10) {
            ISOException.throwIt((short)26368);
        }
        if (buffer[3] != 0) {
            ISOException.throwIt((short)27270);
        }
        apdu.setIncomingAndReceive();
        byte transactionType = buffer[2];
        this.transientShorts[4] = transactionType;
        this.transientShorts[3] = amount = Util.getShort((byte[])buffer, (short)5);
        short balance = this.checkTransactionValues(transactionType, amount);
        this.transientShorts[0] = newTN = (short)(this.TN + 1);
        Util.arrayCopyNonAtomic((byte[])buffer, (short)7, (byte[])this.CAD_ID_array, (short)0, (short)4);
        Util.arrayFillNonAtomic((byte[])this.byteArray8, (short)0, (short)((short)this.byteArray8.length), (byte)0);
        short offset = Util.arrayCopyNonAtomic((byte[])this.ID_Purse, (short)0, (byte[])buffer, (short)0, (short)4);
        offset = Util.arrayCopyNonAtomic((byte[])this.ExpDate, (short)0, (byte[])buffer, (short)offset, (short)3);
        offset = Util.setShort((byte[])buffer, (short)offset, (short)balance);
        offset = Util.setShort((byte[])buffer, (short)offset, (short)newTN);
        offset = Util.arrayCopyNonAtomic((byte[])this.byteArray8, (short)0, (byte[])buffer, (short)offset, (short)8);
        apdu.setOutgoingAndSend((short)0, offset);
        this.transientBools[0] = true;
    }

    private void processCompleteTransaction(APDU apdu) {
        byte[] theRecord;
        byte[] buffer;
        if (!this.transientBools[0]) {
            ISOException.throwIt((short)-28412);
        }
        if ((buffer = apdu.getBuffer())[4] != 13) {
            ISOException.throwIt((short)26368);
        }
        if (buffer[2] != 0 || buffer[3] != 0) {
            ISOException.throwIt((short)27270);
        }
        apdu.setIncomingAndReceive();
        short newTN = this.transientShorts[0];
        short amount = this.transientShorts[3];
        short newBalance = this.transientShorts[1];
        Util.arrayFillNonAtomic((byte[])this.byteArray8, (short)0, (short)((short)this.byteArray8.length), (byte)0);
        boolean signatureOK = Util.arrayCompare((byte[])buffer, (short)5, (byte[])this.byteArray8, (short)0, (short)8) == 0;
        short offset = Util.setShort((byte[])buffer, (short)0, (short)newTN);
        buffer[offset] = (byte)this.transientShorts[4];
        offset = (short)(offset + 1);
        offset = Util.setShort((byte[])buffer, (short)offset, (short)amount);
        offset = Util.arrayCopyNonAtomic((byte[])this.CAD_ID_array, (short)0, (byte[])buffer, (short)offset, (short)4);
        short balanceOffset = offset = Util.arrayCopyNonAtomic((byte[])buffer, (short)13, (byte[])buffer, (short)offset, (short)5);
        if (!signatureOK) {
            offset = Util.setShort((byte[])buffer, (short)offset, (short)this.transientShorts[2]);
            Util.setShort((byte[])buffer, (short)offset, (short)-28411);
            theRecord = this.transactionLogFile.getNewLogRecord();
            JCSystem.beginTransaction();
            this.TN = newTN;
            Util.arrayCopy((byte[])buffer, (short)0, (byte[])theRecord, (short)0, (short)18);
            this.transactionLogFile.updateNewLogRecord();
            JCSystem.commitTransaction();
            this.transientBools[0] = false;
            ISOException.throwIt((short)-28411);
        } else {
            offset = Util.setShort((byte[])buffer, (short)offset, (short)this.transientShorts[1]);
            Util.setShort((byte[])buffer, (short)offset, (short)-28672);
            theRecord = this.transactionLogFile.getNewLogRecord();
            JCSystem.beginTransaction();
            this.TN = this.transientShorts[0];
            Util.setShort((byte[])this.balancesRecord, (short)0, (short)newBalance);
            Util.arrayCopy((byte[])buffer, (short)0, (byte[])theRecord, (short)0, (short)18);
            this.transactionLogFile.updateNewLogRecord();
            JCSystem.commitTransaction();
        }
        Util.setShort((byte[])buffer, (short)0, (short)0);
        Util.setShort((byte[])buffer, (short)balanceOffset, (short)0);
        short loyaltyCADValue = Util.getShort((byte[])this.CAD_ID_array, (short)0);
        int loyaltyIndex = 0;
        while (loyaltyIndex < 4) {
            if (this.loyaltyCAD[loyaltyIndex] == loyaltyCADValue) {
                this.loyaltySIO[loyaltyIndex].grantPoints(buffer);
                break;
            }
            loyaltyIndex = (byte)(loyaltyIndex + 1);
        }
        Util.arrayFillNonAtomic((byte[])this.byteArray8, (short)0, (short)((short)this.byteArray8.length), (byte)0);
        offset = Util.setShort((byte[])buffer, (short)0, (short)newBalance);
        offset = Util.arrayCopyNonAtomic((byte[])this.byteArray8, (short)0, (byte[])buffer, (short)offset, (short)8);
        apdu.setOutgoingAndSend((short)0, offset);
        this.transientBools[0] = false;
    }

    private void processInitializeUpdate(APDU apdu) {
        byte[] buffer;
        if (this.transientBools[1]) {
            ISOException.throwIt((short)-28412);
        }
        if (!this.masterPIN.isValidated() && this.isPersonalized) {
            ISOException.throwIt((short)27010);
        }
        if ((buffer = apdu.getBuffer())[2] != 0 || buffer[3] != 0) {
            ISOException.throwIt((short)27270);
        }
        this.PUN = (short)(this.PUN + 1);
        short offset = Util.arrayCopyNonAtomic((byte[])this.ID_Purse, (short)0, (byte[])buffer, (short)0, (short)4);
        offset = Util.arrayCopyNonAtomic((byte[])this.ExpDate, (short)0, (byte[])buffer, (short)offset, (short)3);
        offset = Util.setShort((byte[])buffer, (short)offset, (short)this.PUN);
        apdu.setOutgoingAndSend((short)0, offset);
        this.transientBools[1] = true;
    }

    private void processCompleteUpdate(APDU apdu) {
        byte[] buffer;
        if (!this.transientBools[1]) {
            ISOException.throwIt((short)-28412);
        }
        if ((buffer = apdu.getBuffer())[2] != 0 || buffer[3] != 0) {
            ISOException.throwIt((short)27270);
        }
        short count = apdu.setIncomingAndReceive();
        byte lc = buffer[4];
        Util.arrayFillNonAtomic((byte[])this.byteArray8, (short)0, (short)((short)this.byteArray8.length), (byte)0);
        if (Util.arrayCompare((byte[])this.byteArray8, (short)0, (byte[])buffer, (short)((short)(5 + lc - 8)), (short)8) != 0) {
            ISOException.throwIt((short)-28411);
        }
        switch (buffer[13]) {
            case -63: {
                this.updatePIN(apdu, this.masterPIN);
                this.setIsPersonalized();
                break;
            }
            case -62: {
                this.updatePIN(apdu, this.userPIN);
                break;
            }
            case -59: {
                this.updateParameterValue(apdu, this.ExpDate);
                break;
            }
            case -58: {
                this.updateParameterValue(apdu, this.ID_Purse);
                break;
            }
            case -57: {
                this.updateBalanceValue(apdu, (short)2);
                break;
            }
            case -56: {
                this.updateBalanceValue(apdu, (short)4);
                break;
            }
            case -55: {
                this.updateParametersFile(apdu);
                break;
            }
            case -54: {
                this.updateLoyaltyProgram(apdu, (byte)0);
                break;
            }
            case -53: {
                this.updateLoyaltyProgram(apdu, (byte)1);
                break;
            }
            case -52: {
                this.updateLoyaltyProgram(apdu, (byte)2);
                break;
            }
            case -51: {
                this.updateLoyaltyProgram(apdu, (byte)3);
                break;
            }
            default: {
                ISOException.throwIt((short)27265);
            }
        }
        Util.arrayFillNonAtomic((byte[])this.byteArray8, (short)0, (short)((short)this.byteArray8.length), (byte)0);
        Util.arrayCopyNonAtomic((byte[])this.byteArray8, (short)0, (byte[])buffer, (short)0, (short)8);
        apdu.setOutgoingAndSend((short)0, (short)8);
        this.transientBools[1] = false;
    }

    private void processVerifyPIN(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        byte pinLength = buffer[4];
        byte triesRemaining = 0;
        short count = apdu.setIncomingAndReceive();
        if (count < pinLength) {
            ISOException.throwIt((short)26368);
        }
        byte pinType = buffer[3];
        switch (pinType) {
            case -127: {
                if (this.masterPIN.check(buffer, (short)5, pinLength)) break;
                triesRemaining = this.masterPIN.getTriesRemaining();
                ISOException.throwIt((short)((short)(27072 + triesRemaining)));
                break;
            }
            case -126: {
                if (this.userPIN.check(buffer, (short)5, pinLength)) break;
                triesRemaining = this.userPIN.getTriesRemaining();
                ISOException.throwIt((short)((short)(27072 + triesRemaining)));
                break;
            }
            default: {
                ISOException.throwIt((short)27270);
            }
        }
    }

    private short checkTransactionValues(byte transactionType, short amount) {
        short currentBalance = Util.getShort((byte[])this.balancesRecord, (short)0);
        short maxBalance = Util.getShort((byte[])this.balancesRecord, (short)2);
        short maxAmount = Util.getShort((byte[])this.balancesRecord, (short)4);
        switch (transactionType) {
            case 1: {
                short newBalance;
                this.transientShorts[1] = newBalance = (short)(currentBalance + amount);
                if (newBalance <= maxBalance && newBalance >= 0) break;
                ISOException.throwIt((short)-28415);
                break;
            }
            case 2: {
                short newBalance;
                if (amount > maxAmount) {
                    ISOException.throwIt((short)-28413);
                }
                this.transientShorts[1] = newBalance = (short)(currentBalance - amount);
                if (newBalance >= 0) break;
                ISOException.throwIt((short)-28414);
                break;
            }
            default: {
                ISOException.throwIt((short)27270);
            }
        }
        this.transientShorts[2] = currentBalance;
        return currentBalance;
    }

    private void updatePIN(APDU apdu, OwnerPIN PIN) {
        byte[] buffer = apdu.getBuffer();
        PIN.update(buffer, (short)15, buffer[14]);
    }

    private void setIsPersonalized() {
        if (!this.isPersonalized) {
            this.isPersonalized = true;
        }
    }

    private void updateParameterValue(APDU apdu, byte[] value) {
        byte[] buffer = apdu.getBuffer();
        Util.arrayCopyNonAtomic((byte[])buffer, (short)15, (byte[])value, (short)0, (short)buffer[14]);
        this.updateParametersFile(apdu);
    }

    private void updateBalanceValue(APDU apdu, short offset) {
        byte[] buffer = apdu.getBuffer();
        Util.arrayCopyNonAtomic((byte[])buffer, (short)15, (byte[])this.balancesRecord, (short)offset, (short)2);
    }

    private void updateParametersFile(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        byte recordNumber = this.parametersFile.findRecord(buffer[13]);
        if (recordNumber == 0) {
            byte[] newRecord = new byte[buffer[14] + 2];
            Util.arrayCopyNonAtomic((byte[])buffer, (short)13, (byte[])newRecord, (short)0, (short)((short)(buffer[14] + 2)));
            this.parametersFile.addRecord(newRecord);
        } else {
            byte[] theRecord = this.parametersFile.getRecord(recordNumber);
            Util.arrayCopyNonAtomic((byte[])buffer, (short)13, (byte[])theRecord, (short)0, (short)((short)(buffer[14] + 2)));
        }
    }

    private void processSelectFile(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        apdu.setIncomingAndReceive();
        if (buffer[2] == 2) {
            if (buffer[4] != 2) {
                ISOException.throwIt((short)26368);
            }
            short fid = Util.getShort((byte[])buffer, (short)5);
            switch (fid) {
                case -28414: 
                case -28413: 
                case -28412: {
                    this.transientShorts[5] = fid;
                    break;
                }
                default: {
                    ISOException.throwIt((short)27266);
                    break;
                }
            }
        } else {
            ISOException.throwIt((short)27265);
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void processReadRecord(APDU apdu) {
        block37: {
            block36: {
                block35: {
                    record = null;
                    fid = 0;
                    buffer = apdu.getBuffer();
                    P1 = buffer[2];
                    P2 = buffer[3];
                    if (P2 >> 3 == 0) {
                        if (this.transientShorts[5] == 0) {
                            ISOException.throwIt((short)27014);
                        } else {
                            fid = this.transientShorts[5];
                        }
                    } else {
                        sfi = (byte)(P2 >> 3 & 31);
                        fid = Util.makeShort((byte)-111, (byte)sfi);
                        switch (fid) {
                            case -28414: 
                            case -28413: 
                            case -28412: {
                                this.transientShorts[5] = fid;
                                break;
                            }
                            default: {
                                ISOException.throwIt((short)27266);
                            }
                        }
                    }
                    switch (fid) {
                        case -28413: 
                        case -28412: {
                            if (this.userPIN.isValidated()) break;
                            ISOException.throwIt((short)27010);
                            break;
                        }
                        case -28414: {
                            if (this.masterPIN.isValidated()) break;
                            ISOException.throwIt((short)27010);
                            break;
                        }
                    }
                    P2 = (byte)(P2 & 7);
                    if ((P2 & 4) == 0) break block35;
                    if (P2 == 4) {
                        if (P1 == 0) {
                            ISOException.throwIt((short)27267);
                        }
                        switch (fid) {
                            case -28412: {
                                if (P1 == 1) {
                                    record = this.balancesRecord;
                                    break;
                                }
                                ISOException.throwIt((short)27267);
                                break;
                            }
                            case -28413: {
                                record = this.transactionLogFile.getRecord(P1);
                                break;
                            }
                            case -28414: {
                                record = this.parametersFile.getRecord(P1);
                                break;
                            }
                        }
                        if (record == null) {
                            ISOException.throwIt((short)27266);
                        }
                    } else {
                        ISOException.throwIt((short)27265);
                    }
                    ** GOTO lbl81
                }
                if (P2 != 0) break block36;
                switch (fid) {
                    case -28412: {
                        if (this.balancesRecord[0] == P1) {
                            record = this.balancesRecord;
                            ** break;
                        }
                        ISOException.throwIt((short)27267);
                        ** break;
                    }
                    case -28413: {
                        P1 = this.transactionLogFile.findRecord(P1);
                        if (P1 == 0) {
                            ISOException.throwIt((short)27267);
                            ** break;
                        }
                        record = this.transactionLogFile.getRecord(P1);
                        ** break;
                    }
                    case -28414: {
                        P1 = this.parametersFile.findRecord(P1);
                        if (P1 == 0) {
                            ISOException.throwIt((short)27267);
                            ** break;
                        }
                        record = this.parametersFile.getRecord(P1);
                        ** break;
                    }
                    default: {
                        Le = apdu.setOutgoing();
                        if (record.length >= Le) break block37;
                    }
                }
            }
            ISOException.throwIt((short)27265);
lbl81:
            // 9 sources

            if (record.length >= Le) break block37;
            Le = (short)record.length;
        }
        apdu.setOutgoingLength(Le);
        apdu.sendBytesLong(record, (short)0, Le);
    }

    private void updateLoyaltyProgram(APDU apdu, byte loyaltyIndex) {
        byte[] buffer = apdu.getBuffer();
        this.loyaltyCAD[loyaltyIndex] = Util.getShort((byte[])buffer, (short)15);
        if (this.loyaltyCAD[loyaltyIndex] != 0) {
            AID loyaltyAID = JCSystem.lookupAID((byte[])buffer, (short)17, (byte)((byte)(buffer[14] - 2)));
            if (loyaltyAID != null) {
                this.loyaltySIO[loyaltyIndex] = (JavaLoyaltyInterface)JCSystem.getAppletShareableInterfaceObject((AID)loyaltyAID, (byte)0);
                if (this.loyaltySIO[loyaltyIndex] == null) {
                    this.loyaltyCAD[loyaltyIndex] = 0;
                }
            } else {
                this.loyaltyCAD[loyaltyIndex] = 0;
            }
        }
        if (this.loyaltyCAD[loyaltyIndex] == 0) {
            buffer[14] = 2;
            Util.arrayFillNonAtomic((byte[])buffer, (short)15, (short)((short)(buffer.length - 13 - 2)), (byte)0);
        }
        this.updateParametersFile(apdu);
    }
}

