/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.samples.JavaLoyalty;

import com.sun.javacard.samples.SampleLibrary.JavaLoyaltyInterface;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.Shareable;
import javacard.framework.Util;

public class JavaLoyalty
extends Applet
implements JavaLoyaltyInterface {
    static final byte LOYALTY_CLA = -112;
    static final byte READ_BALANCE = 32;
    static final byte RESET_BALANCE = 34;
    static final byte CREDIT = 1;
    static final byte DEBIT = 2;
    static final short TRANSACTION_TYPE_OFFSET = 2;
    static final short TRANSACTION_AMOUNT_OFFSET = 3;
    static final short SCALE = 100;
    static final short BALANCE_MAX = 30000;
    short balance = 0;

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new JavaLoyalty(bArray, bOffset, bLength);
    }

    protected JavaLoyalty(byte[] bArray, short bOffset, byte bLength) {
        if (bArray == null || bLength <= 0) {
            this.register();
        } else {
            this.register(bArray, bOffset, bLength);
        }
    }

    public Shareable getShareableInterfaceObject(AID clientAID, byte parameter) {
        if (parameter == 0) {
            return this;
        }
        return null;
    }

    public void grantPoints(byte[] buffer) {
        short amount = Util.getShort((byte[])buffer, (short)3);
        amount = (short)(amount / 100);
        switch (buffer[2]) {
            case 2: {
                this.balance = (short)(this.balance + amount);
                break;
            }
            case 1: {
                this.balance = (short)(this.balance - amount);
                break;
            }
        }
        if (this.balance < 0) {
            this.balance = 0;
        }
        if (this.balance > 30000) {
            this.balance = (short)30000;
        }
    }

    public void process(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        if (buffer[0] == -112) {
            switch (buffer[1]) {
                case 32: {
                    this.processReadBalance(apdu);
                    break;
                }
                case 34: {
                    this.processResetBalance();
                    break;
                }
                default: {
                    ISOException.throwIt((short)27904);
                    break;
                }
            }
        } else {
            if (this.selectingApplet()) {
                return;
            }
            ISOException.throwIt((short)28160);
        }
    }

    void processReadBalance(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        Util.setShort((byte[])buffer, (short)0, (short)this.balance);
        apdu.setOutgoingAndSend((short)0, (short)2);
    }

    void processResetBalance() {
        this.balance = 0;
    }
}

