/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;

public class VirtualMethodRefInfo
extends Info {
    protected int virtualMethodToken;

    VirtualMethodRefInfo(PackageIdentifier packageId, String name) {
        super(3, packageId, name, name.substring(name.lastIndexOf(40)));
    }

    VirtualMethodRefInfo(PackageIdentifier packageId, int classToken, int virtualMethodToken, String descriptor) {
        super(3, packageId, classToken, descriptor);
        this.virtualMethodToken = virtualMethodToken;
    }

    public int getVirtualMethodToken() {
        return this.virtualMethodToken;
    }

    public byte[] toByteArray(JCPackage p) {
        byte[] array = super.toByteArray(p);
        if (this.isPackageInternal()) {
            JCMethod method = (JCMethod)this.resolvedTo;
            int addr = method.getParentClass().getRelocAddr();
            array[1] = (byte)(addr >> 8 & 0xFF);
            array[2] = (byte)(addr & 0xFF);
            array[3] = (byte)method.getMethodIdentifier().getMethodToken();
        } else {
            array[1] = (byte)p.getPackageToken(this.packageIdentifier);
            array[1] = (byte)(array[1] | 0x80);
            array[2] = (byte)this.classToken;
            array[3] = (byte)this.virtualMethodToken;
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("." + Integer.toHexString(this.virtualMethodToken));
        return sb.toString();
    }
}

