/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.samples.wallet;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.OwnerPIN;

public class Wallet
extends Applet {
    static final byte Wallet_CLA = -80;
    static final byte VERIFY = 32;
    static final byte CREDIT = 48;
    static final byte DEBIT = 64;
    static final byte GET_BALANCE = 80;
    static final short MAX_BALANCE = Short.MAX_VALUE;
    static final byte MAX_TRANSACTION_AMOUNT = 127;
    static final byte PIN_TRY_LIMIT = 3;
    static final byte MAX_PIN_SIZE = 8;
    static final short SW_VERIFICATION_FAILED = 25344;
    static final short SW_PIN_VERIFICATION_REQUIRED = 25345;
    static final short SW_INVALID_TRANSACTION_AMOUNT = 27267;
    static final short SW_EXCEED_MAXIMUM_BALANCE = 27268;
    static final short SW_NEGATIVE_BALANCE = 27269;
    OwnerPIN pin = new OwnerPIN(3, 8);
    short balance;

    private Wallet(byte[] bArray, short bOffset, byte bLength) {
        this.pin.update(bArray, bOffset, bLength);
        this.register();
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new Wallet(bArray, bOffset, bLength);
    }

    public boolean select() {
        return this.pin.getTriesRemaining() != 0;
    }

    public void deselect() {
        this.pin.reset();
    }

    public void process(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        if (buffer[0] == 0 && buffer[1] == -92) {
            return;
        }
        if (buffer[0] != -80) {
            ISOException.throwIt((short)28160);
        }
        switch (buffer[1]) {
            case 80: {
                this.getBalance(apdu);
                return;
            }
            case 64: {
                this.debit(apdu);
                return;
            }
            case 48: {
                this.credit(apdu);
                return;
            }
            case 32: {
                this.verify(apdu);
                return;
            }
        }
        ISOException.throwIt((short)27904);
    }

    private void credit(APDU apdu) {
        byte creditAmount;
        if (!this.pin.isValidated()) {
            ISOException.throwIt((short)25345);
        }
        byte[] buffer = apdu.getBuffer();
        byte numBytes = buffer[4];
        byte byteRead = (byte)apdu.setIncomingAndReceive();
        if (numBytes != 1 || byteRead != 1) {
            ISOException.throwIt((short)26368);
        }
        if ((creditAmount = buffer[5]) > 127 || creditAmount < 0) {
            ISOException.throwIt((short)27267);
        }
        if ((short)(this.balance + creditAmount) > Short.MAX_VALUE) {
            ISOException.throwIt((short)27268);
        }
        this.balance = (short)(this.balance + creditAmount);
    }

    private void debit(APDU apdu) {
        byte debitAmount;
        if (!this.pin.isValidated()) {
            ISOException.throwIt((short)25345);
        }
        byte[] buffer = apdu.getBuffer();
        byte numBytes = buffer[4];
        byte byteRead = (byte)apdu.setIncomingAndReceive();
        if (numBytes != 1 || byteRead != 1) {
            ISOException.throwIt((short)26368);
        }
        if ((debitAmount = buffer[5]) > 127 || debitAmount < 0) {
            ISOException.throwIt((short)27267);
        }
        if ((short)(this.balance - debitAmount) < 0) {
            ISOException.throwIt((short)27269);
        }
        this.balance = (short)(this.balance - debitAmount);
    }

    private void getBalance(APDU apdu) {
        byte[] buffer = apdu.getBuffer();
        short le = apdu.setOutgoing();
        if (le < 2) {
            ISOException.throwIt((short)26368);
        }
        apdu.setOutgoingLength((short)2);
        buffer[0] = (byte)(this.balance >> 8);
        buffer[1] = (byte)(this.balance & 0xFF);
        apdu.sendBytes((short)0, (short)2);
    }

    private void verify(APDU apdu) {
        byte byteRead;
        byte[] buffer = apdu.getBuffer();
        if (!this.pin.check(buffer, (short)5, byteRead = (byte)apdu.setIncomingAndReceive())) {
            ISOException.throwIt((short)25344);
        }
    }
}

