/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.samples.JavaPurse;

import com.sun.javacard.samples.JavaPurse.Record;
import javacard.framework.ISOException;

class CyclicFile {
    private byte num_record;
    private byte current_record = (byte)-1;
    private byte next_record;
    private Record[] records;

    CyclicFile(byte max_record, byte record_length) {
        this.num_record = max_record = (byte)(max_record + 1);
        this.records = new Record[this.num_record];
        byte i = 0;
        while (i < this.num_record) {
            this.records[i] = new Record(record_length);
            i = (byte)(i + 1);
        }
    }

    byte[] getRecord(byte recordNum) {
        if (recordNum < 1 || recordNum > (byte)(this.num_record - 1)) {
            ISOException.throwIt((short)27267);
        }
        if ((recordNum = (byte)(this.current_record - recordNum + 1)) < 0) {
            recordNum = (byte)(recordNum + this.num_record);
        }
        return this.records[recordNum].record;
    }

    byte findRecord(byte firstByte) {
        byte by = this.num_record;
        this.num_record = (byte)(by - 1);
        byte eRecNum = by;
        byte currentRecNumber = 1;
        while (true) {
            byte[] thisRec = this.getRecord(currentRecNumber);
            if (firstByte == 0) {
                return currentRecNumber;
            }
            if (thisRec[0] == firstByte) {
                return currentRecNumber;
            }
            if (currentRecNumber == eRecNum) {
                return 0;
            }
            currentRecNumber = (byte)(currentRecNumber + 1);
        }
    }

    byte[] getNewLogRecord() {
        byte[] record = this.records[this.next_record].record;
        return record;
    }

    void updateNewLogRecord() {
        this.current_record = (byte)(this.current_record + 1);
        if (this.current_record == this.num_record) {
            this.current_record = 0;
        }
        if ((this.next_record = (byte)(this.next_record + 1)) == this.num_record) {
            this.next_record = 0;
        }
    }
}

