/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.impl.AppletMgr;
import com.sun.javacard.impl.CryptoInit;
import com.sun.javacard.impl.GarbageCollector;
import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackageMgr;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.APDUException;
import javacard.framework.Applet;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.PINException;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.UserException;
import javacard.framework.service.CardRemoteObject;
import javacard.framework.service.ServiceException;
import javacard.security.CryptoException;
import javacardx.apdu.ExtendedLength;
import javacardx.biometry.BioException;
import javacardx.framework.tlv.TLVException;
import javacardx.framework.util.UtilException;

class Dispatcher {
    private static final byte INS_SELECT = -92;
    private static final byte INS_MANAGECHANNEL = 112;
    private static final byte P1_SELECT_DFBYNAME = 4;
    private static final byte P2_SELECT_OPTIONS = -29;
    private static final byte P2_SELECT_OPTIONS_ONLY = 0;
    private static final byte P1_OPEN_CHANNEL = 0;
    private static final byte P1_CLOSE_CHANNEL = -128;
    private static final byte P2_AUTOSELECT_CHANNEL = 0;
    private static final byte ERR_NO_CHANNEL_AVAILABLE = -1;
    private static final byte BASIC_CHANNEL = 0;
    private static ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException;
    private static NegativeArraySizeException negativeArraySizeException;
    private static NullPointerException nullPointerException;
    private static ClassCastException classCastException;
    private static ArithmeticException arithmeticException;
    static SecurityException securityException;
    private static ArrayStoreException arrayStoreException;
    private static SystemException systemException;
    private static TransactionException transactionException;
    private static ServiceException serviceException;
    private static UtilException utilException;
    private static final byte OP_CHANNEL_CLOSE = 0;
    private static final byte OP_CHANNEL_OPEN = 1;
    private static final byte OP_CHANNEL_OPEN_AUTOSELECT = 2;
    private static final byte CHANNEL_CLOSED = 0;
    private static final byte CHANNEL_DISABLED = 1;
    private static final byte CHANNEL_OPEN = 2;
    private static final byte CHANNEL_OPEN_MS = 3;
    private static final byte CHANNEL_MS_MASK = 1;
    private static final byte CHANNEL_OPEN_MASK = 2;
    private static APDU theAPDU;
    private static byte[] theAPDUBuffer;
    private static PrivAccess thePrivAccess;
    static Dispatcher theDispatcher;

    static void main() {
        if (!NativeMethods.isCardInitialized()) {
            Dispatcher.cardInit();
        }
        Dispatcher.cardReset();
        int sw = 0;
        while (true) {
            PrivAccess.resetSelectingAppletFlag();
            PrivAccess.resetProcessMethodFlag();
            theAPDU.complete((short)sw);
            byte activeInterface = NativeMethods.getActiveInterface();
            try {
                theAPDU.verifyLe();
                if (Dispatcher.processAndForward()) {
                    byte commandChannel = NativeMethods.getCurrentlySelectedChannel();
                    if (PrivAccess.getSelectedAppID((byte)commandChannel, (byte)activeInterface) == -1) {
                        ISOException.throwIt((short)27033);
                    }
                    PrivAccess.setProcessMethodFlag();
                    Applet selectedApplet = PrivAccess.getSelectedApplet((byte)commandChannel, (byte)activeInterface);
                    if (selectedApplet instanceof ExtendedLength) {
                        theAPDU.markExtendedSupport(true);
                    } else {
                        theAPDU.markExtendedSupport(false);
                    }
                    selectedApplet.process(theAPDU);
                    if (JCSystem.getTransactionDepth() != 0) {
                        TransactionException.throwIt((short)1);
                    }
                }
                sw = -28672;
            }
            catch (ISOException ex) {
                sw = ex.getReason();
            }
            catch (Throwable e) {
                sw = 28416;
            }
            if (JCSystem.getTransactionDepth() != 0) {
                JCSystem.abortTransaction();
            }
            if (!thePrivAccess.isGarbageCollectionRequested()) continue;
            GarbageCollector.startGC();
        }
    }

    private static void setAPDUChannel() throws SystemException {
        byte theAPDUChannel = APDU.getCLAChannel();
        if (theAPDUChannel >= 20) {
            ISOException.throwIt((short)26753);
        }
        NativeMethods.setCurrentlySelectedChannel((byte)theAPDUChannel, (byte)NativeMethods.getActiveInterface());
    }

    private static boolean processAndForward() throws ISOException {
        if (theAPDU.isISOInterindustryCLA()) {
            Dispatcher.setAPDUChannel();
            switch (theAPDUBuffer[1]) {
                case -92: {
                    if (theAPDU.isSecureMessagingCLA()) break;
                    theDispatcher.selectAPDU(theAPDU);
                    return true;
                }
                case 112: {
                    if (theAPDU.isSecureMessagingCLA()) {
                        ISOException.throwIt((short)26754);
                    }
                    theDispatcher.manageChannelAPDU(theAPDU);
                    return false;
                }
            }
        }
        Dispatcher.setAPDUChannel();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void manageChannelAPDU(APDU theAPDU) throws ISOException {
        newChannel = -1;
        cmdChannel = NativeMethods.getCurrentlySelectedChannel();
        maxChannels = NativeMethods.getMaxChannels();
        activeInterface = NativeMethods.getActiveInterface();
        if (maxChannels == 1) {
            ISOException.throwIt((short)26753);
        }
        if (NativeMethods.getChannelStatus((byte)cmdChannel, (byte)activeInterface) == 0) {
            ISOException.throwIt((short)26753);
        }
        opType = Dispatcher.theAPDUBuffer[2];
        managedChannel = Dispatcher.theAPDUBuffer[3];
        if (managedChannel > 19 || managedChannel < 0) {
            ISOException.throwIt((short)27265);
        }
        channelStatus = NativeMethods.getChannelStatus((byte)managedChannel, (byte)activeInterface);
        switch (opType) {
            case -128: {
                if (managedChannel == 0) {
                    ISOException.throwIt((short)27265);
                }
                if ((channelStatus & 2) == 2) {
                    PrivAccess.deselectOnly((byte)managedChannel, (byte)activeInterface);
                    NativeMethods.channelManage((byte)managedChannel, (byte)activeInterface, (byte)0);
                    break;
                }
                ISOException.throwIt((short)25088);
                break;
            }
            case 0: {
                if (managedChannel == 0) {
                    le = theAPDU.setOutgoing();
                    if (le != 1) {
                        ISOException.throwIt((short)27649);
                    }
                    if ((newChannel = (byte)NativeMethods.channelManage((byte)-1, (byte)activeInterface, (byte)2)) == -1) {
                        ISOException.throwIt((short)27265);
                    }
                } else if (NativeMethods.channelManage((byte)managedChannel, (byte)activeInterface, (byte)1) != -1) {
                    newChannel = managedChannel;
                } else {
                    ISOException.throwIt((short)27270);
                }
                try {
                    if (cmdChannel == 0) {
                        PrivAccess.selectDefaultApplet((byte)newChannel, (byte)activeInterface);
                    } else {
                        selAppletID = PrivAccess.getSelectedAppID((byte)cmdChannel, (byte)activeInterface);
                        if (selAppletID != -1) {
                            PrivAccess.selectOnly((byte)newChannel, (byte)activeInterface, (byte)selAppletID);
                        }
                    }
                }
                catch (ISOException isoEx) {
                    NativeMethods.channelManage((byte)newChannel, (byte)activeInterface, (byte)0);
                    ISOException.throwIt(isoEx.getReason());
                }
                catch (SystemException se) {
                    NativeMethods.channelManage((byte)newChannel, (byte)activeInterface, (byte)0);
                    if (se.getReason() != 5) ** GOTO lbl58
                    if (managedChannel == 0) {
                        ISOException.throwIt((short)27265);
                    }
                    ISOException.throwIt((short)27270);
                }
lbl58:
                // 6 sources

                if (managedChannel != 0) break;
                theAPDU.setOutgoingLength((short)1);
                Dispatcher.theAPDUBuffer[0] = newChannel;
                theAPDU.sendBytes((short)0, (short)1);
                break;
            }
            default: {
                ISOException.throwIt((short)27265);
            }
        }
    }

    void selectAPDU(APDU theAPDU) throws ISOException {
        byte openOK;
        byte selectInterface;
        byte selectChannel = NativeMethods.getCurrentlySelectedChannel();
        if (NativeMethods.getChannelStatus((byte)selectChannel, (byte)(selectInterface = NativeMethods.getActiveInterface())) == 0 && (openOK = NativeMethods.channelManage((byte)selectChannel, (byte)selectInterface, (byte)1)) == -1) {
            ISOException.throwIt((short)26753);
        }
        try {
            if (theAPDUBuffer[2] == 4) {
                byte i;
                if ((theAPDUBuffer[3] & 0xFFFFFFE3) != 0) {
                    return;
                }
                byte len = (byte)theAPDU.setIncomingAndReceive();
                if (len == theAPDUBuffer[4] && (i = AppletMgr.findApplet((byte[])theAPDUBuffer, (short)5, (byte)len)) != -1) {
                    if (PrivAccess.getAppState((AID)thePrivAccess.getAID(i)) >= 2) {
                        if (!PrivAccess.isMultiSelectionOK((byte)selectChannel, (byte)selectInterface, (byte)i)) {
                            ISOException.throwIt((short)27013);
                        }
                        PrivAccess.selectApplet((byte)selectChannel, (byte)selectInterface, (byte)i);
                    } else {
                        PrivAccess.deselectOnly((byte)selectChannel, (byte)selectInterface);
                        NativeMethods.setChannelContext((byte)selectChannel, (byte)selectInterface, (byte)0, (boolean)false);
                    }
                }
                this.undoReceive();
            }
        }
        catch (SystemException se) {
            if (selectChannel != 0) {
                NativeMethods.channelManage((byte)selectChannel, (byte)selectInterface, (byte)0);
            }
            if (se.getReason() == 5) {
                ISOException.throwIt((short)26753);
            }
            SystemException.throwIt(se.getReason());
        }
    }

    void undoReceive() {
        theAPDU.undoIncomingAndReceive();
    }

    static void cardReset() {
        PrivAccess.selectDefaultApplet((byte)0, (byte)0);
        if (GarbageCollector.sweepStarted) {
            GarbageCollector.startGC();
        }
        PackageMgr.restore();
    }

    static void cardInit() {
        Dispatcher.initSystemExceptions();
        if (theDispatcher == null) {
            theDispatcher = new Dispatcher();
        }
        Exception ex = new CardException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        ex = new APDUException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        ex = new ISOException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        ex = new PINException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        ex = new UserException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        ex = new CryptoException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        ex = new BioException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        ex = new TLVException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        theAPDU = new APDU();
        NativeMethods.setJCREentry((Object)theAPDU, (boolean)true);
        thePrivAccess = JCSystem.thePrivAccess = new PrivAccess();
        NativeMethods.setJCREentry((Object)thePrivAccess, (boolean)false);
        GarbageCollector.GCRequested = PrivAccess.getPackedBoolean().allocate();
        theAPDUBuffer = theAPDU.getBuffer();
        NativeMethods.setJCREentry((Object)theAPDUBuffer, (boolean)true);
        CryptoInit.initCryptoStorage();
        PrivAccess.initialize((APDU)theAPDU);
        CardRemoteObject.export(null);
        NativeMethods.setCardInitialized();
    }

    private static void initSystemExceptions() {
        arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException();
        NativeMethods.setJCREentry((Object)arrayIndexOutOfBoundsException, (boolean)true);
        negativeArraySizeException = new NegativeArraySizeException();
        NativeMethods.setJCREentry((Object)negativeArraySizeException, (boolean)true);
        nullPointerException = new NullPointerException();
        NativeMethods.setJCREentry((Object)nullPointerException, (boolean)true);
        classCastException = new ClassCastException();
        NativeMethods.setJCREentry((Object)classCastException, (boolean)true);
        arithmeticException = new ArithmeticException();
        NativeMethods.setJCREentry((Object)arithmeticException, (boolean)true);
        securityException = new SecurityException();
        NativeMethods.setJCREentry((Object)securityException, (boolean)true);
        arrayStoreException = new ArrayStoreException();
        NativeMethods.setJCREentry((Object)arrayStoreException, (boolean)true);
        CardRuntimeException ex = new CardRuntimeException(0);
        NativeMethods.setJCREentry((Object)ex, (boolean)true);
        systemException = new SystemException(0);
        NativeMethods.setJCREentry((Object)systemException, (boolean)true);
        transactionException = new TransactionException(0);
        NativeMethods.setJCREentry((Object)transactionException, (boolean)true);
        serviceException = new ServiceException(0);
        NativeMethods.setJCREentry((Object)serviceException, (boolean)true);
        utilException = new UtilException(0);
        NativeMethods.setJCREentry((Object)utilException, (boolean)true);
    }

    Dispatcher() {
    }
}

