/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Parser;
import com.sun.javacard.jcasm.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public String getMessage() {
        String retval = null;
        String fileName = Parser.getInputSpec();
        if (fileName != null) {
            Object[] args = new Object[]{fileName};
            retval = Msg.getMessage("parser.54", args);
            retval = retval + this.eol;
        }
        if (!this.specialConstructor) {
            retval = retval + super.getMessage();
            return retval;
        }
        String expected = "";
        int maxSize = 0;
        int i = 0;
        while (i < this.expectedTokenSequences.length) {
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < this.expectedTokenSequences[i].length) {
                expected = expected + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                ++j;
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                expected = expected + "...";
            }
            expected = expected + this.eol + "    ";
            ++i;
        }
        String encountered = "";
        Token tok = this.currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                encountered = encountered + " ";
            }
            if (tok.kind == 0) {
                encountered = encountered + this.tokenImage[0];
                break;
            }
            encountered = encountered + this.add_escapes(tok.image);
            tok = tok.next;
            ++i2;
        }
        Object[] args = new Object[]{encountered, new Integer(this.currentToken.next.beginLine), new Integer(this.currentToken.next.beginColumn)};
        retval = retval + Msg.getMessage("parser.50", args);
        retval = retval + this.eol;
        if (this.expectedTokenSequences.length == 1) {
            Object[] moreArgs = new Object[]{expected};
            retval = retval + Msg.getMessage("parser.51", moreArgs);
        } else {
            Object[] moreArgs = new Object[]{expected};
            retval = retval + Msg.getMessage("parser.52", moreArgs);
        }
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

