/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcasm.cap.ProxySI;
import com.sun.javacard.jcasm.cap.SIOProxyClass;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class SIOProxyClassesGen {
    private String package_name;
    private String class_root;
    private String[] export_path;
    private String output_dir;
    private Hashtable<String, MethodDefinition[]> si_methods_table;
    private Vector<Hashtable<String, MethodDefinition[]>> exacts;
    File workDir = null;
    public static Vector<String> classFilesToDelete = new Vector();
    public static Vector<String> sourceFilesToDelete = new Vector();
    String classDir;
    String[] exportDir;
    Vector<String> srcFiles;
    File outPath;
    File[] classFiles;
    ConverterException e = null;
    static final Object lock = new Object();
    Object notifier = new Object();

    public SIOProxyClassesGen(String pkgName, Hashtable<String, MethodDefinition[]> siMethodsTable, String classRoot, String[] exportPath, String outputDir, Vector<Hashtable<String, MethodDefinition[]>> exacts) throws Exception {
        this.package_name = pkgName;
        this.si_methods_table = siMethodsTable;
        this.exacts = exacts;
        this.class_root = classRoot;
        this.export_path = exportPath;
        this.output_dir = outputDir;
    }

    private Map<String, Vector<String>> getDuplicateMethodSignatures(ProxySI p) {
        HashMap<String, Vector<String>> sig_SIs = new HashMap<String, Vector<String>>();
        HashSet<String> uniques = new HashSet<String>();
        HashSet<String> dups = new HashSet<String>();
        Enumeration<String> e = p.getAllInterfaces().keys();
        while (e.hasMoreElements()) {
            String si = e.nextElement();
            Vector<String> v = p.getAllInterfaces().get(si);
            for (int k = 0; k < v.size(); ++k) {
                String sig = v.elementAt(k);
                if (uniques.add(sig)) continue;
                dups.add(sig);
            }
        }
        for (String d : dups) {
            Vector<String> SIs = new Vector<String>();
            Enumeration<String> e1 = p.getAllInterfaces().keys();
            while (e1.hasMoreElements()) {
                String si = e1.nextElement();
                Vector<String> v = p.getAllInterfaces().get(si);
                for (int k = 0; k < v.size(); ++k) {
                    String sig = v.elementAt(k);
                    if (!sig.equals(d)) continue;
                    SIs.addElement(si);
                }
            }
            sig_SIs.put(d, SIs);
        }
        return sig_SIs;
    }

    private Vector<ProxySI> groupSIs() {
        Vector<ProxySI> vp = new Vector<ProxySI>();
        Vector<ProxySI> spares = new Vector<ProxySI>();
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            Enumeration<String> e1 = this.si_methods_table.keys();
            while (e1.hasMoreElements()) {
                String si = e1.nextElement();
                MethodDefinition[] mds = this.si_methods_table.get(si);
                Vector<String> method_signatures = new Vector<String>();
                for (int k = 0; k < mds.length; ++k) {
                    String m_signature = mds[k].getMethodSignature();
                    method_signatures.addElement(m_signature);
                }
                boolean atLeastOneProxyImplementsInterface = false;
                for (int i = 0; i < vp.size(); ++i) {
                    ProxySI p = vp.elementAt(i);
                    if (p.alreadyImplementsInterface(si)) {
                        atLeastOneProxyImplementsInterface = true;
                        continue;
                    }
                    if (p.conflict(si, method_signatures)) continue;
                    boolean proxyIsSubsetOfOtherProxy = false;
                    ProxySI pp = new ProxySI(p);
                    pp.addInto(si, method_signatures);
                    for (int j = 0; j < vp.size(); ++j) {
                        if (!pp.isSubsetOf(vp.elementAt(j))) continue;
                        proxyIsSubsetOfOtherProxy = true;
                        break;
                    }
                    if (proxyIsSubsetOfOtherProxy) {
                        atLeastOneProxyImplementsInterface = true;
                        continue;
                    }
                    pp = new ProxySI(p);
                    spares.addElement(pp);
                    p.spare = false;
                    atLeastOneProxyImplementsInterface = true;
                    p.addInto(si, method_signatures);
                }
                if (atLeastOneProxyImplementsInterface) continue;
                keepGoing = true;
                vp.addElement(new ProxySI(si, method_signatures));
            }
            if (spares.size() <= 0) continue;
            keepGoing = true;
            for (ProxySI p : spares) {
                p.spare = true;
                vp.addElement(p);
            }
            spares.clear();
        }
        Iterator iterator = vp.iterator();
        while (iterator.hasNext()) {
            ProxySI p = (ProxySI)iterator.next();
            if (!p.spare) continue;
            iterator.remove();
        }
        return vp;
    }

    public File[] generate() throws Exception {
        if (this.si_methods_table.size() == 0) {
            return null;
        }
        Vector<String> allInterfaces = new Vector<String>();
        Enumeration<String> e = this.si_methods_table.keys();
        while (e.hasMoreElements()) {
            allInterfaces.addElement(e.nextElement());
        }
        Vector<ProxySI> vp = this.groupSIs();
        ProxySI proxySI = null;
        for (int i = 0; i < this.exacts.size(); ++i) {
            Hashtable<String, MethodDefinition[]> exact = this.exacts.elementAt(i);
            Enumeration<String> e1 = exact.keys();
            boolean first = true;
            while (e1.hasMoreElements()) {
                String si = e1.nextElement();
                MethodDefinition[] mds = exact.get(si);
                Vector<String> method_signatures = new Vector<String>();
                for (int k = 0; k < mds.length; ++k) {
                    String m_signature = mds[k].getMethodSignature();
                    method_signatures.addElement(m_signature);
                }
                if (first) {
                    first = false;
                    proxySI = new ProxySI(si, method_signatures);
                    continue;
                }
                proxySI.addInto(si, method_signatures);
            }
            if (vp.contains(proxySI)) continue;
            vp.addElement(proxySI);
        }
        Vector<SIOProxyClass> sioProxyClasses = new Vector<SIOProxyClass>();
        for (int i = 0; i < vp.size(); ++i) {
            String name = "Proxy" + (i + 1);
            ProxySI p = vp.elementAt(i);
            Hashtable<String, Vector<String>> si_mSigs = p.getSIMethodSignatureMappings();
            Map<String, Vector<String>> dup_sig_SIs = this.getDuplicateMethodSignatures(p);
            SIOProxyClass proxyClass = new SIOProxyClass(this.package_name, allInterfaces, dup_sig_SIs, name, si_mSigs);
            sioProxyClasses.addElement(proxyClass);
        }
        File srcOutPath = new File(this.output_dir + File.separatorChar + this.package_name.replace('/', File.separatorChar) + File.separatorChar + "proxy");
        File clsOutPath = new File(this.output_dir);
        Vector<String> srcFiles = this.outputSourceFiles(sioProxyClasses, srcOutPath);
        return this.compileSourceFiles(this.class_root, this.export_path, srcFiles, clsOutPath);
    }

    Vector<String> outputSourceFiles(Vector<SIOProxyClass> sioProxyClasses, File outPath) throws IOException {
        Vector<String> fNames = new Vector<String>();
        for (SIOProxyClass clz : sioProxyClasses) {
            File returnedFile = this.writeSIOProxySourceFile(clz, outPath);
            if (!returnedFile.exists()) continue;
            fNames.addElement(returnedFile.getPath());
        }
        StringBuffer sb = null;
        Enumeration<String> e1 = this.si_methods_table.keys();
        while (e1.hasMoreElements()) {
            sb = new StringBuffer();
            String si = e1.nextElement();
            String fullClassName = si.replace('/', '.');
            int ndx = fullClassName.lastIndexOf(".");
            String thisPackageName = fullClassName.substring(0, ndx);
            String thisClassName = fullClassName.substring(ndx + 1);
            sb.append("package ");
            sb.append(thisPackageName);
            sb.append(";\n");
            sb.append("import javacard.framework.Shareable;\n");
            sb.append("public interface ");
            sb.append(thisClassName);
            sb.append(" extends Shareable {\n");
            MethodDefinition[] mds = this.si_methods_table.get(si);
            for (int k = 0; k < mds.length; ++k) {
                String sig = mds[k].getMethodSignature();
                String name = MethodDescriptor.getMethodNameFromSignature(sig);
                String des = MethodDescriptor.getMethodDescriptorFromSignature(sig);
                String return_des = MethodDescriptor.getReturnDescriptor(des);
                String[] params = MethodDescriptor.getParamDescriptors(des);
                String return_type_name = Names.getTypeStringInJavaStyle(return_des);
                sb.append(return_type_name);
                String baseType = return_des;
                while (baseType.startsWith("[")) {
                    baseType = baseType.substring(1);
                }
                boolean b1 = DataType.getType(baseType) == 10;
                String tmp = return_type_name.replace('.', '/');
                boolean b2 = this.si_methods_table.keySet().contains(tmp);
                if (b1 && !b2) {
                    this.generateJavaInterfaceForType(return_type_name);
                }
                sb.append(" ");
                sb.append(name + "(");
                for (int i = 0; i < params.length; ++i) {
                    baseType = params[i];
                    while (baseType.startsWith("[")) {
                        baseType = baseType.substring(1);
                    }
                    b1 = DataType.getType(baseType) == 10;
                    String mParam = Names.getTypeStringInJavaStyle(params[i]);
                    tmp = mParam.replace('.', '/');
                    b2 = this.si_methods_table.keySet().contains(tmp);
                    if (b1 && !b2) {
                        this.generateJavaInterfaceForType(mParam);
                    }
                    sb.append(mParam + " ");
                    sb.append("param" + (i + 1));
                    if (i == params.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(");\n");
            }
            sb.append("}\n");
            String s = this.package_name.replace('/', '.') + ".";
            if (fullClassName.startsWith(s)) continue;
            String f = thisPackageName.replace('.', '/');
            File file = new File(this.output_dir + "/" + f);
            file.mkdirs();
            file = new File(file, thisClassName + ".java");
            this.fileWriter(file, sb);
        }
        return fNames;
    }

    File[] compileSourceFiles(String classDir1, String[] exportDir1, Vector<String> srcFiles1, File outPath1) throws Exception {
        this.classDir = classDir1;
        this.exportDir = exportDir1;
        this.srcFiles = srcFiles1;
        this.outPath = outPath1;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> fileUnits = fileManager.getJavaFileObjectsFromStrings(this.srcFiles);
        Vector<String> options = new Vector<String>();
        options.addElement("-d");
        options.addElement(this.outPath.getPath());
        options.addElement("-bootclasspath");
        String jcHome = System.getProperty("jc.home");
        if (jcHome == null) {
            Notifier.error("converter.12");
        }
        options.addElement(jcHome + "/lib/api_connected.jar");
        options.addElement("-classpath");
        StringBuffer sb = new StringBuffer();
        sb.append(this.classDir);
        sb.append(File.pathSeparator);
        sb.append(this.output_dir);
        options.addElement(sb.toString());
        boolean b = compiler.getTask(null, fileManager, diagnostics, options, null, fileUnits).call();
        try {
            fileManager.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!b) {
            Notifier.error("converter.13");
        }
        int k = 0;
        this.classFiles = new File[this.srcFiles.size()];
        for (String sourceFileName : this.srcFiles) {
            sourceFilesToDelete.add(sourceFileName);
            String className = sourceFileName.replaceAll("\\.java", "\\.class");
            classFilesToDelete.add(className);
            this.classFiles[k++] = new File(className);
        }
        return this.classFiles;
    }

    private File writeSIOProxySourceFile(SIOProxyClass proxy_file, File output_path) throws IOException {
        if (!output_path.exists()) {
            output_path.mkdir();
        }
        String file_name = proxy_file.getClassName() + ".java";
        File file = new File(output_path, file_name);
        FileOutputStream fos = new FileOutputStream(file);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos));
        proxy_file.toBinary(dos);
        dos.flush();
        dos.close();
        return file;
    }

    private void generateJavaInterfaceForType(String s) throws IOException {
        if (s.startsWith("java.") || s.startsWith("javax.") || s.startsWith("javacard.") || s.startsWith("javacardx.")) {
            return;
        }
        if (s.startsWith(this.package_name.replace('/', '.') + ".")) {
            return;
        }
        int ndx = s.lastIndexOf(".");
        String thisPackageName = s.substring(0, ndx);
        String thisClassName = s.substring(ndx + 1);
        StringBuffer sb = new StringBuffer();
        sb.append("package ");
        sb.append(thisPackageName);
        sb.append(";\n");
        sb.append("import javacard.framework.Shareable;\n");
        sb.append("public interface ");
        sb.append(thisClassName);
        sb.append(" extends Shareable {}\n");
        String f = thisPackageName.replace('.', '/');
        File file = new File(this.output_dir + "/" + f);
        file.mkdirs();
        file = new File(file, thisClassName + ".java");
        this.fileWriter(file, sb);
    }

    private void fileWriter(File file, StringBuffer sb) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        DataOutputStream dos = new DataOutputStream(bos);
        dos.write(sb.toString().getBytes());
        dos.close();
        bos.close();
        fos.close();
    }
}

