/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SIOProxyClass {
    static String COPYRIGHT = "/* \n * Copyright (c) 2009 Sun Microsystems, Inc. \n * All rights reserved. \n * Use is subject to license terms. \n */\n";
    String package_name;
    Vector<String> imports;
    String proxy_name;
    Vector<String> all_ref_SIs;
    Map<String, Vector<String>> duplicate_sig_SIs;
    Hashtable<String, Vector<String>> si_method_signatures;
    String formattedSIOProxyClass = null;

    public SIOProxyClass(String pkgName, Vector<String> allRefSIs, Map<String, Vector<String>> duplicateSigToSIs, String proxyName, Hashtable<String, Vector<String>> siMethodSignatures) {
        this.proxy_name = proxyName;
        this.package_name = pkgName.replaceAll("/", ".") + ".proxy";
        this.all_ref_SIs = allRefSIs;
        this.all_ref_SIs.addElement("javacard/framework/Shareable");
        this.duplicate_sig_SIs = duplicateSigToSIs;
        this.si_method_signatures = siMethodSignatures;
        this.formatClass();
    }

    private void formatImports() {
        this.imports = new Vector();
        this.imports.addElement("javacardx.framework.ClassicSIOProxy");
        Enumeration<String> e1 = this.si_method_signatures.keys();
        while (e1.hasMoreElements()) {
            String si = e1.nextElement();
            String siClassName = si.replaceAll("/", ".");
            if (!this.imports.contains(siClassName)) {
                this.imports.addElement(siClassName);
            }
            Vector<String> metdodSignatures = this.si_method_signatures.get(si);
            Enumeration<String> e = metdodSignatures.elements();
            while (e.hasMoreElements()) {
                String mReturn;
                String sig = e.nextElement();
                String desc = MethodDescriptor.getMethodDescriptorFromSignature(sig);
                String ret = MethodDescriptor.getReturnDescriptor(desc);
                String[] params = MethodDescriptor.getParamDescriptors(desc);
                String baseType = ret;
                while (baseType.startsWith("[")) {
                    baseType = baseType.substring(1);
                }
                if (DataType.getType(baseType) == 10 && !this.imports.contains(mReturn = Names.getTypeStringInJavaStyle(baseType))) {
                    this.imports.add(mReturn);
                }
                for (int i = 0; i < params.length; ++i) {
                    String mParameter;
                    baseType = params[i];
                    while (baseType.startsWith("[")) {
                        baseType = baseType.substring(1);
                    }
                    if (DataType.getType(baseType) != 10 || this.imports.contains(mParameter = Names.getTypeStringInJavaStyle(baseType))) continue;
                    this.imports.add(mParameter);
                }
            }
        }
    }

    public String getClassName() {
        return this.proxy_name;
    }

    public void formatClass() {
        StringBuffer sb = new StringBuffer();
        sb.append(COPYRIGHT);
        sb.append("package " + this.package_name + ";\n\n");
        this.formatImports();
        Iterator<String> i = this.imports.iterator();
        while (i.hasNext()) {
            sb.append("import " + i.next() + ";\n");
        }
        sb.append("\n");
        sb.append("public class " + this.proxy_name + " extends " + "ClassicSIOProxy \n");
        sb.append("                    implements ");
        Enumeration<String> e1 = this.si_method_signatures.keys();
        while (e1.hasMoreElements()) {
            String si = e1.nextElement();
            sb.append(Names.getClassName(si, 47));
            if (e1.hasMoreElements()) {
                sb.append(", ");
                continue;
            }
            sb.append(" {\n");
        }
        Enumeration<String> e2 = this.si_method_signatures.keys();
        while (e2.hasMoreElements()) {
            String si = e2.nextElement();
            Vector<String> metdodSignatures = this.si_method_signatures.get(si);
            Enumeration<String> e3 = metdodSignatures.elements();
            while (e3.hasMoreElements()) {
                String signature = e3.nextElement();
                this.formatMethodEntry(sb, si, signature);
            }
        }
        sb.append("}\n");
        this.formattedSIOProxyClass = sb.toString();
    }

    public void toBinary(DataOutputStream dos) throws IOException {
        dos.write(this.formattedSIOProxyClass.getBytes());
    }

    private void formatMethodEntry(StringBuffer sb, String si, String sig) {
        boolean requiredGetInstance = false;
        String mDesc = MethodDescriptor.getMethodDescriptorFromSignature(sig);
        String mRetDesc = MethodDescriptor.getReturnDescriptor(mDesc);
        if (DataType.getType(mRetDesc) == 10) {
            requiredGetInstance = true;
        }
        String[] mParamDescs = MethodDescriptor.getParamDescriptors(mDesc);
        for (int i = 0; i < mParamDescs.length; ++i) {
            if (DataType.getType(mParamDescs[i]) != 10) continue;
            requiredGetInstance = true;
        }
        if (requiredGetInstance) {
            this.formatMethodsWithGetInstance(sb, si, sig);
        } else {
            this.formatMethods(sb, si, sig);
        }
    }

    private void formatMethodsWithGetInstance(StringBuffer sb, String si, String sig) {
        String mDesc = MethodDescriptor.getMethodDescriptorFromSignature(sig);
        String mRetDesc = MethodDescriptor.getReturnDescriptor(mDesc);
        String mReturn = Names.getTypeStringInJavaStyle(mRetDesc);
        mReturn = Names.getClassName(mReturn, 46);
        String mPrototypeTyped = this.getMethodPrototypeTyped(sig);
        sb.append("\n");
        sb.append("    public " + mReturn + " " + mPrototypeTyped + " {\n");
        sb.append("        try {\n");
        sb.append("            synchronized (CLASSIC_APPLET_CONTAINER_MUTEX) {\n");
        String retPrototype = this.getReturnPrototype(si, sig);
        sb.append(retPrototype);
        sb.append("        } catch (ClassNotFoundException e) {\n");
        sb.append("            throw new RuntimeException(\"SIO Synchronization Proxy Error: Class Not Found\");\n");
        sb.append("        } catch (InstantiationException e) {\n");
        sb.append("            throw new RuntimeException(\"SIO Synchronization Proxy Error: Instantiation Exception\");\n");
        sb.append("        }\n");
        sb.append("    }\n");
    }

    private String getMethodPrototypeTyped(String sig) {
        String mName = MethodDescriptor.getMethodNameFromSignature(sig);
        String mDesc = MethodDescriptor.getMethodDescriptorFromSignature(sig);
        String[] mParamDescs = MethodDescriptor.getParamDescriptors(mDesc);
        StringBuffer sb = new StringBuffer();
        sb.append(mName + "(");
        for (int i = 0; i < mParamDescs.length; ++i) {
            String mParam = Names.getTypeStringInJavaStyle(mParamDescs[i]);
            mParam = Names.getClassName(mParam, 46);
            sb.append(mParam + " ");
            sb.append("param" + (i + 1));
            if (i == mParamDescs.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getMethodPrototype(String mName, String[] mParamDescs) {
        StringBuffer sb = new StringBuffer();
        sb.append(mName + "(");
        for (int i = 0; i < mParamDescs.length; ++i) {
            String mParam = Names.getTypeStringInJavaStyle(mParamDescs[i]);
            mParam = mParam.replace('.', '/');
            boolean isObject = false;
            if (DataType.getType(mParamDescs[i]) == 10) {
                isObject = true;
            }
            if (isObject) {
                mParam = Names.getClassName(mParam, 47);
                sb.append("(" + mParam + ")processParam(");
            }
            sb.append("param" + (i + 1));
            if (isObject) {
                sb.append(")");
            }
            if (i == mParamDescs.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getReturnPrototype(String si, String sig) {
        StringBuffer sb = new StringBuffer();
        String mName = MethodDescriptor.getMethodNameFromSignature(sig);
        String mDesc = MethodDescriptor.getMethodDescriptorFromSignature(sig);
        String[] mParamDescs = MethodDescriptor.getParamDescriptors(mDesc);
        String mRetDesc = MethodDescriptor.getReturnDescriptor(mDesc);
        String mPrototype = this.getMethodPrototype(mName, mParamDescs);
        if (this.duplicate_sig_SIs.containsKey(sig)) {
            int count = 1;
            Vector<String> SIs = this.duplicate_sig_SIs.get(sig);
            String[] a = new String[SIs.size()];
            for (String d_si : SIs.toArray(a)) {
                d_si = Names.getClassName(d_si, 47);
                if (count == 1) {
                    sb.append("                if (getSIO() instanceof " + d_si + ") {\n");
                } else {
                    sb.append("                else if (getSIO() instanceof " + d_si + ") {\n");
                }
                boolean returns = false;
                boolean returnsObject = false;
                String mReturn = null;
                if (DataType.getType(mRetDesc) != 9) {
                    returns = true;
                    mReturn = Names.getTypeStringInJavaStyle(mRetDesc);
                    mReturn = mReturn.replaceAll("\\.", "/");
                    if (DataType.getType(mRetDesc) == 10) {
                        returnsObject = true;
                    }
                    mReturn = Names.getClassName(mReturn, 47);
                }
                if (returns) {
                    sb.append("                     return ");
                }
                if (returnsObject) {
                    sb.append("(" + mReturn + ")" + "processReturn(");
                }
                sb.append("((" + d_si + ")getSIO())." + mPrototype);
                if (returnsObject) {
                    sb.append(")");
                }
                sb.append(";\n");
                sb.append("                }\n");
                ++count;
            }
            sb.append("                else {\n");
            sb.append("                    throw new RuntimeException(\"SIO Synchronization Proxy Error\");\n");
            sb.append("                }\n");
            sb.append("            }\n");
        } else {
            boolean returnsObject = false;
            String mReturn = null;
            si = Names.getClassName(si, 47);
            sb.append("            ");
            if (DataType.getType(mRetDesc) != 9) {
                mReturn = Names.getTypeStringInJavaStyle(mRetDesc);
                mReturn = mReturn.replace('.', '/');
                if (DataType.getType(mRetDesc) == 10) {
                    returnsObject = true;
                }
                mReturn = Names.getClassName(mReturn, 47);
                sb.append("return ");
            }
            if (returnsObject) {
                sb.append("(" + mReturn + ")" + "processReturn(");
            }
            sb.append("((" + si + ")getSIO())." + mPrototype);
            if (returnsObject) {
                sb.append(")");
            }
            sb.append(";\n");
            sb.append(" }\n");
        }
        return sb.toString();
    }

    private void formatMethods(StringBuffer sb, String si, String sig) {
        String mName = MethodDescriptor.getMethodNameFromSignature(sig);
        String mDesc = MethodDescriptor.getMethodDescriptorFromSignature(sig);
        String[] mParamDescs = MethodDescriptor.getParamDescriptors(mDesc);
        String[] mParams = new String[mParamDescs.length];
        for (int i = 0; i < mParamDescs.length; ++i) {
            mParams[i] = Names.getTypeStringInJavaStyle(mParamDescs[i]);
        }
        String mRetDesc = MethodDescriptor.getReturnDescriptor(mDesc);
        String mReturn = Names.getTypeStringInJavaStyle(mRetDesc);
        String mPrototype = Names.getMethodPrototypeInJavaStyle(mName, mParams, false);
        String mPrototypeTyped = Names.getMethodPrototypeInJavaStyle(mName, mParams, true);
        mReturn = Names.getClassName(mReturn, 46);
        sb.append("\n");
        sb.append("    public " + mReturn + " " + mPrototypeTyped + " {\n");
        sb.append("        synchronized (CLASSIC_APPLET_CONTAINER_MUTEX) {\n");
        if (this.duplicate_sig_SIs.containsKey(sig)) {
            int count = 1;
            Vector<String> SIs = this.duplicate_sig_SIs.get(sig);
            String[] a = new String[SIs.size()];
            for (String d_si : SIs.toArray(a)) {
                d_si = Names.getClassName(d_si, 47);
                if (count == 1) {
                    sb.append("            if (getSIO() instanceof " + d_si + ") {\n");
                } else {
                    sb.append("            else if (getSIO() instanceof " + d_si + ") {\n");
                }
                if (DataType.getType(mRetDesc) != 9) {
                    sb.append("return ");
                }
                sb.append("                ((" + d_si + ")getSIO())." + mPrototype + ";\n");
                sb.append("            }\n");
                ++count;
            }
            sb.append("            else {\n");
            sb.append("                throw new RuntimeException(\"SIO Synchronization Proxy Error\");\n");
            sb.append("            }\n");
        } else {
            si = Names.getClassName(si, 47);
            if (DataType.getType(mRetDesc) != 9) {
                sb.append("return ");
            }
            sb.append("((" + si + ")getSIO())." + mPrototype + ";\n");
        }
        sb.append("}\n");
        sb.append("    }\n");
    }
}

