/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.converter.util.MethodDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ProxySI {
    public boolean spare;
    Vector<String> sis = new Vector();
    Set<String> m_sigs = new HashSet<String>();
    Hashtable<String, Vector<String>> si_msigs = new Hashtable();
    Hashtable<String, Vector<String>> allInterfaces = new Hashtable();

    public ProxySI() {
    }

    public ProxySI(ProxySI other) {
        this();
        for (Map.Entry<String, Vector<String>> mapEntry : other.allInterfaces.entrySet()) {
            String k = mapEntry.getKey();
            Vector<String> v = mapEntry.getValue();
            this.addInto(k, v);
        }
    }

    public ProxySI(String si, Vector<String> mSigs) {
        this.sis.addElement(si);
        this.m_sigs.addAll(mSigs);
        this.si_msigs.put(si, mSigs);
        this.allInterfaces.put(si, mSigs);
    }

    public void addSI(String si) {
        this.sis.addElement(si);
    }

    public void addMethodSignature(String mSig) {
        this.m_sigs.add(mSig);
    }

    public void addMethodSignatures(Vector<String> mSigs) {
        this.m_sigs.addAll(mSigs);
    }

    public boolean addInto(String si, Vector<String> mSigs) {
        HashSet<String> diff = new HashSet<String>(mSigs);
        diff.removeAll(this.m_sigs);
        if (this.conflict(si, mSigs)) {
            return false;
        }
        this.addSI(si);
        this.m_sigs.addAll(mSigs);
        this.si_msigs.put(si, new Vector<String>(diff));
        this.allInterfaces.put(si, mSigs);
        return true;
    }

    public boolean conflict(String si, Vector<String> mSigs) {
        HashSet<String> diff = new HashSet<String>(mSigs);
        diff.removeAll(this.m_sigs);
        HashMap<String, String> m_name_desc = new HashMap<String, String>();
        for (String m_sig : this.m_sigs) {
            String m_name = MethodDescriptor.getMethodNameFromSignature(m_sig);
            String m_desc = MethodDescriptor.getMethodDescriptorFromSignature(m_sig);
            m_name_desc.put(m_name, m_desc);
        }
        if (diff.size() != 0) {
            for (String n_sig : diff) {
                String m_desc;
                String n_name = MethodDescriptor.getMethodNameFromSignature(n_sig);
                String n_desc = MethodDescriptor.getMethodDescriptorFromSignature(n_sig);
                if (!m_name_desc.containsKey(n_name) || n_desc.equals(m_desc = (String)m_name_desc.get(n_name))) continue;
                return true;
            }
        }
        return false;
    }

    public Vector<String> getSIs() {
        return this.sis;
    }

    public Set<String> getMethodSignatures() {
        return this.m_sigs;
    }

    public Hashtable<String, Vector<String>> getSIMethodSignatureMappings() {
        return this.si_msigs;
    }

    public Hashtable<String, Vector<String>> getAllInterfaces() {
        return this.allInterfaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ProxySI other = (ProxySI)o;
        if (this.spare != other.spare) {
            return false;
        }
        return this.allInterfaces.equals(other.allInterfaces);
    }

    public boolean isSubsetOf(ProxySI otherProxy) {
        if (this == otherProxy) {
            return false;
        }
        for (Map.Entry<String, Vector<String>> m : this.allInterfaces.entrySet()) {
            if (otherProxy.alreadyImplementsInterface(m.getKey())) continue;
            return false;
        }
        return true;
    }

    public boolean alreadyImplementsInterface(String interfaceName) {
        Vector<String> v = this.allInterfaces.get(interfaceName);
        return v != null;
    }
}

