/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.EfExportFile;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class ExportFileManager {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    private String[] export_path;
    private Vector<EfExportFile> export_files;
    private Vector<File> exportFiles;
    private ConversionProfile conversionProfile;
    private Hashtable<String, File> exportFilesHS;

    public ExportFileManager(ConversionProfile cp, Hashtable<String, File> exportFilesHS) {
        this.export_path = cp.export_path;
        this.export_files = new Vector(20);
        this.exportFiles = new Vector(20);
        this.conversionProfile = cp;
        this.exportFilesHS = exportFilesHS != null ? exportFilesHS : new Hashtable();
    }

    public Vector<File> getJavaExportFiles() {
        return this.exportFiles;
    }

    private void verifyExportFile(File f) throws Exception {
        try {
            ExportFile ef = ExportFile.readFromFile(f);
            ef.verify();
        }
        catch (NoClassDefFoundError e1) {
            Notifier.error("converter.7");
            throw new ConverterException();
        }
        catch (Exception e) {
            String str = e.getMessage();
            Object[] param = new Object[]{str};
            Notifier.error("converter.8", param);
            throw new ConverterException();
        }
    }

    public EfExportFile[] getExportFiles() {
        Object[] ef_files = new EfExportFile[this.export_files.size()];
        this.export_files.copyInto(ef_files);
        return ef_files;
    }

    private EfExportFile buildExportFile(File file, String package_name) throws Exception {
        if (file.isFile()) {
            EfExportFile export_file = new EfExportFile();
            try {
                Notifier.progress("progress.1", file.getCanonicalPath());
                if (this.conversionProfile == null || !this.conversionProfile.noVerify) {
                    this.verifyExportFile(file);
                }
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                export_file.parse(dis);
                export_file.resolve();
                this.export_files.addElement(export_file);
                this.exportFiles.addElement(file);
                dis.close();
                this.checkBinaryCompatibility(export_file);
                return export_file;
            }
            catch (FileNotFoundException fnfe) {
                Object[] args = new String[]{Names.getExportFileName(package_name), package_name.replace('/', '.')};
                Notifier.error("linking.1", args);
                throw new ConverterException();
            }
            catch (StreamCorruptedException sce) {
                Notifier.error("converter.6");
                throw new ConverterException();
            }
            catch (IOException ie) {
                Notifier.error("converter.1", Names.getExportFileName(package_name));
                throw new ConverterException();
            }
        }
        return null;
    }

    public EfExportFile load(String package_name) throws Exception {
        EfExportFile export_file = null;
        File file = this.exportFilesHS.get(package_name);
        if (file != null && (export_file = this.buildExportFile(file, package_name)) != null) {
            return export_file;
        }
        char c = File.separatorChar;
        String ef_name = new String(package_name.replace('/', c) + c + "javacard" + c + Names.getExportFileName(package_name));
        for (String path : this.export_path) {
            if (path.endsWith(".jar") || (export_file = this.buildExportFile(file = new File(path, ef_name), package_name)) == null) continue;
            return export_file;
        }
        Object[] args = new String[]{Names.getExportFileName(package_name), package_name.replace('/', '.')};
        Notifier.error("linking.1", args);
        throw new ConverterException();
    }

    public EfExportFile getExportFile(String package_name) throws Exception {
        Enumeration<EfExportFile> e = this.export_files.elements();
        while (e.hasMoreElements()) {
            EfExportFile export_file = e.nextElement();
            if (!export_file.getPackageName().equals(package_name)) continue;
            return export_file;
        }
        return this.load(package_name);
    }

    private boolean areAidsEqual(byte[] aid1, byte[] aid2) {
        if (aid1 == null && aid2 == null) {
            return true;
        }
        if (aid1 == null || aid2 == null) {
            return false;
        }
        if (aid1.length != aid2.length) {
            return false;
        }
        for (int i = 0; i < aid1.length; ++i) {
            if (aid1[i] == aid2[i]) continue;
            return false;
        }
        return true;
    }

    public EfExportFile getExportFile(byte[] aid) {
        for (int i = 0; i < this.export_files.size(); ++i) {
            EfExportFile f = this.export_files.elementAt(i);
            if (!this.areAidsEqual(aid, f.getAID())) continue;
            return f;
        }
        return null;
    }

    public EfExportFile getExportFileIfAvailable(String package_name) {
        Enumeration<EfExportFile> e = this.export_files.elements();
        while (e.hasMoreElements()) {
            EfExportFile export_file = e.nextElement();
            if (!export_file.getPackageName().equals(package_name)) continue;
            return export_file;
        }
        return null;
    }

    public EfClass getClass(String class_name) throws Exception {
        String package_name = Names.getPackageName(class_name);
        EfExportFile ef_file = this.getExportFile(package_name);
        if (ef_file == null) {
            return null;
        }
        return ef_file.getClass(class_name);
    }

    public EfClass getClassIfAvailable(String class_name) {
        String package_name = Names.getPackageName(class_name);
        EfExportFile ef_file = this.getExportFileIfAvailable(package_name);
        if (ef_file == null) {
            return null;
        }
        return ef_file.getClass(class_name);
    }

    public EfMethod getMethod(String class_name, String method_name, String method_descriptor) throws Exception {
        EfClass ef_class = this.getClass(class_name);
        if (ef_class == null) {
            return null;
        }
        return ef_class.getMethod(method_name, method_descriptor);
    }

    public EfField getField(String class_name, String field_name, String field_descriptor) throws Exception {
        EfClass ef_class = this.getClass(class_name);
        if (ef_class == null) {
            return null;
        }
        return ef_class.getField(field_name, field_descriptor);
    }

    private void checkBinaryCompatibility(EfExportFile export_file) throws Exception {
        if (export_file.getMajorVersion() != 2) {
            Object[] args = new Object[]{Names.getExportFileName(export_file.getPackageName()), messages.getString("major")};
            Notifier.error("binary.1", args);
            throw new ConverterException();
        }
        if (export_file.getMinorVersion() < 1 || export_file.getMinorVersion() > 2) {
            Object[] args = new Object[]{Names.getExportFileName(export_file.getPackageName()), messages.getString("minor")};
            Notifier.error("binary.1", args);
            throw new ConverterException();
        }
    }
}

