/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.classfile.instructions.JInstrIntBranch;
import com.sun.javacard.classfile.instructions.JInstrLookupSwitch;
import com.sun.javacard.classfile.instructions.JInstrNoOperands;
import com.sun.javacard.classfile.instructions.JInstrShortBranch;
import com.sun.javacard.classfile.instructions.JInstrTableSwitch;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.ClassConverter;
import com.sun.javacard.converter.converters.ExceptionTableConverter;
import com.sun.javacard.converter.converters.I2SException;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstrLoadConverter;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.LocalVariableConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.converters.PackageConverter;
import com.sun.javacard.converter.converters.RecalculateIndexException;
import com.sun.javacard.converter.converters.RollBackException;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class MethodConverter {
    private JMethod java_method;
    private JcMethod jc_method;
    private ClassConverter c_converter;
    private PackageConverter p_converter;
    private InstrContainer instr_containers;
    private LocalVariableConverter local_var_converter;
    private JcLocalVariable[] jc_locals;
    private JcException[] jc_exceptions;
    private int nargs;
    private int max_locals;
    private int max_stack;

    public MethodConverter(JMethod java_method, ClassConverter c_converter, PackageConverter p_converter) {
        this.java_method = java_method;
        this.c_converter = c_converter;
        this.p_converter = p_converter;
        this.jc_method = new JcMethod(java_method);
        if (c_converter.getJcClass().getEfClass() != null) {
            this.jc_method.setEfMethod(c_converter.getJcClass().getEfClass().getMethod(java_method.getMethodName(), java_method.getMethodDescriptor()));
        }
    }

    public InstrContainer getInstrContainers() {
        return this.instr_containers;
    }

    public boolean isIntSupported() {
        return this.p_converter.isIntSupported();
    }

    public JcConstantPool getJcConstantPool() {
        return this.p_converter.getJcConstantPool();
    }

    public String getClassName() {
        return this.c_converter.getJavaClass().getClassName();
    }

    public String getMethodName() {
        return this.java_method.getMethodName();
    }

    public String getMethodDescriptor() {
        return this.java_method.getMethodDescriptor();
    }

    public ClassConverter getClassConverter() {
        return this.c_converter;
    }

    public PackageConverter getPackageConverter() {
        return this.p_converter;
    }

    public JMethod getJavaMethod() {
        return this.java_method;
    }

    public JcMethod getJcMethod() {
        return this.jc_method;
    }

    public JcMethod convert() throws Exception {
        if ((this.java_method.isPublic() || this.java_method.isProtected()) && this.getClassConverter().getJavaClass().isPublic()) {
            this.checkMethodSignature();
        }
        if (!this.getMethodName().equals("<init>")) {
            // empty if block
        }
        if (!this.p_converter.convertByteCode()) {
            return this.jc_method;
        }
        JInstruction code = this.java_method.getCode();
        if (code == null) {
            this.jc_exceptions = new JcException[0];
            this.jc_method.setExceptions(this.jc_exceptions);
            this.jc_locals = new JcLocalVariable[0];
            this.jc_method.setLocalVariables(this.jc_locals);
            for (int i = 0; i < this.jc_locals.length; ++i) {
                if (!"I".equals(this.jc_locals[i].getDescriptor())) continue;
                this.getPackageConverter().getJcPackage().setIntFlag(true);
            }
            this.setNargs();
            return this.jc_method;
        }
        this.jc_locals = this.computeLocals();
        this.jc_method.setLocalVariables(this.jc_locals);
        for (int i = 0; i < this.jc_locals.length; ++i) {
            if (this.jc_locals[i] == null || this.jc_locals[i].getDescriptor() == null || !"I".equals(this.jc_locals[i].getDescriptor())) continue;
            this.getPackageConverter().getJcPackage().setIntFlag(true);
        }
        this.constructInstrContainers(code);
        this.constructControlFlowGraph();
        this.jc_exceptions = this.constructExceptions();
        this.jc_method.setExceptions(this.jc_exceptions);
        boolean done = false;
        this.instr_containers.setOperandStack(new OperandStack());
        while (!done) {
            done = true;
            InstrContainer cur_instr_container = this.instr_containers;
            while (cur_instr_container != null) {
                try {
                    if (cur_instr_container.isCatchFinallyBlockLeader() && cur_instr_container.getOperandStack() == null) {
                        OperandStack operand_stack = new OperandStack();
                        operand_stack.push(10, null);
                        cur_instr_container.setOperandStack(operand_stack);
                    }
                    if (cur_instr_container.hasChanged()) {
                        block19: {
                            done = false;
                            cur_instr_container.reset();
                            JInstruction cur_java_instr = cur_instr_container.getJInstr();
                            InstructionConverter instr_converter = InstructionConverter.create(cur_instr_container, this);
                            try {
                                JcInstruction cur_jc_instr = instr_converter.convert();
                                cur_instr_container.setJcInstr(cur_jc_instr);
                            }
                            catch (I2SException e) {
                                cur_instr_container.setJcInstr(e.getJcInstruction());
                                if (e.isBefore() && e.getNumInstrBack() == 0 && cur_instr_container.getJcInstr().getOpcode() != 94 && cur_instr_container.getPrevInstrContainer() != null && cur_instr_container.getPrevInstrContainer().getJcInstr().getOpcode() != 94) {
                                    this.insertI2SBefore(cur_instr_container);
                                }
                                if (e.getNumInstrBack() <= 0) break block19;
                                int counter = e.getNumInstrBack();
                                InstrContainer tempCont = cur_instr_container;
                                while (counter-- > 0) {
                                    tempCont = tempCont.getPrevInstrContainer();
                                }
                                if (e.isBefore()) {
                                    this.insertI2SBefore(tempCont);
                                }
                                this.insertI2SAfter(tempCont);
                            }
                        }
                        this.checkForcedTypeAndPromote(cur_instr_container);
                        this.propagateInfo(cur_instr_container);
                        this.setSourceLineNumber(cur_instr_container);
                        this.setJcInstrLabel(cur_instr_container);
                        cur_instr_container.setChangedFlag(false);
                        cur_instr_container.setVisited(true);
                    }
                    cur_instr_container = cur_instr_container.getNextInstrContainer();
                }
                catch (RollBackException e) {
                    InstrContainer tempC = cur_instr_container;
                    cur_instr_container = e.getRollBackPoint();
                    if (!e.isCastDownI2S()) {
                        int j_index;
                        InstructionConverter instr_converter;
                        cur_instr_container.setForcedType(3);
                        cur_instr_container.setChangedFlag(true);
                        if (this.local_var_converter.getDefinedLocalVariablesSize() != 0 || !((instr_converter = InstructionConverter.create(cur_instr_container, this)) instanceof InstrLoadConverter) || this.local_var_converter.getJcLocalVariable(j_index = ((InstrLoadConverter)instr_converter).getJavaLocalIndex()).isVarTypeKnown() || this.local_var_converter.getJcLocalVariable(j_index).isPromoted()) continue;
                        this.local_var_converter.updateJcLocalVariable(j_index, "I");
                        this.local_var_converter.getJcLocalVariable(j_index).setPromoted(true);
                        this.local_var_converter.recomputeUndefIndexes(j_index);
                        cur_instr_container = this.setAllToChangedAndRestart(cur_instr_container);
                        cur_instr_container.setChangedFlag(true);
                        continue;
                    }
                    this.insertI2SAfter(cur_instr_container);
                    cur_instr_container.setChangedFlag(true);
                    cur_instr_container = this.setAllToChangedAndReset(tempC, cur_instr_container);
                }
                catch (RecalculateIndexException e) {
                    cur_instr_container.setChangedFlag(true);
                    this.local_var_converter.recomputeUndefIndexes(e.getIndex());
                    cur_instr_container = this.setAllToChangedAndRestart(cur_instr_container);
                }
            }
        }
        JcInstruction first_jc_instr = this.linkJcInstructions();
        this.jc_method.setCode(first_jc_instr);
        this.setNargs();
        this.setMaxLocals();
        this.setMaxStack();
        return this.jc_method;
    }

    private InstrContainer setAllToChangedAndRestart(InstrContainer cur_instr_container) {
        InstrContainer temp = cur_instr_container;
        while (cur_instr_container.getPrevInstrContainer() != null) {
            if (cur_instr_container.isVisited()) {
                cur_instr_container.setChangedFlag(true);
            }
            cur_instr_container = cur_instr_container.getPrevInstrContainer();
        }
        if (cur_instr_container.isVisited()) {
            cur_instr_container.setChangedFlag(true);
        }
        while (temp.getNextInstrContainer() != null) {
            if (temp.isVisited()) {
                temp.setChangedFlag(true);
            }
            temp = temp.getNextInstrContainer();
        }
        if (temp.isVisited()) {
            temp.setChangedFlag(true);
        }
        return cur_instr_container;
    }

    private InstrContainer setAllToChangedAndReset(InstrContainer cur_instr_container, InstrContainer rollback_cont) {
        InstrContainer temp = cur_instr_container;
        temp.setChangedFlag(true);
        temp.resetStack();
        while (cur_instr_container.getPrevInstrContainer() != null && cur_instr_container != rollback_cont) {
            if (cur_instr_container.isVisited()) {
                cur_instr_container.setChangedFlag(true);
                cur_instr_container.resetStack();
            }
            cur_instr_container = cur_instr_container.getPrevInstrContainer();
        }
        if (cur_instr_container.isVisited()) {
            cur_instr_container.setChangedFlag(true);
            cur_instr_container.resetWorkingStack();
        }
        while (temp.getNextInstrContainer() != null) {
            if (temp.isVisited()) {
                temp.setChangedFlag(true);
                temp.resetStack();
            }
            if (temp == rollback_cont) break;
            temp = temp.getNextInstrContainer();
        }
        if (temp.isVisited()) {
            temp.setChangedFlag(true);
            temp.resetStack();
        }
        return cur_instr_container;
    }

    private void constructInstrContainers(JInstruction code) {
        InstrContainer cur_instr_container = this.instr_containers = new InstrContainer(code);
        while (code.getNextInstr() != null) {
            code = code.getNextInstr();
            InstrContainer instr_container = new InstrContainer(code);
            cur_instr_container.setNextInstrContainer(instr_container);
            instr_container.setPrevInstrContainer(cur_instr_container);
            cur_instr_container = instr_container;
        }
    }

    private void constructControlFlowGraph() {
        this.instr_containers.setLabelFlag(true);
        this.instr_containers.setControlFlowLabelFlag(true);
        this.linkExceptions();
        for (InstrContainer instr_container = this.instr_containers; instr_container != null; instr_container = instr_container.getNextInstrContainer()) {
            InstrContainer next_instr_container;
            JInstruction java_instr = instr_container.getJInstr();
            if (java_instr instanceof JInstrShortBranch) {
                this.linkShortBranchInstr(instr_container);
                continue;
            }
            if (java_instr instanceof JInstrIntBranch) {
                this.linkIntBranchInstr(instr_container);
                continue;
            }
            if (java_instr instanceof JInstrTableSwitch || java_instr instanceof JInstrLookupSwitch) {
                this.linkSwitchInstr(instr_container);
                continue;
            }
            if (this.isUnconditionalBranch(java_instr)) {
                next_instr_container = instr_container.getNextInstrContainer();
                if (next_instr_container == null) continue;
                next_instr_container.setLabelFlag(true);
                next_instr_container.setControlFlowLabelFlag(true);
                continue;
            }
            next_instr_container = instr_container.getNextInstrContainer();
            if (next_instr_container == null) continue;
            instr_container.link(next_instr_container);
        }
        this.linkRetInstructions();
        if (this.p_converter.getConversionProfile().debug) {
            this.setLocalVarsScope();
        }
        this.setContainerLabels();
        if (this.p_converter.getConversionProfile().debug) {
            this.setLocalVarsLabels();
        }
    }

    private void setLocalVarsScope() {
        JcLocalVariable[] arr$ = this.jc_locals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (JcLocalVariable jc_local = arr$[i$]; jc_local != null; jc_local = jc_local.getNext()) {
                this.setLocalVarScope(jc_local);
            }
        }
    }

    private void setLocalVarScope(JcLocalVariable jc_local) {
        JInstruction j_instr;
        InstrContainer cur_instr_container;
        int j_start_pc = jc_local.getJStartPC();
        int j_end_pc = j_start_pc + jc_local.getJLength();
        for (cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            j_instr = cur_instr_container.getJInstr();
            if (j_start_pc != j_instr.getPC()) continue;
            cur_instr_container.setLabelFlag(true);
            break;
        }
        for (cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            j_instr = cur_instr_container.getJInstr();
            if (j_end_pc != j_instr.getPC()) continue;
            cur_instr_container.setLabelFlag(true);
            break;
        }
    }

    private void setLocalVarsLabels() {
        JcLocalVariable[] arr$ = this.jc_locals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (JcLocalVariable jc_local = arr$[i$]; jc_local != null; jc_local = jc_local.getNext()) {
                this.setLocalVarLabel(jc_local);
            }
        }
    }

    private void setLocalVarLabel(JcLocalVariable jc_local) {
        JInstruction j_instr;
        InstrContainer cur_instr_container;
        int j_start_pc = jc_local.getJStartPC();
        int j_end_pc = j_start_pc + jc_local.getJLength();
        int start_label = -1;
        int end_label = -1;
        for (cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            j_instr = cur_instr_container.getJInstr();
            if (j_start_pc != j_instr.getPC()) continue;
            start_label = cur_instr_container.getLabel();
            break;
        }
        for (cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            j_instr = cur_instr_container.getJInstr();
            if (j_end_pc != j_instr.getPC()) continue;
            end_label = cur_instr_container.getLabel();
            break;
        }
        jc_local.setJcStartPCLabel(start_label);
        jc_local.setJcEndPCLabel(end_label);
    }

    private void linkShortBranchInstr(InstrContainer cur_instr_container) {
        JInstruction cur_java_instr = cur_instr_container.getJInstr();
        int branch_offset = ((JInstrShortBranch)cur_java_instr).getBranchOffset();
        InstrContainer target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), branch_offset);
        target_instr_container.setLabelFlag(true);
        target_instr_container.setControlFlowLabelFlag(true);
        cur_instr_container.link(target_instr_container);
        InstrContainer next_instr_container = cur_instr_container.getNextInstrContainer();
        if (next_instr_container != null) {
            next_instr_container.setLabelFlag(true);
            next_instr_container.setControlFlowLabelFlag(true);
            if (!this.isUnconditionalBranch(cur_java_instr)) {
                cur_instr_container.link(next_instr_container);
            }
            if (cur_java_instr.getOpcode() == 168) {
                cur_instr_container.link(next_instr_container);
            }
        }
    }

    private void linkIntBranchInstr(InstrContainer cur_instr_container) {
        JInstruction cur_java_instr = cur_instr_container.getJInstr();
        int branch_offset = ((JInstrIntBranch)cur_java_instr).getBranchOffset();
        InstrContainer target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), branch_offset);
        target_instr_container.setLabelFlag(true);
        target_instr_container.setControlFlowLabelFlag(true);
        cur_instr_container.link(target_instr_container);
        InstrContainer next_instr_container = cur_instr_container.getNextInstrContainer();
        if (next_instr_container != null) {
            next_instr_container.setLabelFlag(true);
            next_instr_container.setControlFlowLabelFlag(true);
            cur_instr_container.link(next_instr_container);
        }
    }

    private void linkSwitchInstr(InstrContainer cur_instr_container) {
        JInstruction cur_java_instr;
        InstrContainer next_instr_container = cur_instr_container.getNextInstrContainer();
        if (next_instr_container != null) {
            next_instr_container.setLabelFlag(true);
            next_instr_container.setControlFlowLabelFlag(true);
        }
        int default_branch_offset = (cur_java_instr = cur_instr_container.getJInstr()) instanceof JInstrTableSwitch ? ((JInstrTableSwitch)cur_java_instr).getDefaultBranchOffset() : ((JInstrLookupSwitch)cur_java_instr).getDefaultBranchOffset();
        InstrContainer target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), default_branch_offset);
        if (target_instr_container != null) {
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            cur_instr_container.link(target_instr_container);
        }
        int[] branch_offsets = cur_java_instr instanceof JInstrTableSwitch ? ((JInstrTableSwitch)cur_java_instr).getBranchOffsets() : ((JInstrLookupSwitch)cur_java_instr).getMatchOffsets();
        for (int element : branch_offsets) {
            target_instr_container = this.findTargetInstrContainer(cur_java_instr.getPC(), element);
            if (target_instr_container == null) continue;
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            cur_instr_container.link(target_instr_container);
        }
    }

    private void linkRetInstructions() {
        for (InstrContainer cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            InstrContainer next_jsr_instr_container;
            JInstruction cur_java_instr = cur_instr_container.getJInstr();
            if (cur_java_instr.getOpcode() != 168) continue;
            InstrContainer ret_instr_container = cur_instr_container.findRetInstrContainer();
            if (ret_instr_container == null) {
                // empty if block
            }
            if ((next_jsr_instr_container = cur_instr_container.getNextInstrContainer()) == null) {
                throw new ConverterInternalError();
            }
            if (ret_instr_container == null) continue;
            ret_instr_container.link(next_jsr_instr_container);
        }
    }

    private void linkExceptions() {
        JExceptionRecord[] exceptions;
        JCodeAttr code_attr = this.java_method.getCodeAttr();
        for (JExceptionRecord element : exceptions = code_attr.getExceptions()) {
            int start_pc = element.getStartPc();
            InstrContainer target_instr_container = this.findTargetInstrContainer(0, start_pc);
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            int end_pc = element.getEndPc();
            target_instr_container = this.findTargetInstrContainer(0, end_pc);
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            int handler_pc = element.getHandlerPc();
            target_instr_container = this.findTargetInstrContainer(0, handler_pc);
            target_instr_container.setLabelFlag(true);
            target_instr_container.setControlFlowLabelFlag(true);
            target_instr_container.setCatchFinallyBlockLeader(true);
        }
    }

    private void setContainerLabels() {
        int block_num = 0;
        for (InstrContainer cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            if (!cur_instr_container.hasLabel()) continue;
            cur_instr_container.setLabel(block_num);
            ++block_num;
        }
    }

    private InstrContainer findTargetInstrContainer(int branch_offset, int brand_distance) {
        int target_pc = branch_offset + brand_distance;
        for (InstrContainer cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            if (cur_instr_container.getJInstr().getPC() != target_pc) continue;
            return cur_instr_container;
        }
        throw new ConverterInternalError();
    }

    private JcException[] constructExceptions() {
        ExceptionTableConverter exp_converter = new ExceptionTableConverter(this);
        return exp_converter.convert();
    }

    private JcLocalVariable[] computeLocals() throws Exception {
        this.local_var_converter = LocalVariableConverter.createIt(this);
        return this.local_var_converter.convert();
    }

    public LocalVariableConverter getLocalVariableConverter() {
        return this.local_var_converter;
    }

    public void setMaxLocals() {
        JCodeAttr code_attr;
        this.max_locals = !this.isIntSupported() ? ((code_attr = this.java_method.getCodeAttr()) == null ? 0 : code_attr.getMaxLocals()) : this.local_var_converter.getDefinedLocalVariablesSize() + this.local_var_converter.getUndefinedLocalVariablesSize();
        if (this.max_locals != 0) {
            this.max_locals -= this.nargs;
        }
        this.jc_method.setMaxLocals(this.max_locals);
    }

    private void setNargs() {
        String descriptor = this.jc_method.getMethodDescriptor();
        this.nargs = MethodDescriptor.getParamSize(descriptor);
        int access_flags = this.jc_method.getAccessFlags();
        if (!Modifier.isStatic(access_flags)) {
            ++this.nargs;
        }
        this.jc_method.setNargs(this.nargs);
    }

    private void setMaxStack() throws Exception {
        int max_stack = 0;
        for (InstrContainer cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            OperandStack operand_stack = cur_instr_container.getOperandStack();
            if (operand_stack == null || max_stack >= operand_stack.getMaxStackSize()) continue;
            max_stack = operand_stack.getMaxStackSize();
        }
        if (max_stack > 255) {
            Object[] args = new String[]{this.getMethodName(), this.getClassName().replace('/', '.')};
            Notifier.error("subset.56", args);
            throw new ConversionException();
        }
        this.jc_method.setMaxStack(max_stack);
    }

    private boolean isUnconditionalBranch(JInstruction java_instr) {
        int opcode = java_instr.getOpcode();
        switch (opcode) {
            case 167: 
            case 168: 
            case 169: 
            case 172: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    private void checkForcedTypeAndPromote(InstrContainer instr_container) {
        if (instr_container.getForcedType() != 3) {
            return;
        }
        OperandStack operand_stack = instr_container.getOperandStack();
        OperandStackEntry value_entry = operand_stack.peek(1);
        if (value_entry.getType() == 3) {
            return;
        }
        JcInstruction jc_instr = instr_container.getJcInstr();
        if (jc_instr == null) {
            if (value_entry.getType() == 2 || value_entry.getType() == 1) {
                JcInstrNoOperands promote_instr = new JcInstrNoOperands(92);
                instr_container.setJcInstr(promote_instr);
                operand_stack.promote(1);
                return;
            }
            throw new ConverterInternalError();
        }
        switch (jc_instr.getOpcode()) {
            case 2: {
                jc_instr.setOpcode(9);
                break;
            }
            case 3: {
                jc_instr.setOpcode(10);
                break;
            }
            case 4: {
                jc_instr.setOpcode(11);
                break;
            }
            case 5: {
                jc_instr.setOpcode(12);
                break;
            }
            case 6: {
                jc_instr.setOpcode(13);
                break;
            }
            case 7: {
                jc_instr.setOpcode(14);
                break;
            }
            case 8: {
                jc_instr.setOpcode(15);
                break;
            }
            case 16: {
                jc_instr.setOpcode(18);
                break;
            }
            case 17: {
                jc_instr.setOpcode(19);
                break;
            }
            default: {
                JcInstrNoOperands promote_instr = new JcInstrNoOperands(92);
                if (jc_instr == null) {
                    jc_instr = promote_instr;
                    instr_container.setJcInstr(jc_instr);
                    break;
                }
                jc_instr.setNextInstr(promote_instr);
                promote_instr.setPrevInstr(jc_instr);
            }
        }
        operand_stack.promote(1);
    }

    private void propagateInfo(InstrContainer cur_instr_container) {
        InstrContainer[] out_instr_containers = cur_instr_container.getOutInstrContainers();
        OperandStack operand_stack = cur_instr_container.getOperandStack();
        for (InstrContainer element : out_instr_containers) {
            if (element.isCatchFinallyBlockLeader()) continue;
            try {
                if (cur_instr_container.getJInstr().getOpcode() == 168 && cur_instr_container.getNextInstrContainer().getJInstr().getPC() == element.getJInstr().getPC() && out_instr_containers.length > 1) {
                    OperandStack clone = (OperandStack)operand_stack.clone();
                    clone.pop();
                    element.setOperandStack(clone);
                    continue;
                }
                element.setOperandStack((OperandStack)operand_stack.clone());
            }
            catch (RollBackException e) {
                InstrContainer prev = element.getPrevInstrContainer();
                int pc_curr = cur_instr_container.getJInstr().getPC();
                int pc_roll = e.getRollBackPoint().getJInstr().getPC();
                int pc_prev = prev.getJInstr().getPC();
                if (prev != null && pc_curr != pc_roll && pc_curr != pc_prev) {
                    prev.setForcedType(3);
                    prev.setChangedFlag(true);
                }
                throw e;
            }
        }
    }

    private void setSourceLineNumber(InstrContainer instr_container) {
        int line_num = instr_container.getJInstr().getSourceLineNumber();
        for (JcInstruction jc_instr = instr_container.getJcInstr(); jc_instr != null; jc_instr = jc_instr.getNextInstr()) {
            jc_instr.setSourceLineNumber(line_num);
        }
    }

    private void setJcInstrLabel(InstrContainer instr_container) {
        int block_num = instr_container.getLabel();
        if (block_num == -1) {
            return;
        }
        JcInstruction jc_instr = instr_container.getJcInstr();
        if (jc_instr != null) {
            jc_instr.setLabel(block_num);
        }
    }

    private JcInstruction linkJcInstructions() {
        JcInstruction first_jc_instr = null;
        JcInstruction cur_jc_instr = null;
        for (InstrContainer cur_instr_container = this.instr_containers; cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            JcInstruction jc_instr = cur_instr_container.getJcInstr();
            if (jc_instr == null) continue;
            if (!cur_instr_container.hasLabel()) {
                InstrContainer prev_instr_container = cur_instr_container.getPrevInstrContainer();
                while (prev_instr_container.getJcInstr() == null) {
                    if (prev_instr_container.hasLabel()) {
                        jc_instr.setLabel(prev_instr_container.getLabel());
                        break;
                    }
                    prev_instr_container = prev_instr_container.getPrevInstrContainer();
                }
            }
            if (first_jc_instr == null) {
                first_jc_instr = jc_instr;
                cur_jc_instr = jc_instr;
            } else {
                cur_jc_instr.setNextInstr(jc_instr);
                jc_instr.setPrevInstr(cur_jc_instr);
            }
            cur_jc_instr = jc_instr;
            while (cur_jc_instr.getNextInstr() != null) {
                cur_jc_instr = cur_jc_instr.getNextInstr();
            }
        }
        return first_jc_instr;
    }

    private void checkMethodSignature() throws Exception {
        Vector<String> classes = this.getClassesFromSignature();
        JPackage jp = this.getPackageConverter().getJavaPackage();
        for (int i = 0; i < classes.size(); ++i) {
            String clName = classes.elementAt(i).toString();
            JClassFile jc = jp.getClass(clName);
            if (jc == null || jc.isPublic()) continue;
            Object[] args = new String[]{this.getMethodName(), this.getClassName().replace('/', '.'), clName.replace('/', '.')};
            Notifier.error("subset.55", args);
            throw new ConversionException();
        }
    }

    private Vector<String> getClassesFromSignature() {
        int l;
        Vector<String> res = new Vector<String>();
        String sig = this.getMethodDescriptor();
        while ((l = sig.indexOf(76)) != -1) {
            int semicolon = sig.indexOf(59, l);
            if (l == -1) break;
            String className = sig.substring(l + 1, semicolon);
            sig = sig.substring(semicolon + 1);
            res.add(className);
        }
        return res;
    }

    private void insertI2SBefore(InstrContainer curr_container) {
        InstrContainer prev_container = curr_container.getPrevInstrContainer();
        JInstrNoOperands ji = new JInstrNoOperands(null, 0, 147);
        InstrContainer i2s_container = new InstrContainer(ji);
        JcInstrNoOperands jc_i2s = new JcInstrNoOperands(94);
        i2s_container.setJcInstr(jc_i2s);
        i2s_container.setNextInstrContainer(curr_container);
        i2s_container.setPrevInstrContainer(prev_container);
        prev_container.setNextInstrContainer(i2s_container);
        curr_container.setPrevInstrContainer(i2s_container);
        prev_container.relink(curr_container, i2s_container);
        i2s_container.link(curr_container);
    }

    private void insertI2SAfter(InstrContainer curr_container) {
        InstrContainer next_container = curr_container.getNextInstrContainer();
        JInstrNoOperands ji = new JInstrNoOperands(null, 0, 147);
        InstrContainer i2s_container = new InstrContainer(ji);
        i2s_container.setInserted(true);
        JcInstrNoOperands jc_i2s = new JcInstrNoOperands(94);
        i2s_container.setJcInstr(jc_i2s);
        i2s_container.setNextInstrContainer(next_container);
        i2s_container.setPrevInstrContainer(curr_container);
        next_container.setPrevInstrContainer(i2s_container);
        curr_container.setNextInstrContainer(i2s_container);
        curr_container.relink(next_container, i2s_container);
        i2s_container.link(next_container);
    }
}

