/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.StringUtils;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.ValidValues;
import com.sun.javacard.validator.XMLNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

public class JavaCardXML
extends PackageItem {
    public static final String XSD_NAME = "javacard-app_3_0.xsd";
    private String version;
    private Vector<String> dynamicallyLoadedClasses = new Vector();
    private Vector<String> shareableInterfaceClasses = new Vector();
    private Vector<String> userRoles = new Vector();
    private Vector<String> oncardClientRoles = new Vector();
    private Vector<String> cardHolderAutherizationRoles = new Vector();
    private File file;
    private XMLNode xmlNode;

    public JavaCardXML(File file) {
        this.file = file;
    }

    @Override
    public String getItemDisplayName() {
        String str = "";
        if (this.getParent() != null) {
            str = this.getParent().getItemDisplayName() + "/";
        }
        str = str + "javacard.xml";
        return str;
    }

    public void saveCanonicalizedTo(File dest) throws Exception {
        String str = this.xmlNode.toString();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest);
            fos.write(str.getBytes());
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void initialize() {
        ArrayList<XMLNode> srNodes;
        XMLNode chaNode;
        XMLNode sicNode;
        XMLNode dlcNode;
        this.xmlNode = null;
        try {
            this.xmlNode = new XMLNode(this, this.file, XSD_NAME, "http://java.sun.com/xml/ns/javacard");
        }
        catch (Exception e) {
            this.addError(ErrorKey.XMLParsingError, this.file.getName(), e.getMessage());
            return;
        }
        this.version = this.xmlNode.getAttribute("version");
        if (!"3.0".equals(this.version)) {
            this.addError(ErrorKey.InvalidVersion, this.version);
        }
        if ((dlcNode = this.xmlNode.getChildNode("dynamically-loaded-classes")) != null) {
            this.gatherDynamicallyLoadedClassNames(dlcNode);
        }
        if ((sicNode = this.xmlNode.getChildNode("shareable-interface-classes")) != null) {
            this.gatherShareableInterfaceClassNames(sicNode);
        }
        if ((chaNode = this.xmlNode.getChildNode("card-holder-authorization")) != null) {
            this.gatherCardHolderAutherizationRoles(chaNode);
        }
        if ((srNodes = this.xmlNode.getChildNodes("security-role")) != null) {
            for (XMLNode srNode : srNodes) {
                this.gatherSecurityRoles(srNode);
            }
        }
    }

    private void gatherSecurityRoles(XMLNode securityRoleNode) {
        ArrayList<XMLNode> roleNameNodesList = securityRoleNode.getChildNodes("role-name");
        String category = null;
        for (XMLNode roleNameNode : roleNameNodesList) {
            category = roleNameNode.getAttribute("category");
            if (category == null) {
                this.addError(ErrorKey.MissingRoleNameCategory, new Object[0]);
                continue;
            }
            if ("USER".equals(category)) {
                this.userRoles.addElement(roleNameNode.getTextValue());
                continue;
            }
            if ("ON-CARD-CLIENT".equals(category)) {
                this.oncardClientRoles.addElement(roleNameNode.getTextValue());
                continue;
            }
            this.addError(ErrorKey.UnknownRoleNameCategory, category);
        }
    }

    private void gatherCardHolderAutherizationRoles(XMLNode cardHolderAutherizationNode) {
        ArrayList<XMLNode> roleNameNodesList = cardHolderAutherizationNode.getChildNodes("role-name");
        for (XMLNode roleNameNode : roleNameNodesList) {
            this.cardHolderAutherizationRoles.addElement(roleNameNode.getTextValue());
        }
    }

    private void gatherShareableInterfaceClassNames(XMLNode shareableInterfaceClassNode) {
        ArrayList<XMLNode> classNodesList = shareableInterfaceClassNode.getChildNodes("class");
        for (XMLNode classNode : classNodesList) {
            this.shareableInterfaceClasses.addElement(classNode.getAttribute("name"));
        }
    }

    private void gatherDynamicallyLoadedClassNames(XMLNode dynamicallyLoadedClassNode) {
        ArrayList<XMLNode> classNodesList = dynamicallyLoadedClassNode.getChildNodes("class");
        for (XMLNode classNode : classNodesList) {
            this.dynamicallyLoadedClasses.addElement(classNode.getAttribute("name"));
        }
    }

    @Override
    public void processInternal() {
        Module module = (Module)this.getParent();
        for (String name : this.dynamicallyLoadedClasses) {
            if (!StringUtils.isValidClassName(name)) {
                this.addError(ErrorKey.IllegalClassName, name, "dynamically-loaded-classes");
                continue;
            }
            if (module.hasClass(name)) continue;
            this.addWarning(ErrorKey.DeclaredClassDoesNotExists, name, "dynamically-loaded-classes");
        }
        for (String name : this.shareableInterfaceClasses) {
            if (!StringUtils.isValidClassName(name)) {
                this.addError(ErrorKey.IllegalClassName, name, "shareable-interface-class");
                continue;
            }
            if (module.hasClass(name)) {
                try {
                    if (!module.isInterface(name)) {
                        this.addError(ErrorKey.DeclaredClassIsNotInterface, name, "shareable-interface-class");
                        continue;
                    }
                    if (!module.isShareableInterface(name)) {
                        this.addError(ErrorKey.DeclaredClassIsNotShareableInterface, name, "shareable-interface-class");
                        continue;
                    }
                    if (module.isPublic(name)) continue;
                    this.addWarning(ErrorKey.DeclaredClassIsNotPublic, name, "shareable-interface-class");
                }
                catch (Exception e) {}
                continue;
            }
            this.addWarning(ErrorKey.DeclaredClassDoesNotExists, name, "shareable-interface-class");
        }
        for (String roleName : this.oncardClientRoles) {
            if (ValidValues.isValidNNMToken(roleName)) continue;
            this.addError(ErrorKey.RoleNameNotNMTOKEN, roleName);
        }
        for (String roleName : this.userRoles) {
            if (ValidValues.isValidNNMToken(roleName)) continue;
            this.addError(ErrorKey.RoleNameNotNMTOKEN, roleName);
        }
        for (String roleName : this.cardHolderAutherizationRoles) {
            if (this.userRoles.contains(roleName)) continue;
            this.addError(ErrorKey.InvalidRoleNameInCHA, roleName);
        }
        ModuleJCRD jcrd = module.getJCRD();
        Vector<String> jcrdClientRoleList = jcrd.getOncardClientRoleList();
        Vector<String> jcrdRserRoleList = jcrd.getUserRoleList();
        for (String roleName : this.oncardClientRoles) {
            if (jcrdClientRoleList.contains(roleName)) continue;
            this.addError(ErrorKey.ClientRoleNotInJCRD, roleName);
        }
        for (String roleName : this.userRoles) {
            if (jcrdRserRoleList.contains(roleName)) continue;
            this.addError(ErrorKey.UserRoleNotInJCRD, roleName);
        }
        this.checkProxies();
    }

    public Vector<String> getOncardClientRoles() {
        return this.oncardClientRoles;
    }

    public Vector<String> getUserRoles() {
        return this.userRoles;
    }

    void checkProxies() {
        Module module = (Module)this.getParent();
        String packageName = null;
        if (module instanceof ClassicModule) {
            packageName = ((ClassicModule)module).getAppletXML().getPackageName();
        }
        if (packageName != null) {
            String proxyPkgName = packageName + ".proxy";
            Vector<String> proxyClassNames = module.getClasses().getNamesOfClassesInPackage(proxyPkgName);
            for (String fullyQualifiedName : proxyClassNames) {
                int index;
                String name = fullyQualifiedName.substring(index = fullyQualifiedName.lastIndexOf(".") + 1);
                if (!name.startsWith("Proxy") || this.dynamicallyLoadedClasses.contains(fullyQualifiedName)) continue;
                this.addError(ErrorKey.proxyClassNotListedAsDLC, fullyQualifiedName);
            }
        }
    }
}

