/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import java.util.Vector;

class DebugComponent
extends Safeptr {
    private static final int DB_ACC_PUBLIC = 1;
    private static final int DB_ACC_PRIVATE = 2;
    private static final int DB_ACC_PROTECTED = 4;
    private static final int DB_ACC_STATIC = 8;
    private static final int DB_ACC_FINAL = 16;
    private static final int DB_ACC_NATIVE = 256;
    private static final int DB_ACC_REMOTE = 32;
    private static final int DB_ACC_INTERFACE = 512;
    private static final int DB_ACC_ABSTRACT = 1024;
    private static final int DB_ACC_SHAREABLE = 2048;
    private static final String BYTE_ARRAY_DESCRIPTOR = "[B";
    private static final String BOOLEAN_ARRAY_DESCRIPTOR = "[Z";
    private static final String SHORT_ARRAY_DESCRIPTOR = "[S";
    private static final String INTEGER_ARRAY_DESCRIPTOR = "[I";
    static final int STRING_TABLE_OFFSET = 2;
    String[] strTable;
    EfClass exportedClass;
    int pkgNameIndexOffset;
    int classCountOffset;
    int classOffset;

    DebugComponent(byte[] data) {
        super(data, "Debug");
    }

    int getStringCount() {
        return this.u2(0);
    }

    int getClassCount() {
        return this.u2(this.classCountOffset);
    }

    String getStringAt(int index) {
        if (index >= this.getStringCount()) {
            throw new VerifierError("DebugComponent.2");
        }
        return this.strTable[index];
    }

    void readDebugComponent() {
        int strOffset = 2;
        this.strTable = new String[this.getStringCount()];
        for (int i = 0; i < this.getStringCount(); ++i) {
            String str;
            int strLen = this.u2(strOffset);
            Safeptr strBytes = this.offset(strOffset += 2);
            this.strTable[i] = str = ClassInfo.getStringFromBytes(strLen, strBytes);
            strOffset += strLen;
        }
        this.pkgNameIndexOffset = strOffset;
        this.classCountOffset = this.pkgNameIndexOffset + 2;
        this.classOffset = this.classCountOffset + 2;
    }

    void verify() throws VerifierError {
        this.readDebugComponent();
        String pkgName = this.getStringAt(this.u2(this.pkgNameIndexOffset));
        if (Cap.Header.hasName && !pkgName.equals(Cap.Header.getPackageName())) {
            throw new VerifierError("DebugComponent.1");
        }
        int classCount = this.getClassCount();
        if (classCount != Cap.Descriptor.classCount()) {
            throw new VerifierError("DebugComponent.3");
        }
        for (int i = 0; i < classCount; ++i) {
            ClassDebugInfo cdi = new ClassDebugInfo(this.offset(this.classOffset));
            cdi.verify();
            this.classOffset += cdi.getClassDebugInfoSize();
        }
        if (!this.offset(this.classOffset).atComponentEnd()) {
            throw new VerifierError("DebugComponent.4");
        }
    }

    class ClassDebugInfo
    extends Safeptr {
        private static final int NAME_INDEX_OFFSET = 0;
        private static final int ACCESS_FLAG_OFFSET = 2;
        private static final int LOCATION_OFFSET = 4;
        private static final int SUPER_CLASS_NAME_INDEX_OFFSET = 6;
        private static final int SOURCE_FILE_INDEX_OFFSET = 8;
        private static final int INTERFACE_COUNT_OFFSET = 10;
        private static final int FIELD_COUNT_OFFSET = 11;
        private static final int METHOD_COUNT_OFFSET = 13;
        private static final int validClassFlags = 3633;
        int classDebugInfoSize;
        int infoOffset;
        private ClassDescriptor cdesc;
        private String className;

        ClassDebugInfo(Safeptr p) {
            super(p);
            this.classDebugInfoSize = 0;
            this.infoOffset = 15;
        }

        void verify() {
            String srcFileName;
            String superClassName;
            ClassInfo cinfo;
            DebugComponent.this.exportedClass = null;
            Vector<EfField> exportedFileds = null;
            this.className = DebugComponent.this.getStringAt(this.u2(0));
            if (!EfNames.validClassName(this.className)) {
                throw new VerifierError("DebugComponent.5", this.className);
            }
            int classAccFlags = this.u2(2);
            if ((classAccFlags & 0xFFFFF1CE) != 0) {
                throw new VerifierError("DebugComponent.6", this.className);
            }
            int classLoc = this.u2(4);
            try {
                cinfo = Cap.Class.infoOfs(classLoc);
            }
            catch (VerifierError e) {
                throw new VerifierError("DebugComponent.47", this.className);
            }
            int cinfoFlags = cinfo.flags();
            if ((classAccFlags & 0x800) == 0 ^ (cinfoFlags & 4) == 0) {
                throw new VerifierError("DebugComponent.7", this.className);
            }
            if ((classAccFlags & 0x20) == 0 ^ (cinfoFlags & 2) == 0) {
                throw new VerifierError("DebugComponent.8", this.className);
            }
            if ((classAccFlags & 0x200) == 0 ^ (cinfoFlags & 8) == 0) {
                throw new VerifierError("DebugComponent.9", this.className);
            }
            boolean descriptorFound = false;
            this.cdesc = Cap.Descriptor.firstClassDescriptor();
            for (int i = 0; i < Cap.Descriptor.classCount(); ++i) {
                if (this.cdesc.thisClass() == classLoc) {
                    if ((classAccFlags & 0x400) == 0 ^ (this.cdesc.flags() & 0x80) == 0) {
                        throw new VerifierError("DebugComponent.49", this.className);
                    }
                    if ((classAccFlags & 1) != (this.cdesc.flags() & 1)) {
                        throw new VerifierError("DebugComponent.10", this.className);
                    }
                    if ((classAccFlags & 0x10) != (this.cdesc.flags() & 0x10)) {
                        throw new VerifierError("DebugComponent.11", this.className);
                    }
                    descriptorFound = true;
                    break;
                }
                this.cdesc.next();
            }
            if (!descriptorFound) {
                throw new VerifierError("DebugComponent.12", this.className);
            }
            DebugComponent.this.exportedClass = this.getExportedClass(classLoc, cinfoFlags);
            if (DebugComponent.this.exportedClass != null) {
                DebugComponent.this.exportedClass = Classref.toExportClass(classLoc);
                String exportedClassName = DebugComponent.this.exportedClass.thisName();
                if (!DebugComponent.this.exportedClass.thisName().equals(this.className)) {
                    throw new VerifierError("DebugComponent.48", (Object)this.className, (Object)exportedClassName);
                }
            }
            if (!EfNames.validClassName(superClassName = DebugComponent.this.getStringAt(this.u2(6)))) {
                throw new VerifierError("DebugComponent.13", (Object)superClassName, (Object)this.className);
            }
            if (superClassName.equals(this.className)) {
                throw new VerifierError("DebugComponent.50", this.className);
            }
            if ((cinfoFlags & 8) == 0) {
                EfClass exportedSuperClass;
                int superClass = cinfo.superclass();
                int superClassFlags = 0;
                if (!Classref.isExternal(superClass)) {
                    superClassFlags = Cap.Class.infoOfs(superClass).flags();
                }
                if ((exportedSuperClass = this.getExportedClass(superClass, superClassFlags)) != null && !superClassName.equals(exportedSuperClass.thisName())) {
                    throw new VerifierError("DebugComponent.62", this.className);
                }
            }
            if (!EfNames.validSrcFileName(srcFileName = DebugComponent.this.getStringAt(this.u2(8)))) {
                throw new VerifierError("DebugComponent.14", (Object)srcFileName, (Object)this.className);
            }
            int interfaceCount = this.u1(10);
            if ((cinfoFlags & 8) != 0 ? interfaceCount != cinfo.interfaceCount() : interfaceCount != this.getTotalInterfaceCountForClass(cinfo)) {
                throw new VerifierError("DebugComponent.15", this.className);
            }
            for (int i = 0; i < interfaceCount; ++i) {
                String interfaceName = DebugComponent.this.getStringAt(this.u2(this.infoOffset));
                if (!EfNames.validClassName(interfaceName)) {
                    throw new VerifierError("DebugComponent.16", interfaceName);
                }
                this.infoOffset += 2;
            }
            int fieldCount = this.u2(11);
            if (fieldCount < this.cdesc.fieldCount()) {
                throw new VerifierError("DebugComponent.17", this.className);
            }
            if (DebugComponent.this.exportedClass != null) {
                exportedFileds = new Vector<EfField>(DebugComponent.this.exportedClass.fields.length);
                for (EfField element : DebugComponent.this.exportedClass.fields) {
                    exportedFileds.addElement(element);
                }
            }
            for (int i = 0; i < fieldCount; ++i) {
                EfField exportedField;
                FieldDebugInfo fdi = new FieldDebugInfo(this.offset(this.infoOffset));
                fdi.verify();
                this.infoOffset += 10;
                if (exportedFileds == null || (exportedField = DebugComponent.this.exportedClass.getFieldForName(fdi.getFieldName())) == null) continue;
                exportedFileds.removeElement(exportedField);
            }
            if (exportedFileds != null && exportedFileds.size() > 0) {
                throw new VerifierError("DebugComponent.17", ((EfField)exportedFileds.elementAt(0)).name());
            }
            int methodCount = this.u2(13);
            if ((cinfoFlags & 8) == 0) {
                int descMethodCount = this.cdesc.methodCount();
                if (methodCount != this.cdesc.methodCount()) {
                    throw new VerifierError("DebugComponent.18", this.className);
                }
            }
            for (int i = 0; i < methodCount; ++i) {
                MethodDebugInfo mdi = new MethodDebugInfo(this.offset(this.infoOffset));
                mdi.verify();
                this.infoOffset += mdi.getTotalMethodInfoSize();
            }
            this.classDebugInfoSize = this.infoOffset;
        }

        private int getTotalInterfaceCountForClass(ClassInfo cinfo) {
            Vector<Integer> implementedInterfaces = new Vector<Integer>();
            Vector<String> externalImplementedInterfaces = new Vector<String>();
            int superRef = cinfo.superclass();
            do {
                int count;
                if ((count = cinfo.interfaceCount()) > 0) {
                    ImplementedInterface intfc = cinfo.firstImplementedInterface();
                    do {
                        int interfaceImpl;
                        if (!Classref.isExternal(interfaceImpl = intfc.interfaceImpl())) {
                            if (!implementedInterfaces.contains(interfaceImpl)) {
                                implementedInterfaces.add(interfaceImpl);
                            }
                        } else {
                            EfClass ec = Classref.checkExternal(interfaceImpl);
                            String name = ec.thisName();
                            if (!externalImplementedInterfaces.contains(name)) {
                                externalImplementedInterfaces.add(name);
                            }
                        }
                        if (--count <= 0) continue;
                        intfc.next();
                    } while (count > 0);
                }
                if (superRef == 65535) continue;
                if (!Classref.isExternal(superRef)) {
                    cinfo = Cap.Class.infoOfs(superRef);
                    superRef = cinfo.superclass();
                    continue;
                }
                EfClass ec = Classref.checkExternal(superRef);
                this.getImplementedInterfacesForExternalSuperClass(externalImplementedInterfaces, ec);
                break;
            } while (superRef != 65535);
            return implementedInterfaces.size() + externalImplementedInterfaces.size();
        }

        private void getImplementedInterfacesForExternalSuperClass(Vector<String> interfaces, EfClass ec) {
            int i;
            for (i = 0; i < ec.interfaces.length; ++i) {
                String name = ec.interfaceName(i);
                if (interfaces.contains(name)) continue;
                interfaces.add(name);
            }
            for (i = 0; i < ec.supers.length; ++i) {
                String superName = ec.superName(i);
                EfClass superClass = Classref.exportclassForName(superName);
                this.getImplementedInterfacesForExternalSuperClass(interfaces, superClass);
            }
        }

        int getClassDebugInfoSize() {
            return this.classDebugInfoSize;
        }

        EfClass getExportedClass(int ref, int cinfoFlags) {
            if (Classref.isExternal(ref)) {
                return Classref.checkExternal(ref);
            }
            ClassDescriptor cdesc = Classref.checkInternal(ref);
            if (cdesc.token() == 255) {
                return null;
            }
            if ((cdesc.flags() & 1) == 1) {
                boolean isExported = false;
                if ((Cap.Header.flags() & 4) == 0) {
                    isExported = true;
                } else if ((cinfoFlags & 4) != 0 && (cinfoFlags & 8) != 0) {
                    isExported = true;
                }
                if (isExported) {
                    return Classref.toExportClass(ref);
                }
            }
            return null;
        }

        private class MethodDebugInfo
        extends Safeptr {
            private static final int METHOD_HEADER_SIZE = 2;
            private static final int EXTENDED_METHOD_HEADER_SIZE = 4;
            private static final int NAME_INDEX_OFFSET = 0;
            private static final int DESCRIPTOR_INDEX_OFFSET = 2;
            private static final int ACCESS_FLAG_OFFSET = 4;
            private static final int LOCATION_OFFSET = 6;
            private static final int HEADER_SIZE_OFFSET = 8;
            private static final int BODY_SIZE_OFFSET = 9;
            private static final int VARIABLE_COUNT_OFFSET = 11;
            private static final int LINE_COUNT_OFFSET = 13;
            private int infoOffset;
            private static final int validMethodFlags = 1311;
            int totalInfoSize;
            int methodBodySize;
            private MethodInfo methodInfo;
            private MethodDescriptor md;
            private String methodName;

            MethodDebugInfo(Safeptr p) {
                super(p);
                this.infoOffset = 15;
            }

            public void verify() {
                int i;
                int methodHeaderSize;
                int maxLocals = 0;
                EfMethod exportedMethod = null;
                this.methodName = DebugComponent.this.getStringAt(this.u2(0));
                if (!EfNames.validMethodName(this.methodName)) {
                    throw new VerifierError("DebugComponent.26", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                }
                String methodDesc = DebugComponent.this.getStringAt(this.u2(2));
                if (!EfNames.validMethodDescriptor(methodDesc)) {
                    throw new VerifierError("DebugComponent.27", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                }
                int methodFlags = this.u2(4);
                if ((methodFlags & 0xFFFFFAE0) != 0) {
                    throw new VerifierError("DebugComponent.28", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                }
                if ((methodFlags & 0x100) != 0) {
                    throw new VerifierError("DebugComponent.29", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                }
                int methodLocation = this.u2(6);
                if (methodLocation == 0) {
                    if ((methodFlags & 0x400) == 0) {
                        throw new VerifierError("DebugComponent.30", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    int flag_count = 0;
                    if ((methodFlags & 2) != 0) {
                        ++flag_count;
                    }
                    if ((methodFlags & 4) != 0) {
                        ++flag_count;
                    }
                    if ((methodFlags & 1) != 0) {
                        ++flag_count;
                    }
                    if (flag_count > 1) {
                        throw new VerifierError("DebugComponent.31", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                } else {
                    if ((methodFlags & 0x400) != 0) {
                        throw new VerifierError("DebugComponent.32", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    this.md = ClassDebugInfo.this.cdesc.getMethodDescriptorForLocation(methodLocation);
                    if (this.md == null) {
                        throw new VerifierError("DebugComponent.34", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    this.methodInfo = Cap.Method.methodInfo(methodLocation);
                    if ((methodFlags & 1) != (this.md.flags() & 1) || (methodFlags & 2) != (this.md.flags() & 2) || (methodFlags & 4) != (this.md.flags() & 4) || (methodFlags & 8) != (this.md.flags() & 8) || (methodFlags & 0x10) != (this.md.flags() & 0x10)) {
                        throw new VerifierError("DebugComponent.33", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    if (DebugComponent.this.exportedClass != null && ((this.md.flags() & 1) != 0 || (this.md.flags() & 4) != 0) && (methodFlags & 0x100) == 0) {
                        exportedMethod = DebugComponent.this.exportedClass.getMethodForNameAndSig(this.methodName, methodDesc);
                        if (exportedMethod == null) {
                            throw new VerifierError("DebugComponent.58", (Object)this.methodName, (Object)methodDesc, (Object)ClassDebugInfo.this.className);
                        }
                        MethodDescriptor mdFromToken = ClassDebugInfo.this.cdesc.getMethodDescriptorForToken(exportedMethod.token, (methodFlags & 8) != 0, this.methodName.equals("<init>"));
                        if (mdFromToken.methodOffset() != methodLocation) {
                            throw new VerifierError("DebugComponent.57", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                        }
                    }
                    if ((this.md.flags() & 0x40) != 0) {
                        throw new VerifierError("DebugComponent.33", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                }
                if ((methodHeaderSize = this.u1(8)) == 0) {
                    if ((methodFlags & 0x400) == 0) {
                        throw new VerifierError("DebugComponent.35", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                } else {
                    if ((methodFlags & 0x400) != 0) {
                        throw new VerifierError("DebugComponent.36", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    if ((this.methodInfo.flags() & 8) != 0) {
                        if (methodHeaderSize != 4) {
                            throw new VerifierError("DebugComponent.35", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                        }
                        maxLocals = this.methodInfo.maxLocalsExtended();
                    } else {
                        if (methodHeaderSize != 2) {
                            throw new VerifierError("DebugComponent.35", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                        }
                        maxLocals = this.methodInfo.maxLocalsCompact();
                    }
                }
                this.methodBodySize = this.u2(9);
                if (this.methodBodySize == 0) {
                    if ((methodFlags & 0x400) == 0) {
                        throw new VerifierError("DebugComponent.37", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                } else {
                    if ((methodFlags & 0x400) != 0) {
                        throw new VerifierError("DebugComponent.37", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    if (this.methodBodySize != this.md.bytecodeCount()) {
                        throw new VerifierError("DebugComponent.38", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                }
                int variableCount = this.u2(11);
                if ((methodFlags & 0x400) != 0 && variableCount > 0) {
                    throw new VerifierError("DebugComponent.39", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                }
                int maxStackRequiredForVars = 0;
                Vector<VariableInfo> variables = new Vector<VariableInfo>();
                for (i = 0; i < variableCount; ++i) {
                    VariableInfo vi = new VariableInfo(this.offset(this.infoOffset));
                    vi.verify();
                    variables.add(vi);
                    maxStackRequiredForVars = vi.getVariableDescriptor().equals("I") ? (maxStackRequiredForVars += 2) : ++maxStackRequiredForVars;
                    this.infoOffset += vi.getVarInfoSize();
                }
                if ((methodFlags & 0x400) == 0 && maxStackRequiredForVars < maxLocals) {
                    throw new VerifierError("DebugComponent.63", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                }
                for (i = 0; i < variables.size(); ++i) {
                    VariableInfo vi1 = (VariableInfo)variables.elementAt(i);
                    for (int j = 0; j < variables.size(); ++j) {
                        if (i == j) continue;
                        VariableInfo vi2 = (VariableInfo)variables.elementAt(j);
                        if (vi1.getVariableIndex() != vi2.getVariableIndex() || (vi1.getVariableScopeStart() > vi2.getVariableScopeStart() || vi1.getVariableScopeEnd() < vi2.getVariableScopeStart()) && (vi2.getVariableScopeStart() > vi1.getVariableScopeStart() || vi2.getVariableScopeEnd() < vi1.getVariableScopeStart())) continue;
                        throw new VerifierError("DebugComponent.61", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                }
                int lineCount = this.u2(13);
                if ((methodFlags & 0x400) != 0 && lineCount > 0) {
                    throw new VerifierError("DebugComponent.40", (Object)this.methodName, (Object)ClassDebugInfo.this.className);
                }
                for (int i2 = 0; i2 < lineCount; ++i2) {
                    LineInfo li = new LineInfo(this.offset(this.infoOffset));
                    li.verify();
                    this.infoOffset += li.getLineInfoSize();
                }
                this.totalInfoSize = this.infoOffset;
            }

            public int getTotalMethodInfoSize() {
                return this.totalInfoSize;
            }

            private class LineInfo
            extends Safeptr {
                private static final int LINE_START_PC_OFFSET = 0;
                private static final int LINE_END_PC_OFFSET = 2;
                private static final int SOURCE_LINE = 4;
                static final int lineInfoSize = 6;

                LineInfo(Safeptr p) {
                    super(p);
                }

                public void verify() {
                    int startPC = this.u2(0);
                    if (startPC >= MethodDebugInfo.this.methodBodySize) {
                        throw new VerifierError("DebugComponent.45", (Object)MethodDebugInfo.this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    int endPC = this.u2(2);
                    if (endPC >= MethodDebugInfo.this.methodBodySize || endPC < startPC) {
                        throw new VerifierError("DebugComponent.46", (Object)MethodDebugInfo.this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    int scLine = this.u2(4);
                }

                int getLineInfoSize() {
                    return 6;
                }
            }

            private class VariableInfo
            extends Safeptr {
                private static final int VAR_INDEX_OFFSET = 0;
                private static final int VAR_NAME_INDEX_OFFSET = 1;
                private static final int VAR_DESCRIPTOR_INDEX_OFFSET = 3;
                private static final int VAR_START_PC_OFFSET = 5;
                private static final int VAR_SCOPE_LENGTH_OFFSET = 7;
                static final int varInfoSize = 9;

                VariableInfo(Safeptr p) {
                    super(p);
                }

                int getVariableIndex() {
                    return this.u1(0);
                }

                int getVariableScopeStart() {
                    return this.u2(5);
                }

                int getVariableScopeEnd() {
                    return this.u2(5) + this.u2(7);
                }

                String getVariableDescriptor() {
                    return DebugComponent.this.getStringAt(this.u2(3));
                }

                public void verify() {
                    int index = this.u1(0);
                    String varName = DebugComponent.this.getStringAt(this.u2(1));
                    if (!varName.equals("this") && !EfNames.validFieldName(varName)) {
                        throw new VerifierError("DebugComponent.41", (Object)varName, (Object)MethodDebugInfo.this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    int stackFrameSize = (MethodDebugInfo.this.methodInfo.flags() & 8) == 0 ? MethodDebugInfo.this.methodInfo.maxStackCompact() + MethodDebugInfo.this.methodInfo.maxLocalsCompact() + MethodDebugInfo.this.methodInfo.numArgsCompact() : MethodDebugInfo.this.methodInfo.maxStackExtended() + MethodDebugInfo.this.methodInfo.maxLocalsExtended() + MethodDebugInfo.this.methodInfo.numArgsExtended();
                    if (index > stackFrameSize || index < 0) {
                        throw new VerifierError("DebugComponent.42", (Object)varName, (Object)MethodDebugInfo.this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    String varDesc = DebugComponent.this.getStringAt(this.u2(3));
                    if (!EfNames.validFieldDescriptor(varDesc)) {
                        throw new VerifierError("DebugComponent.43", (Object)varName, (Object)MethodDebugInfo.this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    int scopeStartPC = this.u2(5);
                    if (scopeStartPC >= MethodDebugInfo.this.methodBodySize) {
                        throw new VerifierError("DebugComponent.44", (Object)varName, (Object)MethodDebugInfo.this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                    int scopeLength = this.u2(7);
                    if (scopeStartPC + scopeLength > MethodDebugInfo.this.methodBodySize) {
                        throw new VerifierError("DebugComponent.44", (Object)varName, (Object)MethodDebugInfo.this.methodName, (Object)ClassDebugInfo.this.className);
                    }
                }

                public int getVarInfoSize() {
                    return 9;
                }
            }
        }

        private class FieldDebugInfo
        extends Safeptr {
            private static final int NAME_INDEX_OFFSET = 0;
            private static final int DESCRIPTOR_INDEX_OFFSET = 2;
            private static final int ACCESS_FLAG_OFFSET = 4;
            private static final int CONTENTS_OFFSET = 6;
            static final int FIELD_DEBUG_INFO_SIZE = 10;
            private static final int validFieldFlags = 31;

            FieldDebugInfo(Safeptr p) {
                super(p);
            }

            public String getFieldName() {
                return DebugComponent.this.getStringAt(this.u2(0));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void verify() {
                EfField exportedField = null;
                String fieldName = DebugComponent.this.getStringAt(this.u2(0));
                if (!EfNames.validFieldName(fieldName)) {
                    throw new VerifierError("DebugComponent.19", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
                String fieldDesc = DebugComponent.this.getStringAt(this.u2(2));
                if (!EfNames.validFieldDescriptor(fieldDesc)) {
                    throw new VerifierError("DebugComponent.20", (Object)fieldDesc, (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
                int fieldFlags = this.u2(4);
                if ((fieldFlags & 0xFFFFFFE0) != 0) {
                    throw new VerifierError("DebugComponent.21", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
                int flag_count = 0;
                if ((fieldFlags & 2) != 0) {
                    ++flag_count;
                }
                if ((fieldFlags & 4) != 0) {
                    ++flag_count;
                }
                if ((fieldFlags & 1) != 0) {
                    ++flag_count;
                }
                if (flag_count > 1) {
                    throw new VerifierError("DebugComponent.22", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
                int contents = this.s4(6);
                if ((fieldFlags & 8) == 0) {
                    int fieldToken = contents & 0xFF;
                    FieldDescriptor fd = ClassDebugInfo.this.cdesc.getFieldDescriptorForToken(fieldToken, false);
                    if (fd == null) throw new VerifierError("DebugComponent.24", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                    if (fd.flags() != fieldFlags) {
                        throw new VerifierError("DebugComponent.23", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                    }
                    if (DebugComponent.this.exportedClass == null || (fd.flags() & 1) == 0 && (fd.flags() & 4) == 0) return;
                    exportedField = DebugComponent.this.exportedClass.getFieldForTokenAndFlag(fieldToken, false);
                    if (exportedField == null) throw new VerifierError("DebugComponent.54", fieldToken, (Object)ClassDebugInfo.this.className);
                    String exportedFieldName = exportedField.name();
                    String exportedFieldDescrpitor = exportedField.sig();
                    if (!fieldName.equals(exportedFieldName)) {
                        throw new VerifierError("DebugComponent.52", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                    }
                    if (fieldDesc.equals(exportedFieldDescrpitor)) return;
                    throw new VerifierError("DebugComponent.53", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
                if ((fieldFlags & 8) != 0 && (fieldFlags & 0x10) == 0 || (fieldFlags & 8) != 0 && (fieldFlags & 0x10) != 0 && (fieldDesc.equals(DebugComponent.BYTE_ARRAY_DESCRIPTOR) || fieldDesc.equals(DebugComponent.SHORT_ARRAY_DESCRIPTOR) || fieldDesc.equals(DebugComponent.INTEGER_ARRAY_DESCRIPTOR) || fieldDesc.equals(DebugComponent.BOOLEAN_ARRAY_DESCRIPTOR))) {
                    int fieldLocation = contents & 0xFFFF;
                    FieldDescriptor fd = ClassDebugInfo.this.cdesc.getFieldDescriptorForLocation(fieldLocation);
                    if (fd == null) {
                        throw new VerifierError("DebugComponent.25", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                    }
                    if (fd.flags() != fieldFlags) {
                        throw new VerifierError("DebugComponent.23", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                    }
                    if (DebugComponent.this.exportedClass == null || (fieldFlags & 1) == 0 && (fieldFlags & 4) == 0) return;
                    exportedField = DebugComponent.this.exportedClass.getFieldForName(fieldName);
                    if (exportedField == null) {
                        throw new VerifierError("DebugComponent.55", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                    }
                    if (!fieldDesc.equals(exportedField.sig())) {
                        throw new VerifierError("DebugComponent.53", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                    }
                    FieldDescriptor fdByToken = ClassDebugInfo.this.cdesc.getFieldDescriptorForToken(exportedField.token, true);
                    if (fdByToken.equals(fd)) return;
                    throw new VerifierError("DebugComponent.25", (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
                this.verifyConstantValue(fieldDesc, contents, fieldName);
            }

            void verifyConstantValue(String descr, int val, String fieldName) {
                int max;
                int min;
                if (descr.equals("Z")) {
                    min = 0;
                    max = 1;
                } else if (descr.equals("B")) {
                    min = -128;
                    max = 127;
                } else if (descr.equals("S")) {
                    min = Short.MIN_VALUE;
                    max = Short.MAX_VALUE;
                } else if (descr.equals("I")) {
                    min = Integer.MIN_VALUE;
                    max = Integer.MAX_VALUE;
                } else {
                    throw new VerifierError("DebugComponent.20", (Object)descr, (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
                if (val < min || val > max) {
                    throw new VerifierError("DebugComponent.56", val, (Object)fieldName, (Object)ClassDebugInfo.this.className);
                }
            }
        }
    }
}

