/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.AppletInfo;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AppletComponent
extends Safeptr {
    private Hashtable<ClassDescriptor, AppletInfo> appletsInCap = new Hashtable();
    int multiSelectableAppletCount = 0;
    private static TypeMethod installMethodType = new TypeMethod(Type.ByteArray, Type.Short, Type.Byte, Type.Void);

    AppletComponent(byte[] data) {
        super(data, "Applet");
    }

    int count() {
        return this.u1(0);
    }

    AppletInfo appletInfo() {
        return new AppletInfo(this.offset(1));
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("AppletComponent.100");
        }
        Vector<AppletInfo> appletAids = new Vector<AppletInfo>();
        AppletInfo appl = this.appletInfo();
        for (int i = this.count(); i > 0; --i) {
            this.verifyApplet(appl, appletAids);
            appl = appl.next();
        }
        if (this.multiSelectableAppletCount != 0 && this.multiSelectableAppletCount != this.count()) {
            throw new VerifierError("AppletComponent.8");
        }
        if (!appl.atComponentEnd()) {
            throw new VerifierError("AppletComponent.1");
        }
    }

    private void verifyApplet(AppletInfo appl, Vector<AppletInfo> appletAids) {
        if (!AID.isValid(appl)) {
            throw new VerifierError("AppletComponent.3", appl.AID_length());
        }
        if (!AID.sameRID(appl, Cap.Header.thisPackage())) {
            throw new VerifierError("AppletComponent.4");
        }
        if (AID.same((AIDintf)appl, Cap.Header.thisPackage())) {
            throw new VerifierError("AppletComponent.6");
        }
        for (AppletInfo appletInfo : appletAids) {
            AppletInfo a = appletInfo;
            if (!AID.same((AIDintf)appl, a)) continue;
            throw new VerifierError("AppletComponent.7", AID.pretty(appl));
        }
        appletAids.add(appl);
        ClassAndMethodDescriptor cm = Methodref.checkInternalStaticRef(appl.installMethod());
        TypeMethod mty = TypeMethod.parseCap(Cap.TypeDescr.at(cm.methodDescr.type()));
        if (!mty.equals(installMethodType)) {
            throw new VerifierError("AppletComponent.2", mty);
        }
        if (!Classref.isSubclass(cm.classDescr.thisClass(), Classref.refForName("javacard/framework/Applet"))) {
            throw new VerifierError("AppletComponent.5");
        }
        if (Classref.isMultiSelectable(cm.classDescr.thisClass())) {
            ++this.multiSelectableAppletCount;
        }
        this.appletsInCap.put(cm.classDescr, appl);
    }

    public boolean isAppletClass(ClassDescriptor classDescr) {
        Enumeration<ClassDescriptor> descriptors = this.appletsInCap.keys();
        while (descriptors.hasMoreElements()) {
            ClassDescriptor desc = descriptors.nextElement();
            if (desc.thisClass() != classDescr.thisClass()) continue;
            return true;
        }
        return false;
    }

    public AppletInfo getAppletInfoForClass(ClassDescriptor classDescr) {
        Enumeration<ClassDescriptor> descriptors = this.appletsInCap.keys();
        while (descriptors.hasMoreElements()) {
            ClassDescriptor desc = descriptors.nextElement();
            if (desc.thisClass() != classDescr.thisClass()) continue;
            return this.appletsInCap.get(desc);
        }
        return null;
    }

    public boolean isInstallMethod(MethodDescriptor md) {
        int methodOffset = md.methodOffset();
        int appletCount = this.count();
        AppletInfo ai = this.appletInfo();
        for (int i = 0; i < appletCount; ++i) {
            if (ai.installMethod() == methodOffset) {
                return true;
            }
            ai = ai.next();
        }
        return false;
    }
}

