/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import com.sun.javacard.jcasm.SuperInterface;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.PackageDirectory;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

public class A51OutputFormatter
extends OutputFormatter {
    protected StringBuffer preamble;
    protected StringBuffer rom;
    protected StringBuffer staticFields;
    protected StringBuffer staticInit;
    protected StringBuffer applets;
    protected StringBuffer packages;
    protected StringBuffer exceptionTable;
    protected StringBuffer exportComponent;
    protected int exportComponentLength;
    protected int nExceptionEntries;
    protected StringBuffer defineList;
    protected PackageDirectory packageDirectory;
    private int relocPc;
    private int relocFieldPc;
    private int romBase = 0;
    private int e2Base = 33024;

    public A51OutputFormatter(BufferedReader configFile) throws IOException {
        super(configFile);
        try {
            String strRomBase = this.getMapEntry("ROMBASE");
            if (strRomBase != null) {
                this.romBase = Integer.decode(strRomBase);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.0", null);
        }
        try {
            String strE2Base = this.getMapEntry("E2BASE");
            if (strE2Base != null) {
                this.e2Base = Integer.decode(strE2Base);
            }
        }
        catch (NumberFormatException e) {
            Msg.error("cref.1", null);
        }
        this.preamble = new StringBuffer();
        this.preamble.append("$SAVE" + Msg.eol);
        this.preamble.append("$NOLIST" + Msg.eol);
        this.preamble.append("$INCLUDE (opcode.inc)" + Msg.eol);
        this.preamble.append("$INCLUDE (mask.inc)" + Msg.eol);
        this.preamble.append("$RESTORE" + Msg.eol + Msg.eol);
        this.preamble.append("BYTECODE     SEGMENT CODE  AT " + Integer.toHexString(this.romBase) + "H" + Msg.eol);
        this.preamble.append("STATICFIELDS SEGMENT XDATA AT " + Integer.toHexString(this.e2Base) + "H" + Msg.eol);
        this.preamble.append("STATICINIT   SEGMENT CODE" + Msg.eol);
        this.preamble.append("EXCEPTIONTBL SEGMENT CODE" + Msg.eol);
        this.preamble.append("PACKAGETBL   SEGMENT CODE" + Msg.eol);
        this.preamble.append("APPLETTBL    SEGMENT CODE" + Msg.eol);
        this.preamble.append("EXPORTCOMP   SEGMENT CODE" + Msg.eol);
        this.rom = new StringBuffer();
        this.rom.append("RSEG BYTECODE" + Msg.eol);
        this.rom.append("PUBLIC ROM_MASK" + Msg.eol);
        this.rom.append("ROM_MASK:" + Msg.eol);
        this.staticFields = new StringBuffer();
        this.staticFields.append("RSEG STATICFIELDS" + Msg.eol);
        this.staticFields.append("PUBLIC STATIC_FIELDS" + Msg.eol);
        this.staticFields.append("STATIC_FIELDS:" + Msg.eol);
        this.staticInit = new StringBuffer();
        this.staticInit.append("RSEG STATICINIT" + Msg.eol);
        this.staticInit.append("PUBLIC STATIC_INIT" + Msg.eol);
        this.staticInit.append("STATIC_INIT:" + Msg.eol);
        this.applets = new StringBuffer();
        this.applets.append("RSEG APPLETTBL" + Msg.eol);
        this.applets.append("PUBLIC APPLET_TABLE" + Msg.eol);
        this.applets.append("APPLET_TABLE:" + Msg.eol);
        this.packages = new StringBuffer();
        this.packages.append("RSEG PACKAGETBL" + Msg.eol);
        this.packages.append("PUBLIC PACKAGE_TABLE" + Msg.eol);
        this.packages.append("PACKAGE_TABLE:" + Msg.eol);
        this.exceptionTable = new StringBuffer();
        this.exceptionTable.append("RSEG EXCEPTIONTBL" + Msg.eol);
        this.exceptionTable.append("PUBLIC EXCEPTION_TABLE" + Msg.eol);
        this.exceptionTable.append("EXCEPTION_TABLE:" + Msg.eol);
        this.exportComponent = new StringBuffer();
        this.exportComponent.append("RSEG EXPORTCOMP" + Msg.eol);
        this.exportComponent.append("PUBLIC EXPORT_COMPONENT" + Msg.eol);
        this.exportComponent.append("EXPORT_COMPONENT:" + Msg.eol);
        this.defineList = new StringBuffer();
        this.packageDirectory = new PackageDirectory();
    }

    @Override
    public void format(RomMask r) {
        this.pass1(r);
        this.pass2(r);
    }

    protected void pass1(RomMask r) {
        Enumeration<JCPackage> e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = e.nextElement();
            Enumeration<JCClass> f = p.classElements();
            while (f.hasMoreElements()) {
                JCClass c = f.nextElement();
                c.relocate(this.relocPc);
                this.relocPc += c.size();
                if (Modifier.isInterface(c.getAttributes())) continue;
                Enumeration<Member> g = c.fieldElements();
                while (g.hasMoreElements()) {
                    Field field = g.nextElement();
                    if (!Modifier.isStatic(field.getAttributes())) continue;
                    FieldDescriptor descriptor = field.getDescriptor();
                    if (Modifier.isFinal(field.getAttributes()) && descriptor.isPrimitive()) continue;
                    field.relocate(this.relocFieldPc);
                    this.relocFieldPc += field.size();
                    StaticFieldInitializer init = field.getFieldInitializer();
                    if (init != null && init.isPrimitive()) {
                        int data = init.getPrimitiveData();
                        switch (field.size()) {
                            case 1: {
                                this.staticInit.append("DB " + this.byteHexString(data));
                                break;
                            }
                            case 2: {
                                this.staticInit.append("DW " + this.shortHexString(data));
                                break;
                            }
                            case 4: {
                                this.staticInit.append("DW " + this.shortHexString(data >> 16) + ", ");
                                this.staticInit.append(this.shortHexString(data));
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                    } else {
                        switch (field.size()) {
                            case 1: {
                                this.staticInit.append("DB 00h");
                                break;
                            }
                            case 2: {
                                this.staticInit.append("DW 0000h");
                                break;
                            }
                            case 4: {
                                this.staticInit.append("DW 0000h, 0000h");
                                break;
                            }
                            default: {
                                throw new InternalError();
                            }
                        }
                    }
                    this.staticInit.append("\t; " + field.getName() + Msg.eol);
                }
                g = c.methodElements();
                while (g.hasMoreElements()) {
                    JCMethod m = (JCMethod)g.nextElement();
                    if (Modifier.isNative(m.getAttributes())) {
                        m.relocate(0);
                        continue;
                    }
                    m.relocate(this.relocPc);
                    this.relocPc += m.size();
                }
            }
        }
    }

    protected void pass2(RomMask r) {
        Enumeration<JCPackage> e = r.packageElements();
        while (e.hasMoreElements()) {
            JCPackage p = e.nextElement();
            ExportComponent export = new ExportComponent(p);
            PackageIdentifier pid = p.getIdentifier();
            this.packageDirectory.addPackage(pid);
            byte[] aid = pid.getAid().toByteArray();
            this.packages.append("DB " + aid.length + ", ");
            for (byte element : aid) {
                this.packages.append(this.byteHexString(element) + ", ");
            }
            this.packages.append(pid.getMajorVersion() + ", " + pid.getMinorVersion() + ", " + this.exportComponentLength + Msg.eol);
            Enumeration<Object> f = p.appletElements();
            while (f.hasMoreElements()) {
                AppletDeclarator applet = f.nextElement();
                byte[] appletAid = applet.getAid().toByteArray();
                int addr = applet.resolve().getRelocAddr();
                this.applets.append("DB " + this.packageDirectory.indexOf(pid) + ", " + appletAid.length + ", ");
                for (byte element : appletAid) {
                    this.applets.append(this.byteHexString(element) + ", ");
                }
                this.applets.append(", " + this.shortHexString(addr + this.romBase) + Msg.eol);
            }
            f = p.classElements();
            while (f.hasMoreElements()) {
                JCMethod m;
                int flags;
                JCClass c = (JCClass)f.nextElement();
                export.add(c);
                this.rom.append(Msg.eol + "; class@" + this.shortHexString(c.getRelocAddr()) + ": " + Modifier.toString(c.getAttributes()) + " " + c.getName() + Msg.eol);
                String mapTo = this.getMapEntry(c.getName());
                if (mapTo != null) {
                    this.defineList.append("#define " + mapTo + " " + (c.getRelocAddr() + this.romBase) + "\t/* " + c.getName() + " */" + Msg.eol);
                }
                int n = flags = c.isShareable() ? 64 : 0;
                if (Modifier.isInterface(c.getAttributes())) {
                    int superCount = c.superInterfaceVector.size();
                    this.rom.append("DB " + this.byteHexString((flags |= 0x80) | superCount & 0xF) + ", ");
                    for (SuperInterface si : c.superInterfaceVector) {
                        int addr = si.resolve().getRelocAddr();
                        this.rom.append("HIGH(" + this.shortHexString(addr + this.romBase) + "), ");
                        this.rom.append("LOW(" + this.shortHexString(addr + this.romBase) + "), ");
                        this.rom.append(Msg.eol);
                    }
                    continue;
                }
                this.rom.append("DB " + this.byteHexString(flags | c.interfaceVector.size() & 0xF) + ", ");
                JCClass superClass = c.getSuperClass();
                if (superClass == null) {
                    this.rom.append(this.byteHexString(255) + ", ");
                    this.rom.append(this.byteHexString(255) + ", ");
                } else {
                    this.rom.append("HIGH(" + this.shortHexString(superClass.getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(superClass.getRelocAddr() + this.romBase) + "), ");
                }
                int instanceSize = 0;
                for (JCClass currentClass = c; currentClass != null; currentClass = currentClass.getSuperClass()) {
                    instanceSize += currentClass.getInstanceSize();
                }
                this.rom.append(this.byteHexString(instanceSize) + ", ");
                this.rom.append(this.byteHexString(c.getFirstReferenceToken()) + ", ");
                this.rom.append(this.byteHexString(c.getReferenceCount()) + ", ");
                this.rom.append(this.byteHexString(c.publicMethodTable.getBase()) + ", ");
                this.rom.append(this.byteHexString(c.publicMethodTable.getCount()) + ", ");
                this.rom.append(this.byteHexString(c.packageMethodTable.getBase()) + ", ");
                this.rom.append(this.byteHexString(c.packageMethodTable.getCount()) + ", ");
                this.rom.append(Msg.eol);
                Enumeration<JCMethod> g = c.publicMethodTable.elements();
                while (g.hasMoreElements()) {
                    m = g.nextElement();
                    this.rom.append("DB HIGH(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "),\t\t; " + m.getName() + Msg.eol);
                }
                g = c.packageMethodTable.elements();
                while (g.hasMoreElements()) {
                    m = g.nextElement();
                    this.rom.append("DB HIGH(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(m.getRelocAddr() + this.romBase) + "),\t\t; " + m.getName() + Msg.eol);
                }
                for (InterfaceTable itbl : c.interfaceVector) {
                    byte[] table = itbl.toByteArray();
                    int addr = itbl.resolve().getRelocAddr();
                    this.rom.append("DB HIGH(" + this.shortHexString(addr + this.romBase) + "), ");
                    this.rom.append("LOW(" + this.shortHexString(addr + this.romBase) + "), ");
                    for (int i = 2; i < table.length; ++i) {
                        this.rom.append(table[i] + ", ");
                    }
                    this.rom.append(Msg.eol);
                }
                Enumeration<Member> g2 = c.fieldElements();
                while (g2.hasMoreElements()) {
                    Field field = g2.nextElement();
                    int mod = field.getAttributes();
                    if (!Modifier.isStatic(mod) || Modifier.isFinal(mod) || (mapTo = this.getMapEntry(field.getName())) == null) continue;
                    this.defineList.append("#define " + mapTo + " " + (field.getRelocAddr() + this.e2Base) + "\t/* " + field.getName() + " */" + Msg.eol);
                }
                g2 = c.methodElements();
                while (g2.hasMoreElements()) {
                    JCMethod m2 = (JCMethod)g2.nextElement();
                    if (Modifier.isNative(m2.getAttributes())) continue;
                    mapTo = this.getMapEntry(m2.getName());
                    if (mapTo != null) {
                        this.defineList.append("#define " + mapTo + " " + (m2.getRelocAddr() + this.romBase) + "\t/* " + m2.getName() + " */" + Msg.eol);
                    }
                    this.rom.append(Msg.eol + "; method@" + this.shortHexString(m2.getRelocAddr()) + ": " + Modifier.toString(m2.getAttributes()) + " " + m2.getName() + Msg.eol);
                    byte[] header = m2.getMethodHeader();
                    this.rom.append("DB ");
                    for (byte element : header) {
                        this.rom.append(this.byteHexString(element & 0xFF) + ", ");
                    }
                    this.rom.append(Msg.eol);
                    if (Modifier.isAbstract(m2.getAttributes())) continue;
                    Enumeration<Statement> h = m2.statementElements();
                    while (h.hasMoreElements()) {
                        Statement s = h.nextElement();
                        this.format(s);
                        this.rom.append(", " + Msg.eol);
                    }
                    ExceptionTable exTbl = m2.getExceptionTable();
                    if (exTbl == null) continue;
                    Enumeration<ExceptionTableEntry> h2 = exTbl.elements();
                    while (h2.hasMoreElements()) {
                        ExceptionTableEntry entry = h2.nextElement();
                        this.exceptionTable.append("{ ");
                        this.exceptionTable.append(this.shortHexString(entry.getStartOffset() + this.romBase) + ", ");
                        int active_length = entry.getActiveLength();
                        if (entry.isOuterMost()) {
                            active_length |= 0x8000;
                        }
                        this.exceptionTable.append(this.shortHexString(active_length) + ", ");
                        this.exceptionTable.append(this.shortHexString(entry.getHandlerOffset() + this.romBase) + ", ");
                        this.exceptionTable.append(this.shortHexString(entry.getCatchIndex() + this.romBase) + ", ");
                        this.exceptionTable.append(" }," + Msg.eol);
                        ++this.nExceptionEntries;
                    }
                }
            }
            byte[] exportComponentByteArray = export.toByteArray();
            this.exportComponent.append("; " + p.getName() + Msg.eol + "DB ");
            for (int i = 0; i < exportComponentByteArray.length; ++i) {
                this.exportComponent.append(this.byteHexString(exportComponentByteArray[i]) + ", ");
                if (i % 8 != 7) continue;
                this.exportComponent.append(Msg.eol);
                if (i >= exportComponentByteArray.length) continue;
                this.exportComponent.append("DB ");
            }
            this.exportComponent.append(Msg.eol);
            this.exportComponentLength += exportComponentByteArray.length;
        }
    }

    protected void format(Statement s) {
        if (s.getInstruction() == null) {
            return;
        }
        this.format(s.getInstruction());
    }

    protected void format(Instruction i) {
        this.rom.append("DB _" + i.getMnemonic().toUpperCase());
        Enumeration<Operand> e = i.operandElements();
        while (e.hasMoreElements()) {
            Operand o = e.nextElement();
            this.format(o);
        }
    }

    protected void format(Operand o) {
        if (o.getType() == 8) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int addr = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + this.shortHexString(addr + this.romBase) + "), LOW(" + this.shortHexString(addr + this.romBase) + ")");
                    break;
                }
                case 5: {
                    int addr = info.resolve().getRelocAddr();
                    this.rom.append(", HIGH(" + this.shortHexString(addr + this.e2Base) + "), LOW(" + this.shortHexString(addr + this.e2Base) + ")");
                    break;
                }
                case 3: {
                    JCMethod m = (JCMethod)info.resolve();
                    MethodIdentifier mid = m.getMethodIdentifier();
                    int token = mid.getMethodToken();
                    int params = m.getParams();
                    this.rom.append(", " + this.byteHexString(params) + ", " + this.byteHexString(token));
                    break;
                }
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.rom.append(", " + this.byteHexString(offset >> 8) + ", " + this.byteHexString(offset & 0xFF));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.getType() == 7) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.rom.append(", " + this.byteHexString(offset));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.size() == 1) {
            this.rom.append(", " + o.getValue());
        } else if (o.size() == 2) {
            this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        } else if (o.size() == 4) {
            this.rom.append(", " + (o.getValue() >> 24 & 0xFF) + ", " + (o.getValue() >> 16 & 0xFF));
            this.rom.append(", " + (o.getValue() >> 8 & 0xFF) + ", " + (o.getValue() & 0xFF));
        }
    }

    @Override
    public void write(OutputStream os) {
        PrintWriter pw = new PrintWriter(os);
        pw.println(this.preamble.toString());
        pw.println(this.rom.toString());
        pw.println(this.exceptionTable.toString());
        pw.println("EXTBL_LENGTH EQU $ - EXCEPTION_TABLE" + Msg.eol);
        pw.print(this.staticFields.toString());
        pw.println("DS " + this.relocFieldPc + Msg.eol);
        pw.println(this.staticInit.toString());
        pw.println("STATIC_INIT_LENGTH EQU $ - STATIC_INIT" + Msg.eol);
        pw.println(this.applets.toString());
        pw.println("APPLET_TBL_LENGTH EQU $ - APPLET_TABLE" + Msg.eol);
        pw.println("$IF (POST_ISSUANCE_INSTALL = 1)");
        pw.print(this.packages.toString());
        pw.println("PACKAGE_TBL_LENGTH EQU $ - PACKAGE_TABLE" + Msg.eol);
        pw.print(this.exportComponent.toString());
        pw.println("EXPORT_COMP_LENGTH EQU $ - EXPORT_COPMPONENT" + Msg.eol);
        pw.println("$ENDIF\t;POST_ISSUANCE_INSTALL");
        pw.flush();
    }

    private String byteHexString(int data) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toHexString(data &= 0xFF) + "h");
        if (sb.length() == 2) {
            sb.insert(0, '0');
        } else {
            switch (sb.charAt(0)) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    sb.insert(0, '0');
                }
            }
        }
        return sb.toString();
    }

    private String shortHexString(int data) {
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toHexString(data &= 0xFFFF) + "h");
        switch (sb.charAt(0)) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                sb.insert(0, '0');
            }
        }
        return sb.toString();
    }
}

