/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.javax.smartcard.rmiclient;

import com.sun.javacard.clientlib.CardAccessor;
import com.sun.javacard.javax.smartcard.rmiclient.APDUExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.BioExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.CardExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.CardRuntimeExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.CryptoExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.ExternalExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.ISOExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.PINExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.ServiceExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.SystemExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.TLVExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.TransactionExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.UserExceptionSubclass;
import com.sun.javacard.javax.smartcard.rmiclient.UtilExceptionSubclass;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.StubNotFoundException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javacard.framework.APDUException;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.ISOException;
import javacard.framework.PINException;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.UserException;
import javacard.framework.service.ServiceException;
import javacard.security.CryptoException;
import javacardx.biometry.BioException;
import javacardx.external.ExternalException;
import javacardx.framework.tlv.TLVException;
import javacardx.framework.util.UtilException;

public abstract class CardObjectFactory {
    private static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/javax/smartcard/rmiclient/MessagesBundle");
    private static final byte NORMAL_TAG = -127;
    private static final byte EXCEPTION_TAG = -126;
    private static final byte EXCEPTION_SUBCLASS_TAG = -125;
    private static final byte ERROR_TAG = -103;
    public static final byte REF_FORMAT_NONE = 0;
    public static final byte REF_FORMAT_CLASS = 1;
    public static final byte REF_FORMAT_INTERFACES = 2;
    private byte invokeINS = 0;
    private static final byte Throwable_Type = 0;
    private static final byte ArithmeticException_Type = 1;
    private static final byte ArrayIndexOutOfBoundsException_Type = 2;
    private static final byte ArrayStoreException_Type = 3;
    private static final byte ClassCastException_Type = 4;
    private static final byte Exception_Type = 5;
    private static final byte IndexOutOfBoundsException_Type = 6;
    private static final byte NegativeArraySizeException_Type = 7;
    private static final byte NullPointerException_Type = 8;
    private static final byte RuntimeException_Type = 9;
    private static final byte SecurityException_Type = 10;
    private static final byte java_io_IOException_Type = 11;
    private static final byte java_rmi_RemoteException_Type = 12;
    private static final byte APDUException_Type = 32;
    private static final byte CardException_Type = 33;
    private static final byte CardRuntimeException_Type = 34;
    private static final byte ISOException_Type = 35;
    private static final byte PINException_Type = 36;
    private static final byte SystemException_Type = 37;
    private static final byte TransactionException_Type = 38;
    private static final byte UserException_Type = 39;
    private static final byte CryptoException_Type = 48;
    private static final byte ServiceException_Type = 64;
    private static final byte BioException_Type = 80;
    private static final byte ExternalException_Type = 96;
    private static final byte TLVException_Type = 112;
    private static final byte UtilException_Type = -128;

    public Object getObject(byte[] buffer, int tagOffset, Class type, CardAccessor cardAccessor) throws RemoteException, StubNotFoundException, Exception {
        this.throwException(buffer, tagOffset);
        try {
            String tName = type.getName();
            if (tName.startsWith("[") || "boolean".equals(tName) || "byte".equals(tName) || "short".equals(tName) || "int".equals(tName) || "void".equals(tName)) {
                return this.getNonRemoteObject(buffer, tagOffset, type);
            }
            return this.getRemoteObject(buffer, tagOffset, cardAccessor);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RemoteException(_messages.getString("response.too_short"));
        }
    }

    protected abstract Remote getRemoteObject(byte[] var1, int var2, CardAccessor var3) throws Exception;

    private Object getNonRemoteObject(byte[] buffer, int tagOffset, Class type) throws RemoteException, Exception {
        this.throwException(buffer, tagOffset);
        int dataOffset = tagOffset + 1;
        String tName = type.getName();
        if ("boolean".equals(tName)) {
            return this.readBooleanObject(buffer, dataOffset);
        }
        if ("byte".equals(tName)) {
            return this.readByteObject(buffer, dataOffset);
        }
        if ("short".equals(tName)) {
            return this.readShortObject(buffer, dataOffset);
        }
        if ("int".equals(tName)) {
            return this.readIntegerObject(buffer, dataOffset);
        }
        if ("void".equals(tName)) {
            return this.readVoidObject(buffer, dataOffset);
        }
        if ("[Z".equals(tName)) {
            return this.readBooleanArray(buffer, dataOffset);
        }
        if ("[B".equals(tName)) {
            return this.readByteArray(buffer, dataOffset);
        }
        if ("[S".equals(tName)) {
            return this.readShortArray(buffer, dataOffset);
        }
        if ("[I".equals(tName)) {
            return this.readIntArray(buffer, dataOffset);
        }
        throw new RemoteException(_messages.getString("other.1"));
    }

    public void setINSByte(byte ins) {
        this.invokeINS = ins;
    }

    public byte getINSByte() {
        return this.invokeINS;
    }

    public abstract byte getRemoteRefFormat();

    private boolean readBoolean(byte[] buffer, int offset) {
        return buffer[offset] != 0;
    }

    private byte readByte(byte[] buffer, int offset) {
        return buffer[offset];
    }

    private short readShort(byte[] buffer, int offset) {
        return (short)(buffer[offset] << 8 | buffer[offset + 1] & 0xFF);
    }

    private int readInt(byte[] buffer, int offset) {
        return buffer[offset] << 24 | buffer[offset + 1] << 16 & 0xFF0000 | buffer[offset + 2] << 8 & 0xFF00 | buffer[offset + 3] & 0xFF;
    }

    private Boolean readBooleanObject(byte[] apdu, int offset) {
        boolean b = this.readBoolean(apdu, offset);
        return new Boolean(b);
    }

    private Byte readByteObject(byte[] apdu, int offset) {
        byte b = this.readByte(apdu, offset);
        return new Byte(b);
    }

    private Short readShortObject(byte[] apdu, int offset) {
        short s = this.readShort(apdu, offset);
        return new Short(s);
    }

    private Integer readIntegerObject(byte[] apdu, int offset) {
        int i = this.readInt(apdu, offset);
        return new Integer(i);
    }

    private Void readVoidObject(byte[] apdu, int offset) {
        return null;
    }

    private boolean[] readBooleanArray(byte[] apdu, int offset) {
        if (apdu[offset] == -1) {
            return null;
        }
        int n = apdu[offset] & 0xFF;
        int curr_offset = offset + 1;
        boolean[] res = new boolean[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.readBoolean(apdu, curr_offset);
            ++curr_offset;
        }
        return res;
    }

    private byte[] readByteArray(byte[] apdu, int offset) {
        if (apdu[offset] == -1) {
            return null;
        }
        int n = apdu[offset] & 0xFF;
        int curr_offset = offset + 1;
        byte[] res = new byte[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.readByte(apdu, curr_offset);
            ++curr_offset;
        }
        return res;
    }

    private short[] readShortArray(byte[] apdu, int offset) {
        if (apdu[offset] == -1) {
            return null;
        }
        int n = apdu[offset] & 0xFF;
        int curr_offset = offset + 1;
        short[] res = new short[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.readShort(apdu, curr_offset);
            curr_offset += 2;
        }
        return res;
    }

    private int[] readIntArray(byte[] apdu, int offset) {
        if (apdu[offset] == -1) {
            return null;
        }
        int n = apdu[offset] & 0xFF;
        int curr_offset = offset + 1;
        int[] res = new int[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.readInt(apdu, curr_offset);
            curr_offset += 4;
        }
        return res;
    }

    private void throwException(byte[] buffer, int tagOffset) throws Exception {
        byte tag;
        try {
            tag = buffer[tagOffset];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RemoteException(_messages.getString("response.too_short"));
        }
        int dataOffset = tagOffset + 1;
        if (tag == -126) {
            this.throwIt(buffer, dataOffset);
        }
        if (tag == -125) {
            this.throwSubclass(buffer, dataOffset);
        }
        if (tag == -103) {
            this.throwError(buffer, dataOffset);
        }
        if (tag != -127) {
            throw new RemoteException(_messages.getString("unsupported.1"));
        }
    }

    private void throwIt(byte[] apdu, int offset) throws Exception {
        short reason;
        byte type;
        try {
            type = apdu[offset];
            reason = this.readShort(apdu, offset + 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RemoteException(_messages.getString("response.too_short"));
        }
        switch (type) {
            case 0: {
                throw new Exception(_messages.getString("thrown.throwable"));
            }
            case 1: {
                throw new ArithmeticException(_messages.getString("thrown.exact"));
            }
            case 2: {
                throw new ArrayIndexOutOfBoundsException(_messages.getString("thrown.exact"));
            }
            case 3: {
                throw new ArrayStoreException(_messages.getString("thrown.exact"));
            }
            case 4: {
                throw new ClassCastException(_messages.getString("thrown.exact"));
            }
            case 5: {
                throw new Exception(_messages.getString("thrown.exact"));
            }
            case 6: {
                throw new IndexOutOfBoundsException(_messages.getString("thrown.exact"));
            }
            case 7: {
                throw new NegativeArraySizeException(_messages.getString("thrown.exact"));
            }
            case 8: {
                throw new NullPointerException(_messages.getString("thrown.exact"));
            }
            case 9: {
                throw new RuntimeException(_messages.getString("thrown.exact"));
            }
            case 10: {
                throw new SecurityException(_messages.getString("thrown.exact"));
            }
            case 11: {
                throw new IOException(_messages.getString("thrown.exact"));
            }
            case 12: {
                throw new RemoteException(_messages.getString("thrown.exact"));
            }
            case 32: {
                throw new APDUException(reason);
            }
            case 33: {
                throw new CardException(reason);
            }
            case 34: {
                throw new CardRuntimeException(reason);
            }
            case 35: {
                throw new ISOException(reason);
            }
            case 36: {
                throw new PINException(reason);
            }
            case 37: {
                throw new SystemException(reason);
            }
            case 38: {
                throw new TransactionException(reason);
            }
            case 39: {
                throw new UserException(reason);
            }
            case 48: {
                throw new CryptoException(reason);
            }
            case 64: {
                throw new ServiceException(reason);
            }
            case 80: {
                throw new BioException(reason);
            }
            case 96: {
                throw new ExternalException(reason);
            }
            case 112: {
                throw new TLVException(reason);
            }
            case -128: {
                throw new UtilException(reason);
            }
        }
        throw new RemoteException(_messages.getString("thrown.unknown"));
    }

    private void throwSubclass(byte[] apdu, int offset) throws Exception {
        byte type = apdu[offset];
        short reason = this.readShort(apdu, offset + 1);
        switch (type) {
            case 0: {
                throw new Exception(_messages.getString("thrown.throwable_subclass"));
            }
            case 1: {
                throw new ArithmeticException(_messages.getString("thrown.subclass"));
            }
            case 2: {
                throw new ArrayIndexOutOfBoundsException(_messages.getString("thrown.subclass"));
            }
            case 3: {
                throw new ArrayStoreException(_messages.getString("thrown.subclass"));
            }
            case 4: {
                throw new ClassCastException(_messages.getString("thrown.subclass"));
            }
            case 5: {
                throw new Exception(_messages.getString("thrown.subclass"));
            }
            case 6: {
                throw new IndexOutOfBoundsException(_messages.getString("thrown.subclass"));
            }
            case 7: {
                throw new NegativeArraySizeException(_messages.getString("thrown.subclass"));
            }
            case 8: {
                throw new NullPointerException(_messages.getString("thrown.subclass"));
            }
            case 9: {
                throw new RuntimeException(_messages.getString("thrown.subclass"));
            }
            case 10: {
                throw new SecurityException(_messages.getString("thrown.subclass"));
            }
            case 11: {
                throw new IOException(_messages.getString("thrown.subclass"));
            }
            case 12: {
                throw new RemoteException(_messages.getString("thrown.subclass"));
            }
            case 32: {
                throw new APDUExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 33: {
                throw new CardExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 34: {
                throw new CardRuntimeExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 35: {
                throw new ISOExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 36: {
                throw new PINExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 37: {
                throw new SystemExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 38: {
                throw new TransactionExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 39: {
                throw new UserExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 48: {
                throw new CryptoExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 64: {
                throw new ServiceExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 80: {
                throw new BioExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 96: {
                throw new ExternalExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case 112: {
                throw new TLVExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
            case -128: {
                throw new UtilExceptionSubclass(_messages.getString("thrown.subclass"), reason);
            }
        }
        throw new RemoteException(_messages.getString("thrown.unknown_subclass"));
    }

    private void throwError(byte[] apdu, int offset) throws RemoteException {
        short error_type = this.readShort(apdu, offset);
        switch (error_type) {
            case 1: {
                throw new RemoteException(_messages.getString("error.1"));
            }
            case 2: {
                throw new RemoteException(_messages.getString("error.2"));
            }
            case 3: {
                throw new RemoteException(_messages.getString("error.3"));
            }
            case 4: {
                throw new RemoteException(_messages.getString("error.4"));
            }
            case 5: {
                throw new RemoteException(_messages.getString("error.5"));
            }
            case 6: {
                throw new RemoteException(_messages.getString("error.6"));
            }
        }
        throw new RemoteException(_messages.getString("error.unsupported"));
    }
}

