/*
 * Decompiled with CFR 0.152.
 */
package uicc.hci.test.services.readermode.api_2_rmm_srx;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.SystemException;
import uicc.hci.framework.HCIDevice;
import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIListener;
import uicc.hci.framework.HCIMessage;
import uicc.hci.services.readermode.ReaderListener;
import uicc.hci.services.readermode.ReaderMessage;
import uicc.hci.services.readermode.ReaderService;

public class Api_2_RMm_Srx_2
extends Applet
implements ReaderListener {
    private static final byte INS_TEST_HCI_DISABLED = 1;
    private static final byte INS_TEST_NULLPOINTER = 2;
    private static final byte INS_TEST_ARRAYBOUNDS_L = 3;
    private static final byte INS_TEST_ARRAYBOUNDS_H = 4;
    private static final byte INS_TEST_ILLIGALVALUE = 5;
    private static final byte INS_VERIFY_HCI_DISABLED = 17;
    private static final byte INS_VERIFY_NULLPOINTER = 18;
    private static final byte INS_VERIFY_ARRAYBOUNDS_L = 19;
    private static final byte INS_VERIFY_ARRAYBOUNDS_H = 20;
    private static final byte INS_VERIFY_ILLIGALVALUE = 21;
    private byte featureToTest;
    private boolean exceptionHciDisabledThrown;
    private boolean exceptionArrayIndexThrown;
    private boolean exceptionIlligalValueThrown;
    private boolean exceptionNullPointerThrown;
    private ReaderService readerService;

    public Api_2_RMm_Srx_2() {
        this.register();
        try {
            this.readerService = (ReaderService)HCIDevice.getHCIService((short)2);
            this.readerService.register((HCIListener)this);
        }
        catch (HCIException e) {
            ISOException.throwIt((short)27012);
        }
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        new Api_2_RMm_Srx_2();
    }

    public void process(APDU apdu) throws ISOException {
        if (this.selectingApplet()) {
            this.readerService.activateEvent((byte)80);
            return;
        }
        byte[] buffer = apdu.getBuffer();
        switch (buffer[1]) {
            case 1: {
                this.featureToTest = 1;
                break;
            }
            case 2: {
                this.featureToTest = (byte)2;
                break;
            }
            case 3: {
                this.featureToTest = (byte)3;
                break;
            }
            case 4: {
                this.featureToTest = (byte)4;
                break;
            }
            case 5: {
                this.featureToTest = (byte)5;
                break;
            }
            case 17: {
                if (!this.exceptionHciDisabledThrown) break;
                ISOException.throwIt((short)-28671);
                break;
            }
            case 18: {
                if (!this.exceptionNullPointerThrown) break;
                ISOException.throwIt((short)-28670);
                break;
            }
            case 19: {
                if (!this.exceptionArrayIndexThrown) break;
                ISOException.throwIt((short)-28669);
                break;
            }
            case 20: {
                if (!this.exceptionArrayIndexThrown) break;
                ISOException.throwIt((short)-28668);
                break;
            }
            case 21: {
                if (!this.exceptionIlligalValueThrown) break;
                ISOException.throwIt((short)-28667);
            }
        }
    }

    public void onCallback(byte event, HCIMessage message) {
        ReaderMessage readerMessage = (ReaderMessage)message;
        if (readerMessage.getType() == 64 && event == 80) {
            switch (readerMessage.getReceiveBuffer()[0]) {
                case 0: {
                    byte timeout = 14;
                    byte[] data = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                    short offset = 0;
                    short len = (short)data.length;
                    switch (this.featureToTest) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            data = null;
                            break;
                        }
                        case 3: {
                            offset = -1;
                            break;
                        }
                        case 4: {
                            len = (short)(len + 1);
                            break;
                        }
                        case 5: {
                            timeout = -2;
                        }
                    }
                    try {
                        readerMessage.prepareAndSendWriteXchgDataCommand(timeout, data, offset, len);
                    }
                    catch (HCIException e) {
                        if (e.getReason() == 3) {
                            if (this.featureToTest == 1) {
                                this.exceptionHciDisabledThrown = true;
                            }
                            return;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        if (this.featureToTest == 3 || this.featureToTest == 4) {
                            this.exceptionArrayIndexThrown = true;
                        }
                        return;
                    }
                    catch (SystemException e) {
                        if (e.getReason() == 1 && this.featureToTest == 5) {
                            this.exceptionIlligalValueThrown = true;
                        }
                        return;
                    }
                    catch (NullPointerException e) {
                        if (this.featureToTest == 2) {
                            this.exceptionNullPointerThrown = true;
                        }
                        return;
                    }
                    return;
                }
            }
        }
    }
}

