/*
 * Decompiled with CFR 0.152.
 */
package uicc.hci.test.services.readermode.api_2_rmm_srx;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import uicc.hci.framework.HCIDevice;
import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIListener;
import uicc.hci.framework.HCIMessage;
import uicc.hci.services.readermode.ReaderListener;
import uicc.hci.services.readermode.ReaderMessage;
import uicc.hci.services.readermode.ReaderService;

public class Api_2_RMm_Srx_1
extends Applet
implements ReaderListener {
    private static final byte INS_TEST_COMMAND_CASE_1 = 1;
    private static final byte INS_TEST_COMMAND_CASE_2 = 2;
    private static final byte INS_TEST_COMMAND_CASE_3 = 3;
    private static final byte INS_TEST_COMMAND_CASE_4 = 4;
    private static final byte INS_TEST_COMMAND_SET_TIMEOUT_0 = 5;
    private static final byte INS_TEST_COMMAND_SET_TIMEOUT_5 = 6;
    private static final byte INS_TEST_COMMAND_SET_TIMEOUT_14 = 7;
    private byte featureToTest;
    private ReaderService readerService;

    public Api_2_RMm_Srx_1() {
        this.register();
        try {
            this.readerService = (ReaderService)HCIDevice.getHCIService((short)2);
            this.readerService.register((HCIListener)this);
        }
        catch (HCIException e) {
            ISOException.throwIt((short)27012);
        }
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        new Api_2_RMm_Srx_1();
    }

    public void process(APDU apdu) throws ISOException {
        if (this.selectingApplet()) {
            this.readerService.activateEvent((byte)80);
            return;
        }
        byte[] buffer = apdu.getBuffer();
        switch (buffer[1]) {
            case 1: {
                this.featureToTest = 1;
                break;
            }
            case 2: {
                this.featureToTest = (byte)2;
                break;
            }
            case 3: {
                this.featureToTest = (byte)3;
                break;
            }
            case 4: {
                this.featureToTest = (byte)4;
                break;
            }
            case 5: {
                this.featureToTest = (byte)5;
                break;
            }
            case 6: {
                this.featureToTest = (byte)6;
                break;
            }
            case 7: {
                this.featureToTest = (byte)7;
            }
        }
    }

    public void onCallback(byte event, HCIMessage message) {
        ReaderMessage readerMessage = (ReaderMessage)message;
        if (readerMessage.getType() == 64 && event == 80) {
            switch (readerMessage.getReceiveBuffer()[0]) {
                case 0: {
                    byte[] data;
                    byte timeout = -1;
                    switch (this.featureToTest) {
                        case 1: {
                            data = new byte[]{0, 1, 0, 0};
                            break;
                        }
                        case 2: {
                            data = new byte[]{-128, 2, 1, 2, 0};
                            break;
                        }
                        case 3: {
                            data = new byte[]{-96, 3, -2, -1, 2, 63, 0};
                            break;
                        }
                        case 4: {
                            data = new byte[254];
                            data[0] = 0;
                            data[1] = 4;
                            data[2] = 0;
                            data[3] = 0;
                            int commandDataLength = 248;
                            data[4] = (byte)commandDataLength;
                            for (int commandDataIndex = 0; commandDataIndex < commandDataLength; commandDataIndex = (int)((short)(commandDataIndex + 1))) {
                                short value = (short)(commandDataIndex + 1);
                                short dataIndex = (short)(5 + commandDataIndex);
                                data[dataIndex] = (byte)value;
                            }
                            data[253] = 0;
                            break;
                        }
                        case 5: {
                            timeout = 0;
                            data = Api_2_RMm_Srx_1.createTimingTestAPDU((byte)5);
                            break;
                        }
                        case 6: {
                            timeout = 5;
                            data = Api_2_RMm_Srx_1.createTimingTestAPDU((byte)6);
                            break;
                        }
                        case 7: {
                            timeout = 14;
                            data = Api_2_RMm_Srx_1.createTimingTestAPDU((byte)7);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    short offset = 0;
                    short len = (short)data.length;
                    readerMessage.prepareAndSendWriteXchgDataCommand(timeout, data, offset, len);
                    return;
                }
            }
        }
    }

    private static byte[] createTimingTestAPDU(byte ins) {
        return new byte[]{0, ins, 0, 0, 2, 63, 0, 0};
    }
}

