/*
 * Decompiled with CFR 0.152.
 */
package uicc.hci.test.services.readermode.api_2_rmm_sgp;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.SystemException;
import uicc.hci.framework.HCIDevice;
import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIListener;
import uicc.hci.framework.HCIMessage;
import uicc.hci.services.readermode.ReaderListener;
import uicc.hci.services.readermode.ReaderMessage;
import uicc.hci.services.readermode.ReaderService;

public class Api_2_RMm_Sgp_2
extends Applet
implements ReaderListener {
    private static final byte INS_TEST_HCI_DISABLED = 1;
    private static final byte INS_TEST_RECEIVING_HCI_MESSAGE = 2;
    private static final byte INS_TEST_ILLIGALVALUE = 5;
    private static final byte INS_VERIFY_HCI_DISABLED = 17;
    private static final byte INS_VERIFY_RECEIVING_HCI_MESSAGE = 18;
    private static final byte INS_VERIFY_ILLIGALVALUE = 21;
    private byte featureToTest;
    private boolean exceptionHciDisabledThrown;
    private boolean exceptionIlligalValueThrown;
    private boolean exceptionReceivingHciThrown;
    private ReaderService readerService;

    public Api_2_RMm_Sgp_2() {
        this.register();
        try {
            this.readerService = (ReaderService)HCIDevice.getHCIService((short)2);
            this.readerService.register((HCIListener)this);
        }
        catch (HCIException e) {
            ISOException.throwIt((short)27012);
        }
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        new Api_2_RMm_Sgp_2();
    }

    public void process(APDU apdu) throws ISOException {
        if (this.selectingApplet()) {
            this.readerService.activateEvent((byte)80);
            return;
        }
        byte[] buffer = apdu.getBuffer();
        switch (buffer[1]) {
            case 1: {
                this.featureToTest = 1;
                break;
            }
            case 2: {
                this.featureToTest = (byte)2;
                break;
            }
            case 5: {
                this.featureToTest = (byte)5;
                break;
            }
            case 17: {
                if (!this.exceptionHciDisabledThrown) break;
                ISOException.throwIt((short)-28669);
                break;
            }
            case 18: {
                if (!this.exceptionReceivingHciThrown) break;
                ISOException.throwIt((short)-28668);
                break;
            }
            case 21: {
                if (!this.exceptionIlligalValueThrown) break;
                ISOException.throwIt((short)-28667);
            }
        }
    }

    public void onCallback(byte event, HCIMessage message) {
        ReaderMessage readerMessage = (ReaderMessage)message;
        if (readerMessage.getType() == 64 && event == 80) {
            switch (readerMessage.getReceiveBuffer()[0]) {
                case 0: {
                    byte paramID = 0;
                    switch (this.featureToTest) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            paramID = 2;
                            break;
                        }
                        case 5: {
                            paramID = -1;
                        }
                    }
                    try {
                        readerMessage.prepareAndSendGetParameterCommand(paramID);
                        break;
                    }
                    catch (HCIException e) {
                        if (e.getReason() == 3) {
                            if (this.featureToTest != 1) break;
                            this.exceptionHciDisabledThrown = true;
                            break;
                        }
                        if (e.getReason() != 7 || this.featureToTest != 2) break;
                        this.exceptionReceivingHciThrown = true;
                        break;
                    }
                    catch (SystemException e) {
                        if (e.getReason() != 1 || this.featureToTest != 5) break;
                        this.exceptionIlligalValueThrown = true;
                    }
                }
            }
        }
    }
}

