/*
 * Decompiled with CFR 0.152.
 */
package uicc.hci.test.services.readermode.api_2_rmm_sgp;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import uicc.hci.framework.HCIDevice;
import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIListener;
import uicc.hci.framework.HCIMessage;
import uicc.hci.framework.HCIService;
import uicc.hci.services.readermode.ReaderListener;
import uicc.hci.services.readermode.ReaderMessage;
import uicc.hci.services.readermode.ReaderService;

public class Api_2_RMm_Sgp_1
extends Applet
implements ReaderListener {
    private static final byte INS_GET_TYPE_A_UID = 1;
    private static final byte INS_GET_TYPE_A_ATQA = 2;
    private static final byte INS_GET_TYPE_A_APP_DATA = 3;
    private static final byte INS_GET_TYPE_A_SAK = 4;
    private static final byte INS_GET_TYPE_A_FWI = 5;
    private static final byte INS_GET_TYPE_A_DATA_R_MAX = 6;
    private static final byte INS_GET_TYPE_B_PUPI = 7;
    private static final byte INS_GET_TYPE_B_APP_DATA = 8;
    private static final byte INS_GET_TYPE_B_AFI = 9;
    private static final byte INS_GET_TYPE_B_HIGHER_LAYER_RESPONSE = 10;
    private static final byte INS_GET_TYPE_B_HIGHER_LAYER_DATA = 11;
    private byte featureToTest;
    private boolean testSuccess;
    private HCIService readerService;

    public Api_2_RMm_Sgp_1() {
        this.register();
        try {
            this.readerService = (ReaderService)HCIDevice.getHCIService((short)2);
            this.readerService.register((HCIListener)this);
            this.readerService.activateEvent((byte)1);
        }
        catch (HCIException e) {
            ISOException.throwIt((short)27012);
        }
    }

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        new Api_2_RMm_Sgp_1();
    }

    public void process(APDU apdu) throws ISOException {
        if (this.selectingApplet()) {
            this.readerService.activateEvent((byte)80);
            return;
        }
        byte[] buffer = apdu.getBuffer();
        byte INS = buffer[1];
        if (INS >= 1 && INS <= 11) {
            this.testSuccess = false;
            this.featureToTest = buffer[1];
            return;
        }
        if (INS == 32) {
            buffer[0] = this.featureToTest;
            buffer[1] = (byte)(!this.testSuccess ? 1 : 0);
            apdu.setOutgoingAndSend((short)0, (short)2);
        }
    }

    public void onCallback(byte event, HCIMessage message) {
        ReaderMessage readerMessage = (ReaderMessage)message;
        if (readerMessage.getType() == 64) {
            byte instruction;
            if (event == 80 && (instruction = readerMessage.getReceiveBuffer()[0]) == 0) {
                byte featureID;
                switch (this.featureToTest) {
                    case 1: {
                        featureID = 2;
                        break;
                    }
                    case 2: {
                        featureID = 4;
                        break;
                    }
                    case 3: {
                        featureID = 5;
                        break;
                    }
                    case 4: {
                        featureID = 3;
                        break;
                    }
                    case 5: {
                        featureID = 6;
                        break;
                    }
                    case 6: {
                        featureID = 1;
                        break;
                    }
                    case 7: {
                        featureID = 3;
                        break;
                    }
                    case 8: {
                        featureID = 4;
                        break;
                    }
                    case 9: {
                        featureID = 2;
                        break;
                    }
                    case 10: {
                        featureID = 1;
                        break;
                    }
                    case 11: {
                        featureID = 5;
                        break;
                    }
                    default: {
                        featureID = -1;
                    }
                }
                readerMessage.prepareAndSendGetParameterCommand(featureID);
            }
        } else if (readerMessage.getType() == -128) {
            switch (this.featureToTest) {
                case 1: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 2;
                    break;
                }
                case 2: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 4;
                    break;
                }
                case 3: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 5;
                    break;
                }
                case 4: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 3;
                    break;
                }
                case 5: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 6;
                    break;
                }
                case 6: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 1;
                    break;
                }
                case 7: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 3;
                    break;
                }
                case 8: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 4;
                    break;
                }
                case 9: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 2;
                    break;
                }
                case 10: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 1;
                    break;
                }
                case 11: {
                    this.testSuccess = readerMessage.getReceiveBuffer()[0] == 5;
                }
            }
        }
    }
}

