/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.sun.javacard.crypto.t;
import com.sun.javacard.crypto.u;
import com.sun.javacard.crypto.w;
import javacard.security.CryptoException;
import javacard.security.InitializedMessageDigest;

public abstract class MessageDigest {
    public static final byte ALG_SHA = 1;
    public static final byte ALG_MD5 = 2;
    public static final byte ALG_RIPEMD160 = 3;
    public static final byte ALG_SHA_256 = 4;
    public static final byte ALG_SHA_384 = 5;
    public static final byte ALG_SHA_512 = 6;
    public static final byte LENGTH_SHA = 20;
    public static final byte LENGTH_MD5 = 16;
    public static final byte LENGTH_RIPEMD160 = 20;
    public static final byte LENGTH_SHA_256 = 32;
    public static final byte LENGTH_SHA_384 = 48;
    public static final byte LENGTH_SHA_512 = 64;

    protected MessageDigest() {
    }

    public static final MessageDigest getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        u instance = null;
        switch (algorithm) {
            case 1: {
                instance = new t(algorithm);
                break;
            }
            case 4: {
                instance = new w(algorithm);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final InitializedMessageDigest getInitializedMessageDigestInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        if (externalAccess) {
            CryptoException.throwIt((short)3);
        }
        u instance = null;
        switch (algorithm) {
            case 1: {
                instance = new t(algorithm);
                break;
            }
            case 4: {
                instance = new w(algorithm);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public abstract byte getAlgorithm();

    public abstract byte getLength();

    public abstract short doFinal(byte[] var1, short var2, short var3, byte[] var4, short var5);

    public abstract void update(byte[] var1, short var2, short var3);

    public abstract void reset();
}

