/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.ExportComponent;
import com.sun.javacard.jcasm.mask.OutputFormatter;
import com.sun.javacard.jcasm.mask.RomMask;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class SizeOutputFormatter
extends OutputFormatter {
    private int nPackages;
    private int nClasses;
    private int nStaticFields;
    private int nFinalStaticFields;
    private int classSize;
    private int nMethods;
    private int nNativeMethods;
    private int methodSize;
    private int exTblCount;
    private int exportSize;
    private Vector packageStats = new Vector();
    private Vector classStats = new Vector();
    private Vector methodStats = new Vector();

    public SizeOutputFormatter(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void format(RomMask romMask) {
        Enumeration enumeration = romMask.packageElements();
        while (enumeration.hasMoreElements()) {
            JCPackage jCPackage = (JCPackage)enumeration.nextElement();
            ExportComponent exportComponent = new ExportComponent(jCPackage);
            ++this.nPackages;
            this.packageStats.addElement(new PackageStat(jCPackage.getIdentifier()));
            Enumeration enumeration2 = jCPackage.classElements();
            while (enumeration2.hasMoreElements()) {
                Object object;
                JCClass jCClass = (JCClass)enumeration2.nextElement();
                jCClass.relocate(0);
                ++this.nClasses;
                this.classSize += jCClass.size();
                this.classStats.addElement(new ClassStat(jCClass.getName(), jCClass.size()));
                Enumeration enumeration3 = jCClass.fieldElements();
                while (enumeration3.hasMoreElements()) {
                    object = (Field)enumeration3.nextElement();
                    ((Member)object).relocate(0);
                    int n = ((Member)object).getAttributes();
                    if (!Modifier.isStatic(n)) continue;
                    ++this.nStaticFields;
                    if (!Modifier.isFinal(n)) continue;
                    ++this.nFinalStaticFields;
                }
                object = jCClass.methodElements();
                while (object.hasMoreElements()) {
                    JCMethod jCMethod = (JCMethod)object.nextElement();
                    jCMethod.relocate(0);
                    int n = jCMethod.getAttributes();
                    if (Modifier.isNative(n)) {
                        ++this.nNativeMethods;
                        continue;
                    }
                    ++this.nMethods;
                    this.methodSize += jCMethod.size();
                    this.methodStats.addElement(new MethodStat(jCMethod.getName(), jCMethod.size()));
                    ExceptionTable exceptionTable = jCMethod.getExceptionTable();
                    if (exceptionTable == null) continue;
                    Enumeration enumeration4 = exceptionTable.elements();
                    while (enumeration4.hasMoreElements()) {
                        ExceptionTableEntry cfr_ignored_0 = (ExceptionTableEntry)enumeration4.nextElement();
                        ++this.exTblCount;
                    }
                }
                exportComponent.add(jCClass);
            }
            this.exportSize += exportComponent.size();
        }
    }

    public void write(OutputStream outputStream) {
        Object object;
        Object object2;
        PrintWriter printWriter = new PrintWriter(outputStream);
        Object[] objectArray = new Object[4];
        printWriter.println(Msg.getMessage("size.1"));
        objectArray[0] = new Integer(this.nPackages);
        printWriter.println(Msg.getMessage("size.2", objectArray));
        objectArray[0] = new Integer(this.nClasses);
        printWriter.println(Msg.getMessage("size.3", objectArray));
        objectArray[0] = new Integer(this.nMethods);
        printWriter.println(Msg.getMessage("size.4", objectArray));
        objectArray[0] = new Integer(this.nNativeMethods);
        printWriter.println(Msg.getMessage("size.5", objectArray));
        objectArray[0] = new Integer(this.nStaticFields);
        objectArray[1] = new Integer(this.nFinalStaticFields);
        printWriter.println(Msg.getMessage("size.6", objectArray));
        objectArray[0] = new Integer(this.classSize);
        printWriter.println(Msg.getMessage("size.7", objectArray));
        objectArray[0] = new Integer(this.methodSize);
        printWriter.println(Msg.getMessage("size.8", objectArray));
        objectArray[0] = new Integer(this.exTblCount * 8);
        objectArray[1] = new Integer(this.exTblCount);
        printWriter.println(Msg.getMessage("size.12", objectArray));
        objectArray[0] = new Integer(this.exportSize);
        printWriter.println(Msg.getMessage("size.13", objectArray));
        printWriter.println("");
        printWriter.println(Msg.getMessage("size.9", null));
        Enumeration enumeration = this.packageStats.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (PackageStat)enumeration.nextElement();
            objectArray[0] = ((PackageStat)object2).pid.getAid().toString();
            objectArray[1] = new Integer(((PackageStat)object2).pid.getMajorVersion());
            objectArray[2] = new Integer(((PackageStat)object2).pid.getMinorVersion());
            printWriter.println(Msg.getMessage("size.91", objectArray));
        }
        printWriter.println("");
        printWriter.println(Msg.getMessage("size.10", null));
        object2 = this.classStats.elements();
        while (object2.hasMoreElements()) {
            object = (ClassStat)object2.nextElement();
            printWriter.println(String.valueOf(((ClassStat)object).name) + ": " + ((ClassStat)object).size);
        }
        printWriter.println("");
        printWriter.println(Msg.getMessage("size.11", null));
        object = this.methodStats.elements();
        while (object.hasMoreElements()) {
            MethodStat methodStat = (MethodStat)object.nextElement();
            printWriter.println(String.valueOf(methodStat.name) + ": " + methodStat.size);
        }
        printWriter.flush();
    }

    static class PackageStat {
        PackageIdentifier pid;

        PackageStat(PackageIdentifier packageIdentifier) {
            this.pid = packageIdentifier;
        }
    }

    static class ClassStat {
        String name;
        int size;

        ClassStat(String string, int n) {
            this.name = string;
            this.size = n;
        }
    }

    static class MethodStat {
        String name;
        int size;

        MethodStat(String string, int n) {
            this.name = string;
            this.size = n;
        }
    }
}

