/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

class TypeDescriptorInfo {
    protected int token;
    protected TypeDescriptorEntry[] constantPoolTypes;
    protected Vector descVector;
    protected int descOffset;
    private int descBase;

    TypeDescriptorInfo(JCPackage jCPackage) {
        Object object;
        Object object2;
        ConstantPool constantPool = jCPackage.getConstantPool();
        this.constantPoolTypes = new TypeDescriptorEntry[constantPool.getCount()];
        this.descVector = new Vector(constantPool.getCount());
        this.descBase = this.descOffset = 2 + constantPool.getCount() * 2;
        int n = 0;
        while (n < this.constantPoolTypes.length) {
            object2 = constantPool.getConstantPoolEntry(n);
            if (((Info)object2).getType() != 1) {
                object = new TypeDescriptorEntry(jCPackage, (Info)object2, this.descOffset);
                int n2 = this.descVector.indexOf(object);
                if (n2 != -1) {
                    object = (TypeDescriptorEntry)this.descVector.elementAt(n2);
                } else {
                    this.descVector.addElement(object);
                    this.descOffset += ((TypeDescriptorEntry)object).size();
                }
                this.constantPoolTypes[n] = object;
            }
            ++n;
        }
        object2 = jCPackage.classElements();
        while (object2.hasMoreElements()) {
            Object object3;
            Object object4;
            object = (JCClass)object2.nextElement();
            Enumeration enumeration = ((JCClass)object).methodElements();
            while (enumeration.hasMoreElements()) {
                object4 = (JCMethod)enumeration.nextElement();
                object3 = new TypeDescriptorEntry((JCMethod)object4, this.descOffset);
                int n3 = this.descVector.indexOf(object3);
                if (n3 != -1) continue;
                this.descVector.addElement(object3);
                this.descOffset += ((TypeDescriptorEntry)object3).size();
            }
            object4 = ((JCClass)object).fieldElements();
            while (object4.hasMoreElements()) {
                object3 = (Field)object4.nextElement();
                TypeDescriptorEntry typeDescriptorEntry = new TypeDescriptorEntry((Field)object3, this.descOffset);
                int n4 = this.descVector.indexOf(typeDescriptorEntry);
                if (n4 != -1) continue;
                this.descVector.addElement(typeDescriptorEntry);
                this.descOffset += typeDescriptorEntry.size();
            }
        }
    }

    int getOffset(JCMethod jCMethod) {
        TypeDescriptorEntry typeDescriptorEntry = new TypeDescriptorEntry(jCMethod, this.descOffset);
        int n = this.descVector.indexOf(typeDescriptorEntry);
        if (n == -1) {
            this.descVector.addElement(typeDescriptorEntry);
            this.descOffset += typeDescriptorEntry.size();
        } else {
            typeDescriptorEntry = (TypeDescriptorEntry)this.descVector.elementAt(n);
        }
        return typeDescriptorEntry.getOffset();
    }

    int getOffset(Field field) {
        TypeDescriptorEntry typeDescriptorEntry = new TypeDescriptorEntry(field, this.descOffset);
        int n = this.descVector.indexOf(typeDescriptorEntry);
        if (n == -1) {
            this.descVector.addElement(typeDescriptorEntry);
            this.descOffset += typeDescriptorEntry.size();
        } else {
            typeDescriptorEntry = (TypeDescriptorEntry)this.descVector.elementAt(n);
        }
        return typeDescriptorEntry.getOffset();
    }

    int size() {
        int n = 2 + this.constantPoolTypes.length * 2;
        Enumeration enumeration = this.descVector.elements();
        while (enumeration.hasMoreElements()) {
            TypeDescriptorEntry typeDescriptorEntry = (TypeDescriptorEntry)enumeration.nextElement();
            n += typeDescriptorEntry.size();
        }
        return n;
    }

    byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeShort(this.constantPoolTypes.length);
            int n = 0;
            while (n < this.constantPoolTypes.length) {
                if (this.constantPoolTypes[n] == null) {
                    dataOutputStream.writeShort(65535);
                } else {
                    dataOutputStream.writeShort(this.constantPoolTypes[n].getOffset());
                }
                ++n;
            }
            Enumeration enumeration = this.descVector.elements();
            while (enumeration.hasMoreElements()) {
                TypeDescriptorEntry typeDescriptorEntry = (TypeDescriptorEntry)enumeration.nextElement();
                byte[] byArray = typeDescriptorEntry.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("constant_pool_count: " + this.constantPoolTypes.length + Msg.eol);
        int n = 0;
        while (n < this.constantPoolTypes.length) {
            if (n % 10 == 0) {
                stringBuffer.append("[" + n + "] ");
            }
            if (this.constantPoolTypes[n] == null) {
                stringBuffer.append(" " + Msg.toHexString((short)-1));
            } else {
                stringBuffer.append(" " + Msg.toHexString((short)this.constantPoolTypes[n].getOffset()));
            }
            if (n % 10 == 9) {
                stringBuffer.append(Msg.eol);
            }
            ++n;
        }
        if (n % 10 != 0) {
            stringBuffer.append(Msg.eol);
        }
        stringBuffer.append("type_desc[]: " + Msg.eol);
        int n2 = this.descBase;
        Enumeration enumeration = this.descVector.elements();
        while (enumeration.hasMoreElements()) {
            TypeDescriptorEntry typeDescriptorEntry = (TypeDescriptorEntry)enumeration.nextElement();
            stringBuffer.append("[" + Msg.toHexString((short)n2) + "] " + typeDescriptorEntry + Msg.eol);
            n2 += typeDescriptorEntry.size();
        }
        return stringBuffer.toString();
    }

    static class TypeDescriptorEntry {
        protected byte[] data;
        protected int offset;

        TypeDescriptorEntry(JCPackage jCPackage, Info info, int n) {
            this.offset = n;
            switch (info.getType()) {
                case 2: 
                case 5: {
                    String string = info.getDescriptor();
                    this.data = this.pack(this.simpleDesc(jCPackage, string, 0, string.length()));
                    return;
                }
                case 3: 
                case 4: 
                case 6: {
                    String string = info.getDescriptor();
                    this.data = this.pack(this.compoundDesc(jCPackage, string, 0));
                    return;
                }
            }
            throw new InternalError();
        }

        TypeDescriptorEntry(Field field, int n) {
            this.offset = n;
            FieldDescriptor fieldDescriptor = field.getDescriptor();
            String string = fieldDescriptor.getDescriptorString();
            if (string != null) {
                this.data = this.pack(this.simpleDesc(field.getParentClass().getParentPackage(), string, 0, string.length()));
                return;
            }
            ClassIdentifier classIdentifier = fieldDescriptor.getClassIdentifier();
            PackageIdentifier packageIdentifier = classIdentifier.getPackageIdentifier();
            int n2 = field.getParentClass().getParentPackage().getPackageToken(packageIdentifier);
            this.data = this.pack(this.simpleDesc(n2, classIdentifier.getClassToken(), fieldDescriptor.isArray()));
        }

        TypeDescriptorEntry(JCMethod jCMethod, int n) {
            this.offset = n;
            String string = jCMethod.getName();
            int n2 = string.indexOf(40);
            this.data = this.pack(this.compoundDesc(jCMethod.getParentClass().getParentPackage(), string, n2));
        }

        int getOffset() {
            return this.offset;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TypeDescriptorEntry)) {
                return false;
            }
            byte[] byArray = ((TypeDescriptorEntry)object).data;
            if (this.data.length != byArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.data.length) {
                if (this.data[n] != byArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        int size() {
            return this.data.length;
        }

        byte[] toByteArray() {
            return this.data;
        }

        private int[] compoundDesc(JCPackage jCPackage, String string, int n) {
            int n2;
            int[] nArray;
            Assert.PreCondition(string.charAt(n) == '(', "desc[offset] != '('");
            ++n;
            Vector<int[]> vector = new Vector<int[]>();
            int n3 = 0;
            while (n < string.length()) {
                nArray = null;
                block0 : switch (string.charAt(n)) {
                    case 'B': 
                    case 'I': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        nArray = this.simpleDesc(jCPackage, string, n, 1);
                        vector.addElement(nArray);
                        n3 += nArray.length;
                        ++n;
                        break;
                    }
                    case '[': {
                        switch (string.charAt(n + 1)) {
                            case 'B': 
                            case 'I': 
                            case 'S': 
                            case 'Z': {
                                nArray = this.simpleDesc(jCPackage, string, n, 2);
                                vector.addElement(nArray);
                                n3 += nArray.length;
                                n += 2;
                                break block0;
                            }
                            case 'L': {
                                n2 = string.indexOf(59, n);
                                Assert.Assert(n2 != -1, "end == -1");
                                nArray = this.simpleDesc(jCPackage, string, n, n2 - n + 1);
                                vector.addElement(nArray);
                                n3 += nArray.length;
                                n = n2 + 1;
                                break block0;
                            }
                        }
                        throw new InternalError();
                    }
                    case 'L': {
                        n2 = string.indexOf(59, n);
                        Assert.Assert(n2 != -1, "end == -1");
                        nArray = this.simpleDesc(jCPackage, string, n, n2 - n + 1);
                        vector.addElement(nArray);
                        n3 += nArray.length;
                        n = n2 + 1;
                        break;
                    }
                    case ')': {
                        ++n;
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            nArray = new int[n3];
            n2 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray2 = (int[])enumeration.nextElement();
                System.arraycopy(nArray2, 0, nArray, n2, nArray2.length);
                n2 += nArray2.length;
            }
            return nArray;
        }

        private int[] simpleDesc(JCPackage jCPackage, String string, int n, int n2) {
            int[] nArray;
            switch (string.charAt(n)) {
                case 'V': {
                    nArray = new int[]{1};
                    break;
                }
                case 'Z': {
                    nArray = new int[]{2};
                    break;
                }
                case 'B': {
                    nArray = new int[]{3};
                    break;
                }
                case 'S': {
                    nArray = new int[]{4};
                    break;
                }
                case 'I': {
                    nArray = new int[]{5};
                    break;
                }
                case 'L': {
                    int n3;
                    int n4;
                    nArray = new int[5];
                    nArray[0] = 6;
                    String string2 = string.substring(++n, n + (n2 -= 2));
                    int n5 = string2.indexOf(46);
                    if (n5 != -1) {
                        String string3 = string2.substring(0, n5);
                        String string4 = string2.substring(n5 + 1);
                        n4 = Integer.decode(string3) | 0x80;
                        n3 = Integer.decode(string4);
                    } else {
                        n4 = jCPackage.getDescriptorPackageToken(string2);
                        n3 = jCPackage.getDescriptorClassToken(string2);
                    }
                    nArray[1] = (byte)(n4 >> 4);
                    nArray[2] = (byte)n4;
                    nArray[3] = (byte)(n3 >> 4);
                    nArray[4] = (byte)n3;
                    break;
                }
                case '[': {
                    nArray = this.simpleDesc(jCPackage, string, n + 1, n2 - 1);
                    nArray[0] = nArray[0] | 8;
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            return nArray;
        }

        private int[] simpleDesc(int n, int n2, boolean bl) {
            int[] nArray = new int[]{bl ? -122 : 6, (byte)(n >> 4 | 8), (byte)n, (byte)(n2 >> 4), (byte)n2};
            return nArray;
        }

        private int[] simpleDesc(int n, boolean bl) {
            int[] nArray = new int[]{bl ? -122 : 6, (byte)(n >> 4 & 0xFF), (byte)(n & 0xFF), (byte)(n >> 4 & 0xFF), (byte)(n & 0xFF)};
            return nArray;
        }

        private byte[] pack(int[] nArray) {
            byte[] byArray = new byte[(nArray.length + 1) / 2 + 1];
            byArray[0] = (byte)nArray.length;
            int n = 1;
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2] & 0xFF;
                int n4 = 0;
                if (n2 + 1 < nArray.length) {
                    n4 = nArray[n2 + 1] & 0xFF;
                }
                byArray[n++] = (byte)(n3 << 4 | n4);
                n2 += 2;
            }
            return byArray;
        }

        public String toString() {
            return Msg.toHexString(this.toByteArray());
        }
    }
}

