/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class ReferenceLocationComponent
extends Component {
    protected Vector ref1Vector = new Vector();
    protected Vector ref2Vector = new Vector();
    private static int f_byteOffset;
    private static int f_byte2Offset;

    public ReferenceLocationComponent(JCPackage jCPackage) {
        super(jCPackage);
        f_byte2Offset = f_byteOffset = 1;
    }

    public void addOneByteOffset(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.ref1Vector.addElement(new Integer(n));
    }

    public void addTwoByteOffset(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.ref2Vector.addElement(new Integer(n));
    }

    public int dataSize() {
        return 4 + this.ref1Vector.size() + this.ref2Vector.size();
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object;
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeShort(this.ref1Vector.size());
            Enumeration enumeration = this.ref1Vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                dataOutputStream.writeByte((Integer)object);
            }
            dataOutputStream.writeShort(this.ref2Vector.size());
            object = this.ref2Vector.elements();
            while (object.hasMoreElements()) {
                Integer n = (Integer)object.nextElement();
                dataOutputStream.writeByte(n);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public void addException(JCClass jCClass) {
        if (Modifier.isInterface(jCClass.getAttributes())) {
            return;
        }
        Enumeration enumeration = jCClass.methodElements();
        while (enumeration.hasMoreElements()) {
            JCMethod jCMethod = (JCMethod)enumeration.nextElement();
            ExceptionTable exceptionTable = jCMethod.getExceptionTable();
            if (exceptionTable == null) continue;
            Enumeration enumeration2 = exceptionTable.elements();
            while (enumeration2.hasMoreElements()) {
                ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)enumeration2.nextElement();
                if (exceptionTableEntry.getCatchIndex() != 0) {
                    this.addTwoByteOffset(f_byte2Offset + 6);
                    f_byte2Offset = 2;
                } else {
                    f_byte2Offset += 8;
                }
                f_byteOffset += 8;
            }
        }
    }

    public void add(JCClass jCClass) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (Modifier.isInterface(jCClass.getAttributes())) {
            return;
        }
        Enumeration enumeration = jCClass.methodElements();
        while (enumeration.hasMoreElements()) {
            object6 = (JCMethod)enumeration.nextElement();
            f_byteOffset += ((JCMethod)object6).getMethodHeader().length;
            object5 = ((JCMethod)object6).statementElements();
            while (object5.hasMoreElements()) {
                object4 = (Statement)object5.nextElement();
                object3 = ((Statement)object4).getInstruction();
                ++f_byteOffset;
                object2 = ((Instruction)object3).operandElements();
                while (object2.hasMoreElements()) {
                    object = (Operand)object2.nextElement();
                    switch (((Operand)object).getType()) {
                        case 7: {
                            if (f_byteOffset > 255) {
                                int n2 = f_byteOffset / 255;
                                f_byteOffset %= 255;
                                n = 0;
                                while (n < n2) {
                                    this.addOneByteOffset(255);
                                    ++n;
                                }
                            }
                            this.addOneByteOffset(f_byteOffset);
                            f_byteOffset = ((Operand)object).size();
                            break;
                        }
                        default: {
                            f_byteOffset += ((Operand)object).size();
                        }
                    }
                }
            }
        }
        object6 = jCClass.methodElements();
        while (object6.hasMoreElements()) {
            object5 = (JCMethod)object6.nextElement();
            f_byte2Offset += ((JCMethod)object5).getMethodHeader().length;
            object4 = ((JCMethod)object5).statementElements();
            while (object4.hasMoreElements()) {
                object3 = (Statement)object4.nextElement();
                object2 = ((Statement)object3).getInstruction();
                ++f_byte2Offset;
                object = ((Instruction)object2).operandElements();
                while (object.hasMoreElements()) {
                    Operand operand = (Operand)object.nextElement();
                    switch (operand.getType()) {
                        case 8: {
                            if (f_byte2Offset > 255) {
                                n = f_byte2Offset / 255;
                                f_byte2Offset %= 255;
                                int n3 = 0;
                                while (n3 < n) {
                                    this.addTwoByteOffset(255);
                                    ++n3;
                                }
                            }
                            this.addTwoByteOffset(f_byte2Offset);
                            f_byte2Offset = operand.size();
                            break;
                        }
                        default: {
                            f_byte2Offset += operand.size();
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n = 0;
        stringBuffer.append("byte index count: " + this.ref1Vector.size() + Msg.eol);
        stringBuffer.append("// Offsets to Byte Indices[]: " + Msg.eol);
        Enumeration enumeration = this.ref1Vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Integer)enumeration.nextElement();
            stringBuffer.append(" " + Msg.toHexString((byte)((Integer)object).intValue()));
            if (++n % 16 != 0) continue;
            stringBuffer.append(Msg.eol);
        }
        if (n % 16 != 0) {
            stringBuffer.append(Msg.eol);
        }
        n = 0;
        stringBuffer.append("byte2 index count: " + this.ref2Vector.size() + Msg.eol);
        stringBuffer.append("// Offsets to Byte2 Indices[]: " + Msg.eol);
        object = this.ref2Vector.elements();
        while (object.hasMoreElements()) {
            Integer n2 = (Integer)object.nextElement();
            stringBuffer.append(" " + Msg.toHexString((byte)n2.intValue()));
            if (++n % 16 != 0) continue;
            stringBuffer.append(Msg.eol);
        }
        if (n % 16 != 0) {
            stringBuffer.append(Msg.eol);
        }
        return stringBuffer.toString();
    }
}

