/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ImportComponent
extends Component {
    protected Vector importVector = new Vector();

    public ImportComponent(JCPackage jCPackage) {
        super(jCPackage);
    }

    public void add(PackageIdentifier packageIdentifier) {
        Aid aid = packageIdentifier.getAid();
        int n = packageIdentifier.getMajorVersion();
        int n2 = packageIdentifier.getMinorVersion();
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException();
        }
        if (this.importVector.size() >= 255) {
            throw new InternalError();
        }
        this.importVector.addElement(new ImportEntry(aid, n, n2));
    }

    public int dataSize() {
        int n = 1;
        Enumeration enumeration = this.importVector.elements();
        while (enumeration.hasMoreElements()) {
            ImportEntry importEntry = (ImportEntry)enumeration.nextElement();
            n += importEntry.size();
        }
        return n;
    }

    int count() {
        return this.importVector.size();
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeByte(this.count());
            Enumeration enumeration = this.importVector.elements();
            while (enumeration.hasMoreElements()) {
                ImportEntry importEntry = (ImportEntry)enumeration.nextElement();
                byte[] byArray2 = importEntry.toByteArray();
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Count: " + this.importVector.size() + Msg.eol);
        Enumeration enumeration = this.importVector.elements();
        while (enumeration.hasMoreElements()) {
            ImportEntry importEntry = (ImportEntry)enumeration.nextElement();
            stringBuffer.append(String.valueOf(importEntry.toString()) + Msg.eol);
        }
        return stringBuffer.toString();
    }

    static class ImportEntry {
        private Aid aid;
        private int major;
        private int minor;

        ImportEntry(Aid aid, int n, int n2) {
            this.aid = aid;
            this.major = n;
            this.minor = n2;
        }

        int size() {
            return this.aid.getSize() + 3;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeByte(this.minor);
                dataOutputStream.writeByte(this.major);
                dataOutputStream.writeByte(this.aid.getSize());
                byte[] byArray = this.aid.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("minor_version: " + this.minor + ", major_version: " + this.major + ", AID_length: " + this.aid.getSize());
            stringBuffer.append(", AID: " + this.aid.toString());
            return stringBuffer.toString();
        }
    }
}

