/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Sortable;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

public class ExportComponent
extends Component {
    protected SortableVector exportVector = new SortableVector();
    boolean isLibrary;

    public ExportComponent(JCPackage jCPackage) {
        super(jCPackage);
        this.isLibrary = jCPackage.appletCount() <= 0;
    }

    public void add(JCClass jCClass) {
        int n = jCClass.getAttributes();
        if (!Modifier.isPublic(n) && !Modifier.isProtected(n)) {
            return;
        }
        if (this.isLibrary || jCClass.isShareable() && Modifier.isInterface(jCClass.getAttributes())) {
            this.exportVector.addElement(new ClassExportEntry(jCClass, this.isLibrary));
        }
    }

    public int dataSize() {
        int n = 1;
        Enumeration enumeration = this.exportVector.elements();
        while (enumeration.hasMoreElements()) {
            ClassExportEntry classExportEntry = (ClassExportEntry)enumeration.nextElement();
            n += classExportEntry.size();
        }
        return n;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.exportVector.sort();
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeByte(this.exportVector.size());
            int n = 0;
            Enumeration enumeration = this.exportVector.elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                ClassExportEntry classExportEntry = (ClassExportEntry)enumeration.nextElement();
                if (n++ != classExportEntry.getToken()) {
                    objectArray = new Object[]{this.parentPackage.getName()};
                    Msg.error("export.1", objectArray);
                    n = classExportEntry.getToken() + 1;
                }
                objectArray = classExportEntry.toByteArray();
                dataOutputStream.write((byte[])objectArray, 0, objectArray.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("class_count: " + this.exportVector.size() + Msg.eol);
        int n = 0;
        this.exportVector.sort();
        Enumeration enumeration = this.exportVector.elements();
        while (enumeration.hasMoreElements()) {
            ClassExportEntry classExportEntry = (ClassExportEntry)enumeration.nextElement();
            stringBuffer.append("class_exports[" + n + "]: " + classExportEntry);
            stringBuffer.append(Msg.eol);
            ++n;
        }
        return stringBuffer.toString();
    }

    static class ClassExportEntry
    implements Sortable {
        private SortableVector fieldVector;
        private SortableVector methodVector;
        private JCClass myClass;
        private int offset;
        private boolean isLibrary;

        ClassExportEntry(JCClass jCClass, boolean bl) {
            this.myClass = jCClass;
            this.isLibrary = bl;
            this.offset = jCClass.getRelocAddr();
            this.fieldVector = new SortableVector();
            this.methodVector = new SortableVector();
            if (bl) {
                Object object;
                Enumeration enumeration = this.myClass.fieldElements();
                while (enumeration.hasMoreElements()) {
                    object = (Field)enumeration.nextElement();
                    int n = ((Member)object).getAttributes();
                    if (Modifier.isFinal(n) && Modifier.isStatic(n) || !Modifier.isStatic(n) || !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                    this.fieldVector.addElement(new ExportEntry((Field)object));
                }
                object = jCClass.methodElements();
                while (object.hasMoreElements()) {
                    JCMethod jCMethod = (JCMethod)object.nextElement();
                    int n = jCMethod.getAttributes();
                    if (!Modifier.isStatic(n) && jCMethod.getName().indexOf("/<init>(") == -1 || !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                    this.methodVector.addElement(new ExportEntry(jCMethod));
                }
            }
        }

        int getToken() {
            return this.myClass.getClassIdentifier().getClassToken();
        }

        int size() {
            return 4 + this.fieldVector.size() * 2 + this.methodVector.size() * 2;
        }

        public int compare(Object object) {
            ClassExportEntry classExportEntry = (ClassExportEntry)object;
            if (this.getToken() < classExportEntry.getToken()) {
                return -1;
            }
            if (this.getToken() > classExportEntry.getToken()) {
                return 1;
            }
            return 0;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                Object object;
                Object object2;
                dataOutputStream.writeShort(this.offset);
                dataOutputStream.writeByte(this.fieldVector.size());
                dataOutputStream.writeByte(this.methodVector.size());
                this.fieldVector.sort();
                int n = 0;
                Enumeration enumeration = this.fieldVector.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (ExportEntry)enumeration.nextElement();
                    if (n++ != ((ExportEntry)object2).getToken()) {
                        object = new Object[]{this.myClass.getName()};
                        Msg.error("export.2", (Object[])object);
                        n = ((ExportEntry)object2).getToken() + 1;
                    }
                    object = ((ExportEntry)object2).toByteArray();
                    dataOutputStream.write((byte[])object, 0, ((byte[])object).length);
                }
                this.methodVector.sort();
                n = 0;
                object2 = this.methodVector.elements();
                while (object2.hasMoreElements()) {
                    Object[] objectArray;
                    object = (ExportEntry)object2.nextElement();
                    if (n++ != ((ExportEntry)object).getToken()) {
                        objectArray = new Object[]{this.myClass.getName()};
                        Msg.error("export.3", objectArray);
                        n = ((ExportEntry)object).getToken() + 1;
                    }
                    objectArray = ((ExportEntry)object).toByteArray();
                    dataOutputStream.write((byte[])objectArray, 0, objectArray.length);
                }
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                return null;
            }
            Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
            return byteArrayOutputStream.toByteArray();
        }

        public String toString() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Offset: " + this.offset);
            stringBuffer.append(", static_field_count: " + this.fieldVector.size());
            stringBuffer.append(", static_method_count: " + this.methodVector.size());
            this.fieldVector.sort();
            Enumeration enumeration = this.fieldVector.elements();
            while (enumeration.hasMoreElements()) {
                object = (ExportEntry)enumeration.nextElement();
                stringBuffer.append(String.valueOf(Msg.eol) + ((ExportEntry)object).toString());
            }
            this.methodVector.sort();
            object = this.methodVector.elements();
            while (object.hasMoreElements()) {
                ExportEntry exportEntry = (ExportEntry)object.nextElement();
                stringBuffer.append(String.valueOf(Msg.eol) + exportEntry.toString());
            }
            stringBuffer.append(Msg.eol);
            return stringBuffer.toString();
        }
    }

    static class ExportEntry
    implements Sortable {
        int token;
        int offset;

        ExportEntry(JCMethod jCMethod) {
            this.token = jCMethod.getMethodIdentifier().getMethodToken();
            this.offset = jCMethod.getRelocAddr();
        }

        ExportEntry(Field field) {
            this.token = field.getFieldIdentifier().getFieldToken();
            this.offset = field.getRelocAddr();
        }

        int getToken() {
            return this.token;
        }

        int size() {
            return 2;
        }

        public int compare(Object object) {
            ExportEntry exportEntry = (ExportEntry)object;
            if (this.token < exportEntry.getToken()) {
                return -1;
            }
            if (this.token > exportEntry.getToken()) {
                return 1;
            }
            return 0;
        }

        byte[] toByteArray() {
            byte[] byArray = new byte[]{(byte)(this.offset >> 8), (byte)this.offset};
            return byArray;
        }

        public String toString() {
            return Msg.toHexString((short)this.offset);
        }
    }
}

