/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ConstantPoolComponent
extends Component {
    protected Vector cpVector = new Vector();

    public ConstantPoolComponent(JCPackage jCPackage) {
        super(jCPackage);
        this.parentPackage = this.parentPackage;
    }

    public void addConstantPoolEntry(Info info) {
        this.cpVector.addElement(info);
    }

    public int dataSize() {
        int n = 2;
        Enumeration enumeration = this.cpVector.elements();
        while (enumeration.hasMoreElements()) {
            Info info = (Info)enumeration.nextElement();
            n += info.size();
        }
        return n;
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeShort(this.cpVector.size());
            Enumeration enumeration = this.cpVector.elements();
            while (enumeration.hasMoreElements()) {
                Info info = (Info)enumeration.nextElement();
                byte[] byArray2 = info.toByteArray(this.parentPackage);
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void add(Info info) {
        this.cpVector.addElement(info);
    }

    protected byte[] format(Info info) {
        int n = 0;
        byte[] byArray = new byte[4];
        int n2 = 0;
        byArray[n2++] = (byte)info.getType();
        switch (info.getType()) {
            case 1: {
                n = info.resolve().getRelocAddr();
                byArray[n2++] = (byte)(n >> 8 & 0xFF);
                byArray[n2++] = (byte)(n & 0xFF);
                byArray[n2++] = 0;
                break;
            }
            case 5: 
            case 6: {
                if (!info.isPackageInternal()) break;
                byArray[n2++] = 0;
                n = info.resolve().getRelocAddr();
                byArray[n2++] = (byte)(n >> 8 & 0xFF);
                byArray[n2++] = (byte)(n & 0xFF);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                byArray[n2++] = 0;
                byArray[n2++] = 0;
                byArray[n2++] = (byte)info.getClassToken();
                byArray[n2++] = (byte)info.resolve().getRelocAddr();
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Count: " + this.cpVector.size() + Msg.eol);
        int n = 0;
        Enumeration enumeration = this.cpVector.elements();
        while (enumeration.hasMoreElements()) {
            Info info = (Info)enumeration.nextElement();
            byte[] byArray = info.toByteArray(this.parentPackage);
            stringBuffer.append("ConstantPool[" + n++ + "]: " + Msg.toHexString(byArray) + Msg.eol);
        }
        return stringBuffer.toString();
    }
}

