/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

public class ClassComponent
extends Component {
    protected SortableVector classVector = new SortableVector();

    public ClassComponent(JCPackage jCPackage) {
        super(jCPackage);
    }

    void add(JCClass jCClass) {
        this.classVector.addElement(jCClass);
    }

    void assignAddresses() {
        int n = 0;
        this.classVector.sort();
        Enumeration enumeration = this.classVector.elements();
        while (enumeration.hasMoreElements()) {
            JCClass jCClass = (JCClass)enumeration.nextElement();
            jCClass.relocate(n);
            n += jCClass.size();
            int n2 = 0;
            Enumeration enumeration2 = jCClass.fieldElements();
            while (enumeration2.hasMoreElements()) {
                Field field = (Field)enumeration2.nextElement();
                if (Modifier.isStatic(field.getAttributes())) continue;
                field.relocate(n2);
                n2 += Math.max(2, field.size());
            }
        }
    }

    public int dataSize() {
        int n = 0;
        Enumeration enumeration = this.classVector.elements();
        while (enumeration.hasMoreElements()) {
            JCClass jCClass = (JCClass)enumeration.nextElement();
            n += jCClass.size();
        }
        return n;
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            Enumeration enumeration = this.classVector.elements();
            while (enumeration.hasMoreElements()) {
                JCClass jCClass = (JCClass)enumeration.nextElement();
                byte[] byArray2 = jCClass.toByteArray();
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        Enumeration enumeration = this.classVector.elements();
        while (enumeration.hasMoreElements()) {
            JCClass jCClass = (JCClass)enumeration.nextElement();
            byte[] byArray = jCClass.toByteArray();
            stringBuffer.append("Class: " + Msg.toHexString(byArray) + Msg.eol);
        }
        return stringBuffer.toString();
    }
}

