/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import java.util.Enumeration;
import java.util.Hashtable;

public class Statement {
    protected String label;
    protected Instruction ins;
    protected int relPc;
    protected int lineNumber;

    public Statement(String string, Instruction instruction) {
        this.label = string;
        this.ins = instruction;
        this.lineNumber = instruction.lineNumber;
    }

    public Statement(String string, Instruction instruction, int n) {
        this.label = string;
        this.ins = instruction;
        this.lineNumber = n;
    }

    public Statement(Instruction instruction) {
        this.ins = instruction;
    }

    public Instruction getInstruction() {
        return this.ins;
    }

    public int size() {
        return this.ins.size();
    }

    protected void methodFixup(Hashtable hashtable) {
        this.ins.methodFixup(hashtable, this.relPc);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        byArray[0] = (byte)this.ins.getOpcode();
        int n = 1;
        Enumeration enumeration = this.ins.elements();
        while (enumeration.hasMoreElements()) {
            Operand operand = (Operand)enumeration.nextElement();
            int n2 = operand.getValue();
            switch (operand.size()) {
                case 1: {
                    byArray[n++] = (byte)n2;
                    break;
                }
                case 2: {
                    byArray[n++] = (byte)(n2 >> 8);
                    byArray[n++] = (byte)(n2 & 0xFF);
                    break;
                }
                case 4: {
                    byArray[n++] = (byte)(n2 >> 24);
                    byArray[n++] = (byte)((n2 & 0xFF0000) >> 16);
                    byArray[n++] = (byte)((n2 & 0xFF00) >> 8);
                    byArray[n++] = (byte)(n2 & 0xFF);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.label != null) {
            stringBuffer.append(String.valueOf(this.label) + ": ");
        }
        stringBuffer.append(String.valueOf(this.ins) + ";" + Msg.eol);
        return stringBuffer.toString();
    }
}

