/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.SymbolTable;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class MethodTable {
    protected boolean optimize = true;
    public static final int MAX_ENTRIES = 128;
    protected JCClass parentClass;
    protected int base;
    protected boolean isPublic;
    protected Vector nameVector;
    protected JCMethod[] methods;

    public MethodTable(JCClass jCClass, int n, boolean bl) {
        Assert.PreCondition(n <= 128, "base <= MAX_ENTRIES");
        this.parentClass = jCClass;
        this.base = n;
        this.isPublic = bl;
        this.nameVector = new Vector();
    }

    public void addMethod(String string) {
        this.nameVector.addElement(string);
        if (this.nameVector.size() > 128) {
            String string2 = this.isPublic ? Msg.getMessage("methodTable.public") : Msg.getMessage("methodTable.package");
            Object[] objectArray = new Object[]{string2, this.parentClass.getName()};
            Msg.error("methodTable.0", objectArray);
        }
    }

    public void resolve(SymbolTable symbolTable, boolean bl) {
        int n;
        if (this.base > this.nameVector.size()) {
            String string = this.isPublic ? Msg.getMessage("methodTable.public") : Msg.getMessage("methodTable.package");
            Object[] objectArray = new Object[]{string, this.parentClass.getName()};
            Msg.error("methodTable.1", objectArray);
            return;
        }
        Enumeration enumeration = this.nameVector.elements();
        if (this.optimize) {
            n = 0;
            while (n < this.base) {
                enumeration.nextElement();
                ++n;
            }
        }
        this.methods = new JCMethod[this.getCount()];
        n = 0;
        int n2 = this.base - 1;
        block1: while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ++n2;
            JCClass jCClass = this.parentClass;
            JCMethod jCMethod = (JCMethod)symbolTable.get(String.valueOf(jCClass.getName()) + "/" + string);
            while (jCMethod == null) {
                if ((jCClass = jCClass.getSuperClass()) == null) {
                    if (!bl || bl && !this.isPublic) {
                        Object[] objectArray = new Object[]{string, this.parentClass.getName()};
                        Msg.error("methodTable.2", objectArray);
                        ++n;
                        continue block1;
                    }
                    ++n;
                    continue block1;
                }
                jCMethod = (JCMethod)symbolTable.get(String.valueOf(jCClass.getName()) + "/" + string);
            }
            if (Modifier.isStatic(jCMethod.getAttributes())) {
                Object[] objectArray = new Object[]{string, this.parentClass.getName()};
                Msg.error("methodTable.2", objectArray);
                ++n;
                continue;
            }
            int n3 = jCMethod.getMethodIdentifier().getMethodToken();
            if ((n3 & 0x7F) != n2) {
                String string2 = this.isPublic ? Msg.getMessage("methodTable.public") : Msg.getMessage("methodTable.package");
                Object[] objectArray = new Object[]{new Integer(n3), jCMethod.getName(), string2, jCMethod.getParentClass().getName()};
                Msg.error("methodTable.3", objectArray);
                ++n;
                continue;
            }
            this.methods[n++] = jCMethod;
        }
    }

    public int getBase() {
        if (this.optimize) {
            return this.base;
        }
        return 0;
    }

    public int getCount() {
        int n = this.optimize ? this.nameVector.size() - this.base : this.nameVector.size();
        Assert.Assert(n >= 0, "count < 0: " + this.parentClass.getName());
        return n;
    }

    public Enumeration elements() {
        return new MethodTableEnumerator(this.methods);
    }

    public Enumeration nameElements() {
        return this.nameVector.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isPublic) {
            stringBuffer.append(".publicMethodTable ");
        } else {
            stringBuffer.append(".packageMethodTable ");
        }
        stringBuffer.append(String.valueOf(this.getBase()) + " {" + Msg.eol);
        Enumeration enumeration = this.nameElements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\t" + (String)enumeration.nextElement() + Msg.eol);
        }
        stringBuffer.append("}" + Msg.eol);
        return stringBuffer.toString();
    }

    static class MethodTableEnumerator
    implements Enumeration {
        private int index;
        private JCMethod[] table;

        MethodTableEnumerator(JCMethod[] jCMethodArray) {
            this.table = jCMethodArray;
        }

        public boolean hasMoreElements() {
            return this.table != null && this.index < this.table.length;
        }

        public Object nextElement() {
            if (this.table == null || this.index >= this.table.length) {
                throw new NoSuchElementException("MethodTableEnumerator");
            }
            return this.table[this.index++];
        }
    }
}

