/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.SortableVector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCPackage {
    protected String inputSpec;
    protected PackageIdentifier packageIdentifier;
    protected String name;
    protected int line;
    protected Vector importVector;
    protected Vector appletVector;
    protected ConstantPool constantPool;
    protected SortableVector classVector;
    public Hashtable symbolTable;
    protected boolean usesIntegers;
    protected Hashtable descriptorTable;

    public JCPackage(String string, PackageIdentifier packageIdentifier, int n) {
        Assert.PreCondition(string != null, "name != null");
        Assert.PreCondition(packageIdentifier != null, "packageId != null");
        this.name = string;
        this.packageIdentifier = packageIdentifier;
        this.line = n;
        this.classVector = new SortableVector();
        this.importVector = new Vector();
        this.appletVector = new Vector();
        this.constantPool = new ConstantPool(this);
        this.symbolTable = new Hashtable();
        this.descriptorTable = new Hashtable();
    }

    public String getName() {
        return this.name;
    }

    public PackageIdentifier getIdentifier() {
        return this.packageIdentifier;
    }

    public PackageIdentifier getIdentifier(int n) {
        Assert.PreCondition(n >= 0, "token >= 0");
        if (n >= this.importVector.size()) {
            return null;
        }
        return (PackageIdentifier)this.importVector.elementAt(n);
    }

    public int getPackageToken(PackageIdentifier packageIdentifier) {
        int n = this.importVector.size();
        int n2 = 0;
        while (n2 < n) {
            PackageIdentifier packageIdentifier2 = (PackageIdentifier)this.importVector.elementAt(n2);
            if (packageIdentifier.equals(packageIdentifier2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean usesIntegers() {
        return this.usesIntegers;
    }

    protected void usesIntegers(boolean bl) {
        this.usesIntegers = bl;
    }

    public Enumeration constantPoolElements() {
        return this.constantPool.elements();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Info getConstantPoolEntry(int n) {
        return this.constantPool.getConstantPoolEntry(n);
    }

    public void addConstantPoolEntry(Info info) {
        this.constantPool.addConstantPoolEntry(info);
    }

    protected void addApplet(AppletDeclarator appletDeclarator) {
        this.appletVector.addElement(appletDeclarator);
    }

    public int appletCount() {
        return this.appletVector.size();
    }

    public Enumeration appletElements() {
        return this.appletVector.elements();
    }

    protected void addImport(PackageIdentifier packageIdentifier) {
        this.importVector.addElement(packageIdentifier);
    }

    public Enumeration importElements() {
        return this.importVector.elements();
    }

    public void addClass(JCClass jCClass) {
        Assert.PreCondition(jCClass != null, "jcClass != null");
        String string = jCClass.getName();
        if (this.symbolTable.containsKey(string)) {
            Object[] objectArray = new Object[]{string, this.name};
            Msg.error("package.0", objectArray);
            return;
        }
        ClassIdentifier classIdentifier = jCClass.getClassIdentifier();
        if (this.symbolTable.containsKey(classIdentifier)) {
            Object[] objectArray = new Object[]{new Integer(classIdentifier.getClassToken()), this.name};
            Msg.error("package.1", objectArray);
            return;
        }
        jCClass.sortFields();
        this.symbolTable.put(string, jCClass);
        this.symbolTable.put(classIdentifier, jCClass);
        this.classVector.addElement(jCClass);
    }

    public Enumeration classElements() {
        return this.classVector.elements();
    }

    public void addDescriptor(String string, int n, int n2) {
        this.descriptorTable.put(string, new Descriptor(string, n, n2));
    }

    public int getDescriptorPackageToken(String string) {
        Descriptor descriptor = (Descriptor)this.descriptorTable.get(string);
        if (descriptor != null) {
            return descriptor.getPackageToken() | 0x80;
        }
        Object[] objectArray = (Object[])this.symbolTable.get(String.valueOf(this.name) + "/" + string);
        if (objectArray == null) {
            objectArray = (JCClass)this.symbolTable.get(string);
        }
        if (objectArray != null) {
            int n = objectArray.getRelocAddr();
            return n >> 8 & 0xFF;
        }
        objectArray = new Object[]{string};
        Msg.error("package.3", objectArray);
        return 0;
    }

    public int getDescriptorClassToken(String string) {
        Descriptor descriptor = (Descriptor)this.descriptorTable.get(string);
        if (descriptor != null) {
            return descriptor.getClassToken();
        }
        Object[] objectArray = (Object[])this.symbolTable.get(String.valueOf(this.name) + "/" + string);
        if (objectArray == null) {
            objectArray = (JCClass)this.symbolTable.get(string);
        }
        if (objectArray != null) {
            int n = objectArray.getRelocAddr();
            return n & 0xFF;
        }
        objectArray = new Object[]{string};
        Msg.error("package.4", objectArray);
        return 0;
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".package " + this.name + " {" + Msg.eol);
        stringBuffer.append(".version " + this.packageIdentifier.getMajorVersion() + "." + this.packageIdentifier.getMinorVersion() + " ;" + Msg.eol);
        stringBuffer.append(".aid " + this.packageIdentifier.getAid() + " ;" + Msg.eol);
        stringBuffer.append(".imports {" + Msg.eol);
        Enumeration enumeration = this.importVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (PackageIdentifier)enumeration.nextElement();
            stringBuffer.append(String.valueOf(object) + ";" + Msg.eol);
        }
        stringBuffer.append("}" + Msg.eol);
        stringBuffer.append(String.valueOf(this.constantPool.toString()) + Msg.eol);
        object = this.classVector.elements();
        while (object.hasMoreElements()) {
            JCClass jCClass = (JCClass)object.nextElement();
            stringBuffer.append(jCClass);
        }
        stringBuffer.append("}" + Msg.eol);
        return stringBuffer.toString();
    }

    static class Descriptor {
        private int packageToken;
        private int classToken;

        Descriptor(String string, int n, int n2) {
            this.packageToken = n;
            this.classToken = n2;
        }

        int getPackageToken() {
            return this.packageToken;
        }

        int getClassToken() {
            return this.classToken;
        }
    }
}

