/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Statement;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JCMethod
extends Member {
    protected MethodIdentifier methodIdentifier;
    protected JCClass parentClass;
    protected Vector statementVector = new Vector();
    protected ExceptionTable exceptionTable;
    protected int stack;
    protected int locals;
    private Hashtable symbolTable = new Hashtable();
    private int relPc;
    private int size;
    private boolean abstractError;
    private boolean nativeError;
    private boolean sizeError;

    public JCMethod(JCClass jCClass, int n, String string, int n2) {
        super(n, string, n2, 0);
        this.parentClass = jCClass;
    }

    public JCMethod(JCClass jCClass, int n, String string, MethodIdentifier methodIdentifier, int n2) {
        this(jCClass, n, string, n2);
        this.methodIdentifier = methodIdentifier;
    }

    public MethodIdentifier getMethodIdentifier() {
        return this.methodIdentifier;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    public void addExceptionTableEntry(ExceptionTableEntry exceptionTableEntry) {
        if (this.exceptionTable == null) {
            this.exceptionTable = new ExceptionTable(this);
        }
        this.exceptionTable.addExceptionEntry(exceptionTableEntry);
    }

    public ExceptionTable getExceptionTable() {
        return this.exceptionTable;
    }

    public Enumeration statementElements() {
        return this.statementVector.elements();
    }

    protected void setStack(int n) {
        this.stack = n;
    }

    protected void setLocals(int n) {
        this.locals = n;
    }

    public int getParams() {
        char c;
        int n = Modifier.isStatic(this.attributes) ? 0 : 1;
        int n2 = 0;
        while (this.name.charAt(n2++) != '(') {
        }
        while ((c = this.name.charAt(n2++)) != ')') {
            block0 : switch (c) {
                case 'B': 
                case 'S': 
                case 'Z': {
                    ++n;
                    break;
                }
                case 'I': {
                    n += 2;
                    break;
                }
                case '[': {
                    c = this.name.charAt(n2++);
                    switch (c) {
                        case 'L': {
                            while (this.name.charAt(n2++) != ';') {
                            }
                        }
                        case 'B': 
                        case 'I': 
                        case 'S': 
                        case 'Z': {
                            ++n;
                            break block0;
                        }
                    }
                    Assert.Assert(false, "getParams()");
                    break;
                }
                case 'L': {
                    while (this.name.charAt(n2++) != ';') {
                    }
                    ++n;
                    break;
                }
                default: {
                    Assert.Assert(false, "getParams()");
                }
            }
        }
        return n;
    }

    public byte[] getMethodHeader() {
        if (Modifier.isInterface(this.parentClass.getAttributes()) && Modifier.isAbstract(this.getAttributes())) {
            return new byte[0];
        }
        int n = this.getParams();
        byte[] byArray = this.stack > 15 || n > 15 || this.locals > 15 ? new byte[]{-128, (byte)this.stack, (byte)n, (byte)this.locals} : new byte[]{(byte)(this.stack & 0xF), (byte)(n << 4 | this.locals & 0xF)};
        if (Modifier.isAbstract(this.attributes)) {
            byArray[0] = (byte)(byArray[0] | 0x40);
        }
        if (Modifier.isNative(this.attributes)) {
            byArray[0] = (byte)(byArray[0] | 0x20);
        }
        return byArray;
    }

    protected void addStatement(Statement statement) {
        Object[] objectArray;
        if (Modifier.isAbstract(this.attributes) && !this.abstractError) {
            Object[] objectArray2 = new Object[]{this.name};
            Msg.error("method.1", objectArray2);
            this.abstractError = true;
            return;
        }
        if (Modifier.isNative(this.attributes) && !this.nativeError) {
            Object[] objectArray3 = new Object[]{this.name};
            Msg.error("method.2", objectArray3);
            this.nativeError = true;
            return;
        }
        this.statementVector.addElement(statement);
        if (statement.label != null) {
            objectArray = statement.label.toLowerCase();
            if (this.symbolTable.containsKey(objectArray)) {
                Object[] objectArray4 = new Object[]{objectArray, new Integer(statement.lineNumber)};
                Msg.error("method.0", objectArray4);
            }
            this.symbolTable.put(objectArray, new Integer(this.relPc));
        }
        statement.relPc = this.relPc;
        this.relPc += statement.size();
        this.size += statement.size();
        if (this.size > Short.MAX_VALUE && !this.sizeError) {
            objectArray = new Object[]{this.name};
            Msg.error("method.3", objectArray);
            this.sizeError = true;
        }
    }

    public int size() {
        if (Modifier.isInterface(this.parentClass.getAttributes()) && Modifier.isAbstract(this.getAttributes())) {
            return 0;
        }
        int n = this.getParams();
        if (this.stack > 15 || n > 15 || this.locals > 15) {
            return this.size + 4;
        }
        return this.size + 2;
    }

    protected void methodFixup() {
        if (this.symbolTable == null) {
            return;
        }
        Enumeration enumeration = this.statementVector.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            statement.methodFixup(this.symbolTable);
        }
        if (this.exceptionTable != null) {
            this.exceptionTable.fixup(this.symbolTable);
        }
        if (!Globals.debug) {
            this.symbolTable = null;
        }
    }

    public byte[] toByteArray() {
        if (this.size() == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = this.getMethodHeader();
            dataOutputStream.write(byArray, 0, byArray.length);
            Enumeration enumeration = this.statementVector.elements();
            while (enumeration.hasMoreElements()) {
                Statement statement = (Statement)enumeration.nextElement();
                byte[] byArray2 = statement.toByteArray();
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        Assert.PostCondition(this.size() == byteArrayOutputStream.size(), "size() != bos.size()");
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".method " + super.toString());
        if (this.methodIdentifier != null) {
            stringBuffer.append(" <" + this.methodIdentifier + ">");
        }
        stringBuffer.append(" {" + Msg.eol);
        stringBuffer.append("method_header: " + Msg.toHexString(this.getMethodHeader()) + Msg.eol);
        Enumeration enumeration = this.statementVector.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            stringBuffer.append(statement);
        }
        if (this.exceptionTable != null) {
            stringBuffer.append(String.valueOf(this.exceptionTable) + Msg.eol);
        }
        if (Globals.debug && this.symbolTable != null) {
            stringBuffer.append("// " + this.symbolTable + Msg.eol);
        }
        stringBuffer.append("}" + Msg.eol);
        return stringBuffer.toString();
    }
}

