/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ClassIdentifier;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import java.util.Enumeration;
import java.util.Vector;

public class InterfaceTable {
    public static final int MAX_ENTRIES = 128;
    protected int lineNumber;
    protected ClassIdentifier classIdentifier;
    protected String className;
    protected Vector indexVector;
    protected JCClass parentClass;
    protected JCClass resolvedTo;

    InterfaceTable(JCClass jCClass, ClassIdentifier classIdentifier, int n) {
        Assert.PreCondition(classIdentifier != null, "classIdentifier != null");
        this.parentClass = jCClass;
        this.classIdentifier = classIdentifier;
        this.lineNumber = n;
        this.indexVector = new Vector();
    }

    InterfaceTable(JCClass jCClass, String string, int n) {
        Assert.PreCondition(string != null, "className != null");
        this.parentClass = jCClass;
        this.className = string;
        this.lineNumber = n;
        this.indexVector = new Vector();
    }

    public void addInterfaceIndex(int n) {
        if (this.indexVector.size() >= 128) {
            Object[] objectArray = new Object[]{new Integer(this.lineNumber)};
            Msg.error("itable.0", objectArray);
            return;
        }
        this.indexVector.addElement(new Integer(n));
    }

    public String getName() {
        return this.className;
    }

    public ClassIdentifier getClassIdentifier() {
        return this.classIdentifier;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    public void resolve(JCClass jCClass) {
        Assert.PreCondition(jCClass != null, "c != null");
        this.resolvedTo = jCClass;
    }

    public JCClass resolve() {
        Assert.PreCondition(this.resolvedTo != null, "resolvedTo != null");
        return this.resolvedTo;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    public byte[] toByteArray() {
        Object object;
        byte[] byArray = new byte[this.size()];
        int n = 0;
        if (this.isResolved()) {
            int n2 = this.resolvedTo.getRelocAddr();
            byArray[n++] = (byte)(n2 >> 8 & 0xFF);
            byArray[n++] = (byte)(n2 & 0xFF);
        } else {
            JCPackage jCPackage = this.parentClass.getParentPackage();
            object = this.classIdentifier.getPackageIdentifier();
            byArray[n++] = (byte)(jCPackage.getPackageToken((PackageIdentifier)object) | 0x80);
            byArray[n++] = (byte)this.classIdentifier.getClassToken();
        }
        byArray[n++] = (byte)this.indexVector.size();
        Enumeration enumeration = this.indexVector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Integer)enumeration.nextElement();
            byArray[n++] = (byte)((Integer)object).intValue();
        }
        return byArray;
    }

    public int size() {
        return 3 + this.indexVector.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(".interfaceTable ");
        stringBuffer.append(this.classIdentifier != null ? this.classIdentifier.toString() : this.className);
        stringBuffer.append(" {" + Msg.eol);
        Enumeration enumeration = this.indexVector.elements();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            stringBuffer.append(String.valueOf(Msg.toHexString((byte)n.intValue())) + ";" + Msg.eol);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

