/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.checkers;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JLocalVarTableAttr;
import com.sun.javacard.classfile.attributes.JLocalVariable;
import com.sun.javacard.classfile.attributes.JRuntimeVisibleAnnotationsAttribute;
import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.classfile.instructions.JInstrCpByteRef;
import com.sun.javacard.classfile.instructions.JInstrCpShortRef;
import com.sun.javacard.classfile.instructions.JInstrFieldRef;
import com.sun.javacard.classfile.instructions.JInstrMethodRef;
import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.classfile.instructions.JavaByteCode;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.checkers.BCCheckingTable;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.lang.reflect.Modifier;
import java.util.ResourceBundle;

public class SubsetChecker {
    protected static ResourceBundle messages = ResourceBundle.getBundle("com/sun/javacard/converter/MessagesBundle");
    ConversionProfile conversion_profile;

    public SubsetChecker(ConversionProfile conversion_profile) {
        this.conversion_profile = conversion_profile;
    }

    public void check(JPackage java_package) {
        JClassFile[] java_classes = java_package.getClasses();
        this.checkPackage(java_package);
        try {
            for (int i = 0; i < java_classes.length; ++i) {
                this.checkClass(java_classes[i]);
            }
        }
        catch (ConverterException converterException) {
            // empty catch block
        }
    }

    private void checkPackage(JPackage java_package) {
        String name = java_package.getPackageName();
        if (name.length() > 255) {
            Notifier.error("subset.60");
        }
    }

    private void checkClass(JClassFile java_class) throws ConverterException {
        if (java_class.isInterfaceType() && !java_class.isAbstract()) {
            Object[] args = new Object[]{java_class.getClassName().replace('/', '.')};
            Notifier.warning("flags.1", args);
            java_class.setAbstract(true);
        }
        this.checkClassAttributes(java_class);
        JField[] java_fields = java_class.getFields();
        for (int i = 0; i < java_fields.length; ++i) {
            this.checkField(java_fields[i], java_class);
        }
        JMethod[] java_methods = java_class.getMethods();
        for (int i = 0; i < java_methods.length; ++i) {
            this.checkMethod(java_methods[i], java_class.getClassName());
        }
    }

    private void checkClassAttributes(JClassFile java_class) throws ConverterException {
        JAttribute[] attrs = java_class.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!(attrs[i] instanceof JRuntimeVisibleAnnotationsAttribute)) continue;
            Object[] args = new Object[]{java_class.getClassName().replace('/', '.')};
            Notifier.warning("subset.66", args);
        }
    }

    private void checkField(JField java_field, JClassFile java_class) {
        Object[] args;
        int access_flags;
        String class_name = java_class.getClassName();
        String descriptor = java_field.getFieldDescriptor();
        String field_name = java_field.getFieldName();
        String error_string = this.checkType(descriptor);
        if (error_string != null) {
            Object[] args2 = new Object[]{class_name.replace('/', '.'), error_string, field_name};
            Notifier.error("subset.1", args2);
        }
        if (Modifier.isVolatile(access_flags = java_field.getAccessFlags())) {
            args = new Object[]{class_name.replace('/', '.'), "volatile", field_name};
            Notifier.error("subset.2", args);
        }
        if (Modifier.isTransient(access_flags)) {
            args = new Object[]{class_name.replace('/', '.'), "transient", field_name};
            Notifier.error("subset.2", args);
        }
        if (!(!java_class.isInterfaceType() || DataType.isPrimitiveType(descriptor) && Modifier.isStatic(access_flags) && Modifier.isFinal(access_flags))) {
            args = new Object[]{class_name.replace('/', '.'), field_name};
            Notifier.error("subset.63", args);
        }
        if (!this.conversion_profile.mask && Modifier.isStatic(access_flags) && (this.conversion_profile.applets_profile == null || this.conversion_profile.applets_profile.length == 0) && java_field.getValue() != null && DataType.isArrayType(descriptor)) {
            args = new Object[]{class_name.replace('/', '.'), field_name};
            Notifier.error("subset.22", args);
        }
    }

    private void checkMethod(JMethod java_method, String class_name) throws ConverterException {
        Object[] args;
        String error_string;
        Object[] args2;
        int access_flags = java_method.getAccessFlags();
        String method_name = java_method.getMethodName();
        String descriptor = java_method.getMethodDescriptor();
        if (Modifier.isSynchronized(access_flags)) {
            args2 = new Object[]{class_name.replace('/', '.'), "synchronized", method_name};
            Notifier.error("subset.4", args2);
        }
        if (Modifier.isStrict(access_flags)) {
            args2 = new Object[]{class_name.replace('/', '.'), "strictfp", method_name};
            Notifier.error("subset.4", args2);
        }
        if (Modifier.isNative(access_flags) && !this.conversion_profile.mask) {
            args2 = new Object[]{class_name.replace('/', '.'), "native", method_name};
            Notifier.error("subset.4", args2);
        }
        if (Modifier.isTransient(access_flags)) {
            args2 = new Object[]{class_name.replace('/', '.'), method_name};
            Notifier.error("subset.7", args2);
        }
        String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
        for (int i = 0; i < param_descs.length; ++i) {
            error_string = this.checkType(param_descs[i]);
            if (error_string == null) continue;
            args = new Object[]{class_name.replace('/', '.'), error_string, method_name};
            Notifier.error("subset.5", args);
        }
        String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
        error_string = this.checkType(return_desc);
        if (error_string != null && error_string != null) {
            args = new Object[]{class_name.replace('/', '.'), error_string, method_name};
            Notifier.error("subset.6", args);
        }
        this.checkLocalVariables(java_method, class_name);
        this.checkByteCodes(java_method, class_name);
    }

    private void checkLocalVariables(JMethod java_method, String class_name) throws ConverterException {
        JCodeAttr code_attr = java_method.getCodeAttr();
        if (code_attr == null) {
            return;
        }
        JLocalVarTableAttr local_var_attr = code_attr.getLocalVarTableAttr();
        if (this.conversion_profile.debug && local_var_attr == null && code_attr.getMaxLocals() > 0) {
            Object[] args = new String[]{class_name.replace('/', '.')};
            Notifier.error("locals.1", args);
            throw new ConverterException();
        }
        if (local_var_attr == null) {
            return;
        }
        JLocalVariable[] locals = local_var_attr.getLocalVars();
        int numParams = MethodDescriptor.getParamDescriptors(java_method.getMethodDescriptor()).length;
        if (!java_method.isStatic()) {
            ++numParams;
        }
        for (int i = numParams; i < locals.length; ++i) {
            JLocalVariable local = locals[i];
            if (DataType.getType(local.getDescriptor()) != 8) continue;
            Object[] args = new String[]{class_name.replace('/', '.'), "char"};
            Notifier.error("subset.40", args);
        }
    }

    private void checkByteCodes(JMethod java_method, String class_name) {
        String method_name = java_method.getMethodName();
        block15: for (JInstruction code = java_method.getCode(); code != null; code = code.getNextInstr()) {
            int opcode = code.getOpcode();
            if (method_name.equals("<clinit>")) {
                if (BCCheckingTable.isClinitUnsupported(opcode)) {
                    Object[] args = new Object[]{class_name.replace('/', '.'), JavaByteCode.getMnemonic(opcode)};
                    Notifier.error(code.getSourceLineNumber(), "subset.20", args);
                } else if (BCCheckingTable.isClinitUnreasonable(opcode)) {
                    Object[] args = new Object[]{class_name.replace('/', '.'), JavaByteCode.getMnemonic(opcode)};
                    Notifier.error(code.getSourceLineNumber(), "subset.21", args);
                }
            } else if (!BCCheckingTable.isAlwaysSupported(opcode)) {
                this.reportErrforUnsupportedByteCode(class_name, method_name, java_method.getMethodDescriptor(), code);
            }
            switch (opcode) {
                case 193: {
                    String check_class_name = ((JInstrClassRef)code).getClassName();
                    String error_string = this.checkType(check_class_name);
                    if (error_string == null) continue block15;
                    Object[] args = new Object[]{class_name.replace('/', '.'), error_string};
                    Notifier.error(code.getSourceLineNumber(), "subset.31", args);
                    continue block15;
                }
                case 192: {
                    String check_class_name = ((JInstrClassRef)code).getClassName();
                    String error_string = this.checkType(check_class_name);
                    if (error_string == null) continue block15;
                    Object[] args = new Object[]{class_name.replace('/', '.'), error_string};
                    Notifier.error(code.getSourceLineNumber(), "subset.32", args);
                    continue block15;
                }
                case 189: {
                    String check_class_name = ((JInstrClassRef)code).getClassName();
                    if (!check_class_name.startsWith("[")) continue block15;
                    Object[] args = new Object[]{class_name.replace('/', '.')};
                    Notifier.error(code.getSourceLineNumber(), "subset.45", args);
                    continue block15;
                }
                case 188: {
                    Object[] args;
                    int atype = ((JInstrByteIndex)code).getIndex();
                    switch (atype) {
                        case 5: {
                            args = new Object[]{class_name.replace('/', '.'), "char[]"};
                            Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                            break;
                        }
                        case 6: {
                            args = new Object[]{class_name.replace('/', '.'), "float[]"};
                            Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                            break;
                        }
                        case 7: {
                            args = new Object[]{class_name.replace('/', '.'), "double[]"};
                            Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                            break;
                        }
                        case 11: {
                            args = new Object[]{class_name.replace('/', '.'), "long[]"};
                            Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                            break;
                        }
                        case 10: {
                            if (this.conversion_profile.int_supported) break;
                            args = new Object[]{class_name.replace('/', '.'), "int[]"};
                            Notifier.error(code.getSourceLineNumber(), "subset.33", args);
                        }
                    }
                    continue block15;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    Object[] args;
                    String error_string;
                    JInstrMethodRef method_instr = (JInstrMethodRef)code;
                    String descriptor = method_instr.getDescriptor();
                    String invoked_method_class_name = method_instr.getClassName();
                    String invoked_method_name = method_instr.getMethodName();
                    String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
                    for (int j = 0; j < param_descs.length; ++j) {
                        error_string = this.checkType(param_descs[j]);
                        if (error_string == null) continue;
                        args = new Object[]{class_name.replace('/', '.'), error_string, Names.getMethodNameInJavaStyle(invoked_method_name, descriptor), invoked_method_class_name.replace('/', '.')};
                        Notifier.error(code.getSourceLineNumber(), "subset.34", args);
                    }
                    String return_desc = MethodDescriptor.getReturnDescriptor(descriptor);
                    error_string = this.checkType(return_desc);
                    if (error_string == null) continue block15;
                    args = new Object[]{class_name.replace('/', '.'), error_string, Names.getMethodNameInJavaStyle(invoked_method_name, descriptor), invoked_method_class_name.replace('/', '.')};
                    Notifier.error(code.getSourceLineNumber(), "subset.35", args);
                    continue block15;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    JInstrFieldRef field_instr = (JInstrFieldRef)code;
                    String field_class_name = field_instr.getClassName();
                    String field_name = field_instr.getFieldName();
                    String descriptor = field_instr.getDescriptor();
                    String error_string = this.checkType(descriptor);
                    if (error_string == null) continue block15;
                    Object[] args = new Object[]{class_name.replace('/', '.'), error_string, field_name, field_class_name.replace('/', '.')};
                    Notifier.error(code.getSourceLineNumber(), "subset.36", args);
                    continue block15;
                }
            }
        }
    }

    private String checkType(String descriptor) {
        int type = DataType.getType(descriptor);
        switch (type) {
            case 8: {
                return "char";
            }
            case 6: {
                return "double";
            }
            case 5: {
                return "float";
            }
            case 4: {
                return "long";
            }
            case 10: {
                if (DataType.isMultiDimensionArray(descriptor)) {
                    return messages.getString("other.1");
                }
                if (descriptor.equals("Ljava/lang/String;")) {
                    return "String";
                }
                if (descriptor.equals("[Ljava/lang/String;")) {
                    return "String[]";
                }
                if (descriptor.equals("[C")) {
                    return "char[]";
                }
                if (descriptor.equals("[D")) {
                    return "double[]";
                }
                if (descriptor.equals("[F")) {
                    return "float[]";
                }
                if (!descriptor.equals("[J")) break;
                return "long[]";
            }
        }
        return null;
    }

    private void reportErrforUnsupportedByteCode(String class_name, String method_name, String method_descriptor, JInstruction code) {
        int opcode = code.getOpcode();
        int line_num = code.getSourceLineNumber();
        switch (opcode) {
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                Object[] args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.40", args);
                break;
            }
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                Object[] args = new String[]{class_name.replace('/', '.'), "float"};
                Notifier.error(line_num, "subset.40", args);
                break;
            }
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                Object[] args = new String[]{class_name.replace('/', '.'), "long"};
                Notifier.error(line_num, "subset.40", args);
                break;
            }
            case 14: 
            case 15: {
                int value = opcode - 14;
                Object[] args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                int value = opcode - 11;
                Object[] args = new String[]{class_name.replace('/', '.'), "float"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 9: 
            case 10: {
                int value = opcode - 9;
                Object[] args = new String[]{class_name.replace('/', '.'), "long"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                Object[] args;
                int value;
                int value_type = opcode == 18 ? ((JInstrCpByteRef)code).getValueType() : ((JInstrCpShortRef)code).getValueType();
                if (value_type == 5) {
                    value = opcode - 9;
                    args = new String[]{class_name.replace('/', '.'), "float"};
                    Notifier.error(line_num, "subset.41", args);
                }
                if (value_type == 20) {
                    value = opcode - 9;
                    args = new String[]{class_name.replace('/', '.'), "String"};
                    Notifier.error(line_num, "subset.41", args);
                }
                if (value_type == 4) {
                    value = opcode - 9;
                    args = new String[]{class_name.replace('/', '.'), "long"};
                    Notifier.error(line_num, "subset.41", args);
                }
                if (value_type != 6) break;
                value = opcode - 9;
                args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.41", args);
                break;
            }
            case 146: {
                Object[] args = new String[]{class_name.replace('/', '.'), "char"};
                Notifier.error(line_num, "subset.42", args);
                break;
            }
            case 135: {
                Object[] args = new String[]{class_name.replace('/', '.'), "double"};
                Notifier.error(line_num, "subset.43", args);
                break;
            }
            case 134: {
                Object[] args = new String[]{class_name.replace('/', '.'), "float"};
                Notifier.error(line_num, "subset.43", args);
                break;
            }
            case 133: {
                Object[] args = new String[]{class_name.replace('/', '.'), "long"};
                Notifier.error(line_num, "subset.43", args);
                break;
            }
            case 194: 
            case 195: {
                Notifier.error(line_num, "subset.44", class_name.replace('/', '.'));
                break;
            }
            case 197: {
                Notifier.error(line_num, "subset.45", class_name.replace('/', '.'));
                break;
            }
            case 200: 
            case 201: {
                Object[] args = new String[]{class_name.replace('/', '.'), Names.getMethodNameInJavaStyle(method_name, method_descriptor)};
                Notifier.error("subset.46", args);
                break;
            }
        }
    }

    public void check(JcPackage jc_package) {
        JcClass[] jc_classes = jc_package.getClasses();
        if (jc_classes.length > 255) {
            Notifier.error("subset.10", jc_package.getPackageName());
        }
        for (int i = 0; i < jc_classes.length; ++i) {
            this.checkClass(jc_package, jc_classes[i]);
        }
        this.checkAccessControl(jc_package);
    }

    private void checkClass(JcPackage jc_package, JcClass jc_class) {
        int i;
        int access_flags;
        String class_name = jc_class.getClassName();
        if (jc_class.isInterfaceType() && jc_class.getSuperInterfaces().length > 14) {
            Notifier.error("subset.9", class_name.replace('/', '.'));
        }
        if (jc_class.getSuperInterfaces().length > 15 && !jc_class.isInterfaceType()) {
            Notifier.error("subset.8", class_name.replace('/', '.'));
        }
        int pub_static_fields_count = 0;
        int instance_field_size = 0;
        JcField[] jc_fields = jc_class.getFields();
        for (int i2 = 0; i2 < jc_fields.length; ++i2) {
            int access_flags2 = jc_fields[i2].getAccessFlags();
            if (Modifier.isStatic(access_flags2)) {
                if (!Modifier.isPublic(access_flags2) && !Modifier.isProtected(access_flags2) || jc_fields[i2].isFinal()) continue;
                ++pub_static_fields_count;
                continue;
            }
            String descriptor = jc_fields[i2].getFieldDescriptor();
            if (DataType.getType(descriptor) == 3) {
                instance_field_size += 2;
                continue;
            }
            ++instance_field_size;
        }
        if (pub_static_fields_count > 256) {
            Notifier.error("subset.11", class_name.replace('/', '.'));
        }
        if (pub_static_fields_count > 255 && jc_class.isAPIElement(jc_package)) {
            Notifier.error("subset.61", class_name.replace('/', '.'));
        }
        String[] supers = jc_class.getPublicSuperClasses();
        for (int i3 = 0; i3 < supers.length; ++i3) {
            JcClass jc_cl = jc_package.getClass(supers[i3]);
            if (jc_cl == null) continue;
            jc_fields = jc_cl.getFields();
            for (int j = 0; j < jc_fields.length; ++j) {
                access_flags = jc_fields[j].getAccessFlags();
                if (Modifier.isStatic(access_flags)) continue;
                String descriptor = jc_fields[j].getFieldDescriptor();
                if (DataType.getType(descriptor) == 3) {
                    instance_field_size += 2;
                    continue;
                }
                ++instance_field_size;
            }
        }
        if (instance_field_size > 255) {
            Notifier.error("subset.12", class_name.replace('/', '.'));
        }
        JcMethod[] jc_methods = jc_class.getMethods();
        int pub_static_method_count = 0;
        for (i = 0; i < jc_methods.length; ++i) {
            access_flags = jc_methods[i].getAccessFlags();
            if (Modifier.isStatic(access_flags)) {
                if (!Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) continue;
                ++pub_static_method_count;
                continue;
            }
            if (!jc_methods[i].getMethodName().equals("<init>") || !Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) continue;
            ++pub_static_method_count;
        }
        if (pub_static_method_count > 256) {
            Notifier.error("subset.13", class_name.replace('/', '.'));
        }
        if (pub_static_method_count > 255 && jc_class.isAPIElement(jc_package)) {
            Notifier.error("subset.62", class_name.replace('/', '.'));
        }
        if (jc_class.getPublicMethodTable().getMethods().length > 128) {
            if (jc_class.isInterfaceType()) {
                Notifier.error("subset.19", class_name.replace('/', '.'));
            } else {
                Notifier.error("subset.14", class_name.replace('/', '.'));
            }
        }
        if (jc_class.getPackageMethodTable().getMethods().length > 128) {
            Notifier.error("subset.15", class_name.replace('/', '.'));
        }
        for (i = 0; i < jc_methods.length; ++i) {
            this.checkMethod(jc_methods[i], class_name);
        }
    }

    private void checkAccessControl(JcPackage jc_package) {
        JcClass[] jc_classes = jc_package.getClasses();
        for (int i = 0; i < jc_classes.length; ++i) {
            JcClass super_class;
            JcClass jc_class = jc_classes[i];
            if (jc_class.isInterfaceType()) {
                if (!Modifier.isPublic(jc_class.getAccessFlags())) continue;
                String[] super_interfaces = jc_class.getSuperInterfaces();
                for (int j = 0; j < super_interfaces.length; ++j) {
                    int access_flags;
                    JcClass jc_interface = jc_package.getClass(super_interfaces[j]);
                    if (jc_interface == null || Modifier.isPublic(access_flags = jc_interface.getAccessFlags())) continue;
                    Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), jc_interface.getClassName().replace('/', '.')};
                    Notifier.error("subset.50", args);
                }
                continue;
            }
            String super_class_name = jc_class.getSuperClassName();
            if (super_class_name == null || (super_class = jc_package.getClass(super_class_name)) == null) continue;
            JcMethod[] jc_methods = jc_class.getMethods();
            MethodDefinition[] pack_methods = super_class.getPackageMethodTable().getMethods();
            for (int j = 0; j < jc_methods.length; ++j) {
                JcMethod jc_method = jc_methods[j];
                int access_flags = jc_method.getAccessFlags();
                if (!Modifier.isPublic(access_flags) && !Modifier.isProtected(access_flags)) continue;
                for (int k = 0; k < pack_methods.length; ++k) {
                    MethodDefinition pack_method = pack_methods[k];
                    if (!jc_method.getMethodSignature().equals(pack_method.getMethodSignature())) continue;
                    Object[] args = new String[]{jc_class.getClassName().replace('/', '.'), Names.getMethodNameInJavaStyle(jc_method.getMethodName(), jc_method.getMethodDescriptor())};
                    Notifier.error("subset.51", args);
                }
            }
        }
    }

    private void checkMethod(JcMethod jc_method, String class_name) {
        String method_name = jc_method.getMethodName();
        if (jc_method.getMaxLocals() + jc_method.getNargs() > 255) {
            Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
            Notifier.error("subset.16", args);
        }
        this.checkByteCode(jc_method, class_name);
    }

    private void checkByteCode(JcMethod jc_method, String class_name) {
        String method_name = jc_method.getMethodName();
        int code_size = 0;
        block4: for (JcInstruction code = jc_method.getCode(); code != null; code = code.getNextInstr()) {
            code_size += code.getSizeInBytes();
            int opcode = code.getOpcode();
            switch (opcode) {
                case 117: 
                case 118: {
                    int num_cases = ((JcInstrLookupSwitch)code).getNumMatchPairs();
                    if (num_cases <= 65536) continue block4;
                    Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
                    Notifier.error("subset.18", args);
                    continue block4;
                }
                case 115: 
                case 116: {
                    JcInstrTableSwitch table_switch_instr = (JcInstrTableSwitch)code;
                    int num_cases = table_switch_instr.getHighValue() - table_switch_instr.getLowValue() + 1;
                    if (num_cases <= 65536) continue block4;
                    Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
                    Notifier.error("subset.18", args);
                    continue block4;
                }
            }
        }
        if (code_size > Short.MAX_VALUE) {
            Object[] args = new Object[]{class_name.replace('/', '.'), method_name};
            Notifier.error("subset.17", args);
        }
    }
}

