/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.clientsamples.transit;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadT1Client;
import com.sun.javacard.clientsamples.transit.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public abstract class Terminal
implements Constants {
    protected static String hostName = "localhost";
    protected static int port = 9025;
    protected static byte[] staticKeyData = null;
    private CadT1Client cad;
    private Cipher cipher;
    private Mac mac;
    private SecretKey sessionKey;
    private SecretKeyFactory keyFactory;

    public Terminal(String string, int n, byte[] byArray) throws Exception {
        Socket socket = new Socket(string, n);
        socket.setTcpNoDelay(true);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
        this.cad = new CadT1Client((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
        DESKeySpec dESKeySpec = new DESKeySpec(this.fixParity(byArray));
        this.keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = this.keyFactory.generateSecret(dESKeySpec);
        this.cipher = Cipher.getInstance("DES/CBC/NoPadding");
        this.cipher.init(1, (Key)secretKey, new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
    }

    void powerUp() throws Exception {
        this.cad.powerUp();
    }

    void powerDown() {
        try {
            this.cad.powerDown(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void selectApplet() throws Exception {
        Apdu apdu = new Apdu();
        apdu.command[0] = 0;
        apdu.command[1] = -92;
        apdu.command[2] = 4;
        apdu.command[3] = 0;
        apdu.setDataIn(AID_TRANSIT);
        System.out.println(apdu);
        this.cad.exchangeApdu(apdu);
        System.out.println(apdu);
        if (apdu.getStatus() == 36864) {
            System.out.println("OK");
        } else {
            System.out.println("Error: " + apdu.getStatus());
        }
    }

    void verifyPIN(byte[] byArray) throws Exception {
        Apdu apdu = new Apdu();
        apdu.command[0] = 0;
        apdu.command[1] = 32;
        apdu.command[2] = 0;
        apdu.command[3] = 0;
        apdu.setDataIn(byArray);
        System.out.println(apdu);
        this.cad.exchangeApdu(apdu);
        System.out.println(apdu);
        if (apdu.getStatus() == 36864) {
            System.out.println("OK");
        } else {
            System.out.println("Error: " + apdu.getStatus());
        }
    }

    void initializeSession() throws Exception {
        Apdu apdu = new Apdu();
        apdu.command[0] = -128;
        apdu.command[1] = 48;
        apdu.command[2] = 0;
        apdu.command[3] = 0;
        byte[] byArray = this.generateHostChallenge();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        apdu.setDataIn(byArray2);
        System.err.println(apdu);
        this.cad.exchangeApdu(apdu);
        System.err.println(apdu);
        if (apdu.getStatus() == 36864) {
            byArray2 = apdu.getDataOut();
            byte[] byArray3 = new byte[4];
            System.arraycopy(byArray2, 0, byArray3, 0, 4);
            byte[] byArray4 = this.generateKeyDerivationData(byArray, byArray3);
            this.generateSessionKey(byArray4);
            this.mac = new Mac(this.sessionKey);
            if (!this.mac.checkMAC(byArray2, apdu.getLe() - 8)) {
                throw new Exception("InitializeSession: Wrong signature");
            }
        } else {
            throw new Exception("InitializeSession: Error " + apdu.getStatus());
        }
        System.err.println("OK");
    }

    protected byte[] processRequest(byte by, byte[] byArray) throws Exception {
        byte[] byArray2;
        Apdu apdu = new Apdu();
        apdu.command[0] = -128;
        apdu.command[1] = 64;
        apdu.command[2] = 0;
        apdu.command[3] = 0;
        byte[] byArray3 = new byte[2 + byArray.length + 8];
        byArray3[0] = by;
        byArray3[1] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, 2, byArray.length);
        this.mac.generateMAC(byArray3, 2 + byArray.length);
        apdu.setDataIn(byArray3);
        System.err.println(apdu);
        this.cad.exchangeApdu(apdu);
        System.err.println(apdu);
        if (apdu.getStatus() == 36864 && this.mac.checkMAC(byArray2 = apdu.getDataOut(), apdu.getLe() - 8)) {
            byArray3 = new byte[apdu.getLe() - 10];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            return byArray3;
        }
        return null;
    }

    protected byte[] generateHostChallenge() {
        byte[] byArray = new byte[4];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    protected byte[] generateKeyDerivationData(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 0, byArray3, 0, 4);
        System.arraycopy(byArray2, 0, byArray3, 4, 4);
        return byArray3;
    }

    protected void generateSessionKey(byte[] byArray) throws Exception {
        byte[] byArray2 = this.pad(byArray, 0, byArray.length, this.cipher.getBlockSize());
        byte[] byArray3 = this.fixParity(this.cipher.doFinal(byArray2));
        DESKeySpec dESKeySpec = new DESKeySpec(byArray3);
        this.sessionKey = this.keyFactory.generateSecret(dESKeySpec);
    }

    protected short getShort(byte[] byArray, int n) {
        return (short)((short)byArray[n] << 8 | byArray[n + 1]);
    }

    protected void copyShort(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >> 8 & 0xFF);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    protected static void commonUsage() {
        System.out.println("[-?] [-h <hostname>] [-p <port>] -k <8-bytes DES static key> <command list>");
    }

    protected static int parseCommonArgs(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            if (stringArray[n].equals("-?")) {
                Terminal.commonUsage();
                System.exit(0);
                continue;
            }
            if (stringArray[n].equals("-h")) {
                if (++n < stringArray.length) {
                    hostName = stringArray[n];
                    continue;
                }
                Terminal.commonUsage();
                System.exit(2);
                continue;
            }
            if (stringArray[n].equals("-p")) {
                if (++n < stringArray.length) {
                    port = Integer.valueOf(stringArray[n]);
                    continue;
                }
                Terminal.commonUsage();
                System.exit(2);
                continue;
            }
            if (stringArray[n].equals("-k")) {
                if (++n < stringArray.length) {
                    if (stringArray[n].length() / 2 < 8) {
                        Terminal.commonUsage();
                        System.exit(1);
                    }
                    staticKeyData = Terminal.parseByteArray(stringArray[n]);
                    continue;
                }
                Terminal.commonUsage();
                System.exit(2);
                continue;
            }
            if (stringArray[n].equals("--")) {
                ++n;
                break;
            }
            Terminal.commonUsage();
            System.exit(2);
        }
        if (staticKeyData == null) {
            return -1;
        }
        return n;
    }

    private static byte[] parseByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i / 2] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return byArray;
    }

    private byte[] pad(byte[] byArray, int n, int n2, int n3) {
        int n4 = n2 + 1;
        int n5 = n4 / n3;
        int n6 = n4 - n5 * n3;
        if (n6 > 0) {
            ++n5;
        }
        byte[] byArray2 = new byte[n5 * n3];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byArray2[n2] = -128;
        for (int i = n2 + 1; i < byArray2.length; ++i) {
            byArray2[i] = 0;
        }
        return byArray2;
    }

    private byte[] fixParity(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0;
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] & 0xFE);
            for (int j = 1; j < 8; ++j) {
                if ((byArray[i] & (byte)(1 << j)) == 0) continue;
                n = (short)(n + 1);
            }
            if (n % 2 != 0) continue;
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] | 1);
        }
        return byArray;
    }

    private class Mac {
        private Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");

        public Mac(SecretKey secretKey) throws Exception {
            this.cipher.init(1, (Key)secretKey, new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0}));
        }

        protected boolean checkMAC(byte[] byArray, int n) throws Exception {
            byte[] byArray2 = Terminal.this.pad(byArray, 0, n, this.cipher.getBlockSize());
            byte[] byArray3 = this.cipher.doFinal(byArray2);
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray3, byArray3.length - 8, byArray4, 0, 8);
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray, n, byArray5, 0, 8);
            return Arrays.equals(byArray4, byArray5);
        }

        protected short generateMAC(byte[] byArray, int n) throws Exception {
            byte[] byArray2 = Terminal.this.pad(byArray, 0, n, this.cipher.getBlockSize());
            byte[] byArray3 = this.cipher.doFinal(byArray2);
            System.arraycopy(byArray3, byArray3.length - 8, byArray, n, 8);
            return (short)(n + 8);
        }
    }
}

